package com.yeejoin.precontrol.common.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.CompanyDto;
import com.yeejoin.precontrol.common.entity.Company;
import com.yeejoin.precontrol.common.param.CompanyParam;
import com.yeejoin.precontrol.common.vo.BadCompanyVo;
import com.yeejoin.precontrol.common.vo.CompanyExcelVo;
import com.yeejoin.precontrol.common.vo.SelectPersonVo;
import com.yeejoin.precontrol.common.vo.TeamVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/**
 * 企业基本信息 服务类
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface ICompanyService extends IService<Company> {

	/**
	 * 分页查询企业
	 * 
	 * @param pageable
	 * @param param
	 * @return
	 */
	Page pageInfo(CommonPageableDto pageable, CompanyParam param);

	/**
	 * 企业查询
	 * 
	 * @return
	 */
	List<HashMap<String, Object>> companySelect();

	/**
	 * 导出企业信息
	 * 
	 * @param param
	 * @return
	 */
	List<CompanyExcelVo> exportExcel(CompanyParam param);

	/**
	 * 导入企业信息
	 * 
	 * @param companyList
	 */
	void importExcel(List<CompanyExcelVo> companyList);

	/**
	 * 分包商违规系数查询
	 * 
	 * @param isBad
	 * @param isAllStatus
	 * @param pageable
	 * @param badCompanyVo
	 * @return
	 */
	IPage<BadCompanyVo> pageBadCompany(boolean isBad, boolean isAllStatus, CommonPageableDto pageable,
			BadCompanyVo badCompanyVo);

	/**
	 * 同步平台分包商数据（部门）
	 *
	 * @param jsonObject
	 * @return
	 */
	boolean syncCompany(JSONObject jsonObject);

	/**
	 * 企业导入
	 * 
	 * @param file
	 * @throws Exception
	 */
	void companyImport(MultipartFile file) throws Exception;

	/**
	 * 保存或者更新企业
	 * 
	 * @param companyDto
	 * @return
	 */
	Company saveOrUpdateCompany(CompanyDto companyDto);

	/**
	 * 根据id查询分包商
	 * 
	 * @param id
	 * @return
	 */
	CompanyDto selectById(Long id);

	/**
	 * 查询账户信息
	 * 
	 * @param id
	 * @return
	 */
	List<TeamVo> deptQueryWithAccount(Long id);

	SelectPersonVo deptQuery(Long companyId, String roleName, Long projectId);

	SelectPersonVo teamQuery(Long deptId, String roleName, Long projectId);

	Collection<DepartmentModel> platDeptQuery(String orgcode, Boolean noFbs);

	List<Company> getByOrgCode(String orgcode);

	List<Company> byPlatFbsDeptOrgCode(String orgcode);
}
