package com.yeejoin.amos.supervision.common.remote;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.supervision.business.feign.Business;
import com.yeejoin.amos.supervision.business.util.CommonResponse;
import com.yeejoin.amos.supervision.core.common.response.PointCheckInfoBusinessRespone;
import com.yeejoin.amos.supervision.core.common.response.TaskInfoBusinessRespone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;


@Service("remoteServer")
public class RemoteServer {

	private static final Logger logger = LoggerFactory.getLogger(RemoteServer.class);

	
	//@Autowired
    private Business business;
	
	//@Autowired
   // private  Remote3D remote3D;
	/**
	 * 三维服务地址
	 *//*
	@Value("${params.remote3DUrl}")
	private String remote3DUrl;

	*//**
	 * 检查点状态推送接口
	 *//*
	@Value("${params.checkStatusPushUrl}")
	private String checkStatusPushUrl;

	*//**
	 * 任务状态推送接口
	 *//*
	@Value("${params.errorTaskPushUrl}")
	private String errorTaskPushUrl;

	*//**
	 * 巡检点同步
	 *//*
	@Value("${params.pointInfoPushUrl}")
	private String pointInfoPushUrl;

	*//**
	 * 路线同步
	 *//*
	@Value("${params.routeInfoPushUrl}")
	private String routeInfoPushUrl;

	*//**
	 * 巡检消息推送3d
	 * 
	 * @param pointCheckInfo
	 * @return
	 *//*

	*//**
	 * yewu服务地址
	 *//*
	@Value("${params.remoteBusiness}")
	private String remoteBusinessUrl;

	*//**
	 * 检查点状态推送业务接口
	 *//*
	@Value("${params.pointStatusPushUrl}")
	private String pointStatusPushUrl;

	*//**
	 * 任务状态推送业务接口
	 *//*
	@Value("${params.errorTaskPushToBUrl}")
	private String errorTaskPushToBUrl;*/

	/**
	 * xunjian推送接口
	 */
	/*@Value("${params.remotePUrl}")
	private String remotePUrl;*/
	/*@Value("${params.checkStatusPushToPUrl}")
	private String checkStatusPushToPUrl;*/

//	public boolean checkStatusPush(PointCheckInfoRespone pointCheckInfo) {
//		boolean flag = true;
//		/*String ip = remote3DUrl;
//		String url = checkStatusPushUrl;
//		HttpMethod method = HttpMethod.POST;
//		if (!ip.equals("") && !url.equals("")) {
//			List<PointCheckInfoRespone> list = new ArrayList<>();
//			list.add(pointCheckInfo);
//			logger.debug("mesg=========" + pointCheckInfo);
//			flag = commonMethod(list, ip, url, method);
//		}*/
//		List<PointCheckInfoRespone> list = new ArrayList<>();
//		list.add(pointCheckInfo);
//		CommonResponse commonResponse = remote3D.checkStatusPush(list);
//				
//		flag = commonResponse.getResult().equals("SUCCESS");
//		return flag;
//	}

	/**
	 * 巡检消息推送业务
	 * 
	 * 
	 * @return
	 */
	public boolean checkStatusPushToB(PointCheckInfoBusinessRespone pb) {
		boolean flag = true;
		/*String ip = remoteBusinessUrl;   // 推送地址
		String url = pointStatusPushUrl;   // 推送路径
		HttpMethod method = HttpMethod.PUT;   //请求方法
		if (!ip.equals("") && !url.equals("")) {   
			flag = commonMethod(pb, ip, url, method);
		}*/
		
		CommonResponse commonResponse =business.checkStatusPushToB(pb);
		flag = commonResponse.getResult().equals("SUCCESS");
		return flag;
	}

	/**
	 * 任务超时推送
	 * 
	 * @param taskInfoRespone
	 * @return
	 */
//	public void errorTaskPush(TaskInfoRespone taskInfoRespone) {
//		TaskInfoBusinessRespone tb = new TaskInfoBusinessRespone();
//		tb.setContent(taskInfoRespone.getContent());
//		tb.setPointName(taskInfoRespone.getPointName());
//		tb.setPointNo(taskInfoRespone.getPointID() + "");
//		tb.setTaskID(taskInfoRespone.getTaskID());
//		tb.setTaskName(taskInfoRespone.getTaskName());
//		tb.setTaskState(Integer.valueOf(taskInfoRespone.getStatus()));
//		errorTaskPushToB(tb);
//		errorTaskPushTo3D(taskInfoRespone);
//	}

//	public boolean errorTaskPushTo3D(TaskInfoRespone taskInfoRespone) {
//		boolean flag = true;
//		/*if (taskInfoRespone != null) {
//			List<TaskInfoRespone> list = new ArrayList<>();
//			list.add(taskInfoRespone);
//			String ip = remote3DUrl;
//			String url = errorTaskPushUrl;
//			HttpMethod method = HttpMethod.POST;
//			if (!ip.equals("") && !url.equals("")) {
//				flag = commonMethod(list, ip, url, method);
//			}
//		}*/
//		List<TaskInfoRespone> list = new ArrayList<>();
//		list.add(taskInfoRespone);
//		CommonResponse commonResponse = remote3D.errorTaskPushTo3D(list);
//		
//		flag = commonResponse.getResult().equals("SUCCESS");
//		return flag;
//	}

	public boolean errorTaskPushToB(TaskInfoBusinessRespone tb) {
		boolean flag = true;
		/*if (tb != null) {
			String ip = remoteBusinessUrl;
			String url = errorTaskPushToBUrl;
			HttpMethod method = HttpMethod.PUT;
			if (!ip.equals("") && !url.equals("")) {
				flag = commonMethod(tb, ip, url, method);
			}
		}*/
		CommonResponse commonResponse =business.errorTaskPushToB(tb);
		flag = commonResponse.getResult().equals("SUCCESS");		
		return flag;
	}

	/**
	 * 任务超时推送
	 * 
	 * @param taskInfoRespone
	 * @return
	 */
//	public boolean pointInfoPush(List<PointInfoSyn3DRespone> pointInfoResponseList) {
//		boolean flag = true;
//		/*if (!pointInfoResponseList.isEmpty()) {
//			String ip = remote3DUrl;
//			String url = pointInfoPushUrl;
//			HttpMethod method = HttpMethod.POST;
//			if (!ip.equals("") && !url.equals("")) {
//				flag = commonMethod(pointInfoResponseList, ip, url, method);
//			}
//		}*/
//     CommonResponse commonResponse = remote3D.pointInfoPush(pointInfoResponseList);
//		
//		flag = commonResponse.getResult().equals("SUCCESS");
//		
//		return flag;
//	}

//	public boolean routeInfoPush(List<RouteResponse> routeResponseList) {
//		boolean flag = true;
//		/*if (!routeResponseList.isEmpty()) {
//			String ip = remote3DUrl;
//			String url = routeInfoPushUrl;
//			HttpMethod method = HttpMethod.POST;
//			if (!ip.equals("") && !url.equals("")) {
//				flag = commonMethod(routeResponseList, ip, url, method);
//			}
//		}*/
//   CommonResponse commonResponse = remote3D.routeInfoPush(routeResponseList);
//		
//		flag = commonResponse.getResult().equals("SUCCESS");
//		
//		return flag;
//	}

	/*public boolean checkStatusPushToP(PointCheckInfoRespone pointCheckInfo) {
		boolean flag = true;
		String ip = remotePUrl;
		String url = checkStatusPushToPUrl;
		HttpMethod method = HttpMethod.PUT;
		if (!ip.equals("") && !url.equals("")) {
			HashMap<String, Object> param = new HashMap<String, Object>();
			int value = Integer.valueOf(pointCheckInfo.getStatus());
			String pointCode = "";
			if (value == 0 || value == 3) {
				pointCode = String.format("N%010d", pointCheckInfo.getPointID());
			} else {
				pointCode = String.format("S%010d", pointCheckInfo.getPointID());
			}
			param.put("pointCode", pointCode);
			param.put("value",  value % 2);
			flag = commonMethod(param, ip, url, method);
		}
		return flag;
	}*/

	public boolean commonMethod(Object obj, String ip, String url, HttpMethod method) {
		boolean flag = true;
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.add("X-From-Service", "true");
		try {
			SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
			requestFactory.setConnectTimeout(30 * 1000);  // 设置超时时间为30秒
			requestFactory.setReadTimeout(30 * 1000);
			RestTemplate restTemplate = new RestTemplate(requestFactory);
			String stringJson;

			stringJson = mapper.writeValueAsString(obj);
			logger.debug("stringJson=========" + stringJson);
			HttpEntity<String> formEntity = new HttpEntity<String>(stringJson, headers);
			CommonResponse commonResponse = restTemplate.exchange(ip + url, method, formEntity, CommonResponse.class)
					.getBody();
			logger.debug("pushResult====" + commonResponse.getResult());
			flag = commonResponse.getResult().equals("SUCCESS");
		} catch (JsonProcessingException e) {
			logger.error(e.getMessage(), e);
			flag = false;
		}

		return flag;
	}

}
