package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.common.api.dao.EsBaseEnterpriseInfoDao;
import com.yeejoin.amos.boot.module.common.api.entity.EsBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseUnitLicence;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseUnitLicenceMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
public class DataHandlerServiceImpl {

    private final EsBaseEnterpriseInfoDao enterpriseInfoDao;

    private final TzBaseEnterpriseInfoMapper enterpriseInfoMapper;

    private final TzBaseUnitLicenceMapper licenceMapper;

    public void init2EsCompany() {
//        List<TzBaseEnterpriseInfo> units = enterpriseInfoMapper.selectList(null);
//        List<EsBaseEnterpriseInfo> esBaseEnterpriseInfos = units.parallelStream().map(enterpriseInfo -> {
//            EsBaseEnterpriseInfo esBaseEnterpriseInfo = new EsBaseEnterpriseInfo();
//            esBaseEnterpriseInfo.setSequenceNbr(enterpriseInfo.getSequenceNbr() + "");
//            esBaseEnterpriseInfo.setSuperviseOrgCode(enterpriseInfo.getSuperviseOrgCode());
//            esBaseEnterpriseInfo.setUnitType(enterpriseInfo.getUnitType());
//            esBaseEnterpriseInfo.setUseUnit(enterpriseInfo.getUseUnit());
//            esBaseEnterpriseInfo.setUseUnitCode(enterpriseInfo.getUseUnitCode());
//            List<TzBaseUnitLicence> unitLicences = licenceMapper.selectList(new LambdaQueryWrapper<TzBaseUnitLicence>().eq(TzBaseUnitLicence::getUnitCode, enterpriseInfo.getUseUnitCode()));
//            List<EsBaseEnterpriseInfo.License> licenses = unitLicences.stream().map(lis -> {
//                EsBaseEnterpriseInfo.License esLicense = new EsBaseEnterpriseInfo.License();
//                esLicense.setExpiryDate(lis.getExpiryDate());
//                esLicense.setCertTypeCode(lis.getCertTypeCode());
//                esLicense.setUnitCode(lis.getUnitCode());
//                esLicense.setCertNo(lis.getCertNo());
//                return esLicense;
//            }).collect(Collectors.toList());
//            esBaseEnterpriseInfo.setLicenses(licenses);
//            return esBaseEnterpriseInfo;
//        }).collect(Collectors.toList());
//        enterpriseInfoDao.saveAll(esBaseEnterpriseInfos);
        loopSave();
    }

    private void loopSave() {
        PageRequest pageRequest = PageRequest.of(0, 10000);
        for (int i = 0; i < 200; i++) {
            List<EsBaseEnterpriseInfo> batch = enterpriseInfoDao.findAll(pageRequest)
                    .getContent()
                    .stream()
                    .peek(info -> info.setSequenceNbr(null))
                    .collect(Collectors.toList());
            enterpriseInfoDao.saveAll(batch);
        }
    }
}