package com.yeejoin.amos.boot.module.elevator.biz.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.annotation.ResubmitCheck;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.elevator.api.dto.RepairConsultDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.RepairConsult;
import com.yeejoin.amos.boot.module.elevator.biz.service.impl.RepairConsultServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 警情填报业务数据项
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "处置过程Api")
@RequestMapping(value = "/repair-consult")
public class RepairConsultController extends BaseController {

    @Autowired
    RedisUtils redisUtils;

    @Autowired
    RepairConsultServiceImpl repairConsultServiceImpl;

    /**
     * 新增警情填报业务数据项
     *
     * @return
     */
    @ResubmitCheck
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增警情填报业务数据项", notes = "新增警情填报业务数据项")
    public ResponseModel<RepairConsultDto> save(@RequestBody RepairConsultDto model) {
        model = repairConsultServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据警情id 查找处置过程日志
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据警情id 查找处置过程日志", notes = "根据警情id 查找处置过程日志")
    @GetMapping(value = "/list/alert/{alertId}")
    public ResponseModel<List<RepairConsult>> selectForListByAlertId(@PathVariable Long alertId) {
        LambdaQueryWrapper<RepairConsult> queryWrapper = new LambdaQueryWrapper<RepairConsult>();
        queryWrapper.eq(RepairConsult::getParentId, alertId).orderByDesc(RepairConsult::getRecDate);
        List<RepairConsult> list = repairConsultServiceImpl.list(queryWrapper);
        return ResponseHelper.buildResponse(list);
    }

    /**
     * 更新警情填报业务数据项
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/update")
    @ApiOperation(httpMethod = "POST", value = "更新警情填报业务数据项", notes = "更新警情填报业务数据项")
    public ResponseModel<Object> update(@RequestBody RepairConsultDto model) {
        //当前登录的用户信息
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        //更新备注
        RepairConsult consult = repairConsultServiceImpl.getOne(new LambdaQueryWrapper<RepairConsult>().eq(RepairConsult::getSequenceNbr, model.getSequenceNbr()));
        List<TreeMap> list = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(consult.getRemarks()) && !Objects.equals(consult.getRemarks(), "")) {
            list = JSONUtil.toList(consult.getRemarks(), TreeMap.class);
        }
        Date currentDate = DateUtil.date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedDate = sdf.format(currentDate);
        TreeMap<Object, Object> map = new TreeMap<>();
        map.put("rec_user_id", reginParams.getUserModel().getUserId());
        map.put("rec_user_name", reginParams.getUserModel().getRealName());
        map.put("rec_date", formattedDate);
        map.put("remark", model.getRemarks());
        list.add(map);
        LambdaUpdateWrapper<RepairConsult> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(RepairConsult::getSequenceNbr, model.getSequenceNbr());
        wrapper.set(RepairConsult::getRemarks, JSONUtil.toJsonStr(list));
        repairConsultServiceImpl.update(wrapper);
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 根据sequenceNbr 查找处置过程日志备注
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr 查找处置过程备注", notes = "根据sequenceNbr 查找处置过程备注")
    @GetMapping(value = "/alert/remarks/{sequenceNbr}")
    public ResponseModel<Object> selectBy(@PathVariable Long sequenceNbr) {
        LambdaQueryWrapper<RepairConsult> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RepairConsult::getSequenceNbr, sequenceNbr).orderByDesc(RepairConsult::getRecDate);
        RepairConsult consult = repairConsultServiceImpl.getOne(queryWrapper);
        List<HashMap> list = JSONUtil.toList(consult.getRemarks(), HashMap.class);
        return ResponseHelper.buildResponse(list);
    }
}
