package com.yeejoin.amos.boot.module.cylinder.biz.action;

import java.util.Map;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ELEvaluationContext
{
	private static EvaluationContext instance = new StandardEvaluationContext();

	private static ExpressionParser parser = new SpelExpressionParser();

	public static EvaluationContext getInstance()
	{
		return instance;
	}

	public static void setVariable(String name, Object value)
	{
		instance.setVariable(name, value);
	}

	public static void setVariable(Map<String, Object> vars)
	{
		for (Map.Entry<String, Object> entry : vars.entrySet())
		{
			instance.setVariable(entry.getKey(), entry.getValue());
		}
	}
	
	public static Object getValue(String Expression){
		return parser.parseExpression(Expression).getValue(instance);
	}
}
