package com.yeejoin.amos.boot.module.jyjc.api.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;

/**
 * @author Administrator
 */
@Data
public class NeedTipEquipInfo {

    /**
     * 设备唯一标识
     */
    private String record;
    /**
     * 单位信用代码
     */
    private String useUnitCreditCode;

    private String nextInspectDate;
    /**
     * 设备代码
     */
    private String equCode;

    /**
     * 设备种类code
     */
    private String equList;

    /**
     * 设备种类名称
     */
    private String equListName;


    /**
     * 直接管辖机构
     */
    private String orgBranchCode;

    /**
     * 上级管辖机构
     */
    private Set<String> parentOrgBranchCode;

    /**
     * 设备提醒可看见的人
     */
    private Set<String> receiveUsers;

    /**
     * 设备提醒可看见的人-字符串
     */
    private String receiveUserStr;


    /**
     * 状态：1-超期；2-临期
     */
    private String status;


    @AllArgsConstructor
    @Getter
    private enum EquipStatusEnum {

        /**
         * 预警枚举
         */
        cq("1", "临期预警", "【%s】【%s】设备检验有效期即将到期"),
        lq("2", "超期预警", "【%s】【%s】设备检验有效期已超期");

        /**
         * code
         */
        private String code;

        private String title;

        private String template;

        public static EquipStatusEnum getContentByCode(String code) {
            Optional<EquipStatusEnum> op = Arrays.stream(EquipStatusEnum.values()).filter(e -> e.code.equals(code)).findFirst();
            return op.orElse(null);
        }
    }

    public String getTitle() {
        return EquipStatusEnum.getContentByCode(this.status).getTitle();
    }

    public String getContent() {
        String template = EquipStatusEnum.getContentByCode(this.status).getTemplate();
        return String.format(template, this.equListName, this.getEquCode());
    }


}
