package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 发货单
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value="hygf_preparation_money",autoResultMap = true)
public class PreparationMoney extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     *  单号
     */
	@TableField("odd_numbers")
    private String oddNumbers;

    /**
     *  收货地址
     */
	@TableField("delivery_address")
    private String deliveryAddress;

    /**
     * 详细地址
     */
	@TableField("detail_address")
    private String detailAddress;

    /**
     *  下单人
     */
	@TableField("order_user")
    private String orderUser;

    /**
     * 下单时间
     */
	@TableField("order_time")
    private Date orderTime;

    /**
     * 经销商id
     */
	@TableField("dealer_id")
    private String dealerId;

    /**
     * 经销商名称
     */
	@TableField("dealer_name")
    private String dealerName;

    /**
     *  发货地址
     */
    @TableField(value = "send_address",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> sendAddress;

    /**
     *  业主类型
     */
	@TableField("owner_type")
    private String ownerType;

    /**
     * 业务员
     */
	@TableField("salesman")
    private String salesman;

    /**
     * 预估重量
     */
	@TableField("estimated_weight")
    private Double estimatedWeight;

    /**
     * 备注
     */
	@TableField("notes")
    private String notes;

    /**
     * 收货人
     */
	@TableField("consignee")
    private String consignee;

    /**
     * 收货人手机号
     */
	@TableField("consignee_phone")
    private String consigneePhone;

    /**
     * 收货人地址
     */
    @TableField(value = "consignee_address",typeHandler = FastjsonTypeHandler.class)
    private List<Object> consigneeAddress;

    /**
     * 收货人详细地址
     */
	@TableField("consignee_detail_address")
    private String consigneeDetailAddress;

    /**
     * 发货单
     */

    @TableField(value = "invoice",typeHandler = FastjsonTypeHandler.class)
    private List<Object> invoice;

    /**
     * 收货单
     */
    @TableField(value = "receipt",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> receipt;

    /**
     * 订单状态0未完成1已完成2已作废
     */
	@TableField("document_state")
    private String documentState;

    /**
     * 发货状态 0 未发货1已发货
     */
	@TableField("shipment_status")
    private String shipmentStatus;

    /**
     * 到货状态0未到货1已到货
     */
	@TableField("receiving_status")
    private String receivingStatus;

    /**
     * 清单价格
     */
	@TableField("inventory_price")
    private Double inventoryPrice;

    /**
     * 折扣
     */
	@TableField("discount")
    private Double discount;

    /**
     * 促销
     */
	@TableField("promotion")
    private Double promotion;

    /**
     * 合同价格
     */
	@TableField("contract_price")
    private Double contractPrice;

    /**
     * 总价
     */
	@TableField("total_price")
    private Double totalPrice;
	/**
     *
     * 验证 状态
     * */

    @TableField("validating")
    private  String  validating;
    /**
     * 到货时间
     */
    @TableField("delivery_time")
    private Date deliveryTime;

}
