package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.dto.DealerReviewDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.ReviewDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.UnitInfoDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.WorkDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.DealerReview;
import com.yeejoin.amos.boot.module.hygf.api.mapper.DealerReviewMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IDealerReviewService;
import com.yeejoin.amos.boot.module.hygf.biz.feign.WorkflowFeignClient;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/1
 */
@Service
public class DealerReviewServiceImpl extends BaseService<DealerReviewDto, DealerReview, DealerReviewMapper> implements IDealerReviewService {
    @Autowired
    DealerReviewMapper dealerReviewMapper;
    private static final String IDX_REQUEST_STATE="200";
    @Autowired
    WorkflowFeignClient workflowFeignClient;

    @Autowired
    AmosRequestContext requestContext;

    @Value("${amos.system.user.product}")
    private String AMOS_STUDIO_WEB;
    @Value("${amos.system.user.app-key}")
    private String AMOS_STUDIO;


    @Override
    public  com.baomidou.mybatisplus.extension.plugins.pagination.Page<ReviewDto> queryForDealerReviewPage(int pageNum, int pageSize,  ReviewDto reviewDto){
        PageHelper.startPage(pageNum,  pageSize);
        List<ReviewDto> list= dealerReviewMapper.queryForDealerReviewPage(reviewDto);
        PageInfo<ReviewDto> page=new PageInfo(list);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<ReviewDto> pagenew = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<ReviewDto>();
        pagenew.setCurrent(pageNum);
        pagenew.setTotal(page.getTotal());
        pagenew.setSize(pageSize);
        pagenew.setRecords(page.getList());
        return pagenew;
    }

    @Override
    public boolean saveDealerReview(DealerReview dealerReview, boolean flag, boolean token) {
        try{
            //流程节点code
            if (flag) {
                String flowTaskIdnext = this.getTaskNoAuth(dealerReview.getProcessInstanceId(),token);
                WorkDto workDto=this.getNodeInfoCode(flowTaskIdnext,token);
                dealerReview.setNextProcessNode(workDto.getNextProcessNode());
                dealerReview.setNodeRole(workDto.getNodeRole());
                dealerReview.setNodeRouting(workDto.getNodeRouting());
            }
            return this.saveOrUpdate(dealerReview);
        }catch (Exception e){
            throw new BaseException("获取工作流节点失败！","400","获取工作流节点失败！");
        }
    }

    public WorkDto getNodeInfoCode(String flowTaskId,boolean token){
        WorkDto workDto=null;
        try{
            FeignClientResult<JSONObject> jSONObject= null;
            if(token){
                jSONObject= workflowFeignClient.getNodeInfo(flowTaskId);

            }else{
                jSONObject= workflowFeignClient.getNodeInfotoken(AMOS_STUDIO, AMOS_STUDIO_WEB,requestContext.getToken(),flowTaskId);
            }

            if(IDX_REQUEST_STATE.equals(String.valueOf(jSONObject.getStatus()))){
                JSONObject js=jSONObject.getResult();
                if(js==null){
                    throw new BaseException("获取工作流节点失败！","400","获取工作流节点失败！");
                }
                LinkedHashMap  taskInfo= js.get("taskInfo")!=null?(LinkedHashMap)js.get("taskInfo"):null;
                String nextProcessNode=taskInfo!=null?taskInfo.get("taskDefinitionKey").toString():null;
                List<LinkedHashMap>  executor= js.get("executor")!=null?( List<LinkedHashMap>)js.get("executor"):null;
                String nodeRole=null;
                if(!executor.isEmpty()){
                    List<String> idList = executor.stream().map(e->e.get("groupId").toString()).collect(Collectors.toList());
                    nodeRole= StringUtils.join(idList,",");
                }

                LinkedHashMap  extensionInfo= js.get("extensionInfo")!=null?(LinkedHashMap)js.get("extensionInfo"):null;
                String nodeRouting=extensionInfo!=null?extensionInfo.get("nodeRole").toString():null;

                workDto=new WorkDto(nodeRouting,  nodeRole,  nextProcessNode);
            }

            return  workDto;
        }catch (Exception e){
            e.printStackTrace();
            throw new  BaseException("获取工作流节点失败！","400","获取工作流节点失败！");

        }
    }

    public String getTaskNoAuth(String processInstanceId,boolean token){
        String flowTaskId=null;
        try{
            JSONObject jSONObject=null;
            if(token){
                jSONObject= workflowFeignClient.getTaskNoAuth(processInstanceId);

            }else{
                jSONObject= workflowFeignClient.getTaskNoAuthtoken(AMOS_STUDIO, AMOS_STUDIO_WEB,requestContext.getToken(),processInstanceId);
            }
            if(IDX_REQUEST_STATE.equals(String.valueOf(jSONObject.get("code")))){
                LinkedHashMap jsd= jSONObject.get("data")!=null?(LinkedHashMap)jSONObject.get("data"):null;
                flowTaskId=jsd!=null?jsd.get("id").toString():null;
            }
            if(flowTaskId==null){
                throw new BaseException("获取工作流节点失败！","400","获取工作流节点失败！");
            }
            return  flowTaskId;
        }catch (Exception e){
            e.printStackTrace();
            throw new  BaseException("获取工作流节点失败！","400","获取工作流节点失败！");

        }
    }

}
