package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.AnalysisFanStationImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@RestController
@Api(tags = "分析场站-相关API")
@RequestMapping(value = "/analysisStation")
public class AnalysisFanStationController {

    @Autowired
    private StationBasicMapper stationBasicMapper;


    @Autowired
    AnalysisFanStationImpl analysisFanStationImpl;

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分析-风站 - 场站风速")
    @GetMapping("/getStationWindSpeedStatistics")
    public ResponseModel<Map<String, Object>> getStationWindSpeedStatistics(@RequestParam(value = "stationId", required = false)String stationId, @RequestParam(value = "type", required = false)String type) {
        String gatewayId = "";
        if (null != stationId) {
            StationBasic stationBasic = stationBasicMapper.selectById(stationId);
            gatewayId = stationBasic.getBoosterGatewayId();
            if (null == type){
                gatewayId = stationBasic.getFanGatewayId();
            }
        }
        Map<String, Object> detailsWindSpeed = analysisFanStationImpl.getStationWindSpeedStatistics(gatewayId);

        return ResponseHelper.buildResponse(detailsWindSpeed);
    }
}
