package com.yeejoin.amos.boot.module.jxiop.biz.mapper2;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationQrCodeStatistics;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.SjglZsjZsbtz;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 设备基本信息  Mapper 接口
 *
 * @author system_generator
 * @date 2023-07-03
 */
public interface SjglZsjZsbtzMapper extends BaseMapper<SjglZsjZsbtz> {

    /**
     * 根据场站信息获取装机容量
     * @param WERKS
     * @return
     */
    Double getStationCapactityByStationWerks(String WERKS);


    List<Map<String,Object>> getStationInfoMapByStationWerks(String WERKS, String DATAID);
    List<Map<String,Object>> getStationInfoMapByStationGFWerks(String WERKS,String DATAID);

    /**
     * 设备赋码数据
     */
    List<StationQrCodeStatistics> getEquipQrcodeInfo();


    /**
     * 任务赋码数据
     */
    List<StationQrCodeStatistics> getTaskQrcodeInfo();

    /**
     * 设备赋码数据
     */
    List<Map<String, Object>> getEquipYardStatistics(@Param("parentCode") String parentCode);

    /**
     * 任务赋码数据
     */
    List<Map<String, Object>> getJobYardStatistics(@Param("parentCode") String parentCode);

    /**
     * 设备赋码列表
     */
    List<Map<String, Object>> getEquipYardByPage(@Param("current") Integer current,
                                                 @Param("size")  Integer size,
                                                 @Param("parentCode") String parentCode,
                                                 @Param("date") String date,
                                                 @Param("qrCodeColor") String qrCodeColor);

    /**
     * 设备赋码列表
     */
    Integer getEquipYardByPageCount(@Param("parentCode") String parentCode,
                                    @Param("date") String date,
                                    @Param("qrCodeColor") String qrCodeColor);




    /**
     * 任务赋码列表
     */
    List<Map<String, Object>> getJobYardByPage(@Param("current") Integer current,
                                               @Param("size")  Integer size,
                                               @Param("parentCode") String parentCode,
                                               @Param("date") String date,
                                               @Param("qrCodeColor") String qrCodeColor);

    /**
     * 任务赋码列表数量统计
     */
    Integer getJobYardByPageCount(@Param("parentCode") String parentCode,
                                  @Param("date") String date,
                                  @Param("qrCodeColor") String qrCodeColor);
}
