package com.yeejoin.amos.boot.module.jxiop.biz.initdata;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jxiop.api.entity.MapRegion;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MapRegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.RegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESEquipments;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.QueryDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.SjglZsjZsbtzMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class StationCacheDataInit implements CommandLineRunner {
    Logger logger = LoggerFactory.getLogger(StationCacheDataInit.class);
    @Resource
    private StationBasicMapper stationBasicMapper;
    @Resource
    private RegionMapper regionMapper;
    @Resource
    private MapRegionMapper mapRegionMapper;
    @Resource
    private SjglZsjZsbtzMapper sjglZsjZsbtzMapper;
    @Resource
    private CommonServiceImpl commonServiceImpl;
    @Resource
    private RedisTemplate redisTemplate;
    public void run(String... args) throws Exception {
        List<StationCacheInfoDto> stationCacheInfoDtos = new ArrayList<>();
        redisTemplate.delete("station_info_cache");
        List<Region> regionList = regionMapper.selectList(new QueryWrapper<Region>().eq("LEVEL", 1));
        List< MapRegion > mapRegionList = mapRegionMapper.selectList(new QueryWrapper<MapRegion>().isNotNull("name"));
        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("belong_area").isNotNull("fan_gateway_id"));
        stationBasicList.forEach(stationBasic -> {
            StationCacheInfoDto stationCacheInfoDto = new StationCacheInfoDto();
            stationCacheInfoDto.setStationId(stationBasic.getSequenceNbr().toString());
            stationCacheInfoDto.setStationName(stationBasic.getStationName());
            stationCacheInfoDto.setStationType(stationBasic.getStationType());
            stationCacheInfoDto.setBelongProvince(regionList.stream().filter(region -> region.getRegionCode().toString().equals(stationBasic.getBelongArea().replace("[","").split(",")[0])).map(region -> region.getRegionName()).collect(Collectors.toList()).get(0));
            stationCacheInfoDto.setBelongArea(mapRegionList.stream().filter(mapRegion -> mapRegion.getProvince().contains(stationCacheInfoDto.getBelongProvince().substring(0,2))||mapRegion.getProvince().contains(stationCacheInfoDto.getBelongProvince().substring(0,3))).map(mapRegion -> mapRegion.getName()).collect(Collectors.toList()).get(0));
            stationCacheInfoDto.setInstalledCapacity(String.format("%.2f",sjglZsjZsbtzMapper.getStationCapactityByStationWerks(stationBasic.getStationNumber())));
            List<QueryDto> queryDtoList = new ArrayList<>();
            queryDtoList.add(new QueryDto("gatewayId",stationBasic.getFanGatewayId()));
            queryDtoList.add(new QueryDto("equipmentIndexName.keyword","有功功率"));
            if(!stationBasic.getStationType().equals("FDZ")){
                queryDtoList.add(new QueryDto("frontModule","逆变器"));
            }
            stationCacheInfoDto.setEquipmentNumbers(commonServiceImpl.getCount(queryDtoList,"equipmentNumber.Keyword", ESEquipments.class).toString());
            stationCacheInfoDto.setFanGatewayId(stationBasic.getFanGatewayId());
            stationCacheInfoDto.setBoosterGatewayId(stationBasic.getBoosterGatewayId());
            stationCacheInfoDtos.add(stationCacheInfoDto);
        });
        redisTemplate.opsForList().leftPushAll("station_info_cache",stationCacheInfoDtos);
    }
}
