package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESDailyPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESMoonPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESYearPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESDailyPowerGenerationRepository;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESEquipmentsRepository;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESMoonPowerGenerationRepository;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESYearPowerGenerationRepository;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/9
 */
@Service
public class PowerGenerationImpl {

    @Autowired
    InfluxDButils influxDButils;
    @Autowired
    private ElasticsearchRestTemplate elasticsearchTemplate;
    @Autowired
    ESYearPowerGenerationRepository yearPowerGenerationRepository;
    @Autowired
    ESMoonPowerGenerationRepository moonPowerGenerationRepository;
    @Autowired
    ESDailyPowerGenerationRepository dailyPowerGenerationRepository;


    //获取指定指标，当天最后一条数据
    public List<IndexDto> getlast(String gatewayId, String value,String daty){
        IndexDto indexDto=null;

        String querySql = " SELECT * FROM iot_data_%s  WHERE equipmentIndexName='%s'  and time >='%sT00:55:00Z' AND time < '%sT23:59:59Z'  group by equipmentsIdx order by time desc  LIMIT   1";

        querySql = String.format(querySql, gatewayId, value,daty,daty);
        List<IndexDto> queryList  = influxDButils.getListData(querySql,IndexDto.class);
        return queryList;
    }
    public List<IndexDto> getlastgf(String gatewayId, String value,String daty){
        IndexDto indexDto=null;
        String querySql = " SELECT * FROM iot_data_%s  WHERE equipmentIndexName='%s' and   equipmentSpecificName    =~/.*逆变器.*/   and time >='%sT00:55:00Z' AND time < '%sT23:59:59Z'  group by equipmentsIdx order by time desc  LIMIT   1";

        querySql = String.format(querySql, gatewayId, value,daty,daty);
        List<IndexDto> queryList  = influxDButils.getListData(querySql,IndexDto.class);
        return queryList;
    }
    //更新es 数据

    //@Async("jxiopAsyncExecutor")
    public void addPowerGeneration(StationCacheInfoDto stationCacheInfoDto,String gatewayId, String value, String dateFormat, String type, String stationType,String datyvalue){
        //获取指标值
        List<IndexDto> indexDto=null;

        if("FDZ".equals(stationType)){
            indexDto= this.getlast(gatewayId,value, datyvalue);
        }else{
            indexDto= this.getlastgf(gatewayId,value,datyvalue);
        }

        SimpleDateFormat myFmt2=new SimpleDateFormat(dateFormat);
        Date now=new Date();
        String daty= myFmt2.format(now);
        this.PowerGeneration(stationCacheInfoDto,indexDto,daty,type);
    }


    //更新es
    public void PowerGeneration(StationCacheInfoDto stationCacheInfoDto,List<IndexDto> indexDto,String daty,String type){
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(Calendar.DATE);
        int month = calendar.get(Calendar.MONTH) + 1;
        int year = calendar.get(Calendar.YEAR);

        SimpleDateFormat myFmt2=new SimpleDateFormat("yyyyMM");
        Date now=new Date();
        String monthy= myFmt2.format(now);

        SimpleDateFormat myFmty=new SimpleDateFormat("yyyy");
        Date nowy=new Date();
        String yeary= myFmty.format(nowy);


        switch (type) {
            case "day":
                List<ESDailyPowerGeneration> listd=   this.getESDailyPowerGeneration(stationCacheInfoDto,indexDto,daty,String.valueOf(day),monthy);
                dailyPowerGenerationRepository.saveAll(listd);
                break;
            case "moon":
                List<ESMoonPowerGeneration> listm=   this.getESMoonPowerGeneration(stationCacheInfoDto,indexDto,daty,String.valueOf(month),yeary);
                moonPowerGenerationRepository.saveAll(listm);
                break;
            case "year":
                List<ESYearPowerGeneration> listy=   this.getESYearPowerGeneration(stationCacheInfoDto,indexDto,daty,String.valueOf(year));
                yearPowerGenerationRepository.saveAll(listy);
                break;
            default:
                break;
        }

    }

// 组装数据

    public List<ESDailyPowerGeneration> getESDailyPowerGeneration(StationCacheInfoDto stationCacheInfoDto,List<IndexDto> indexDto,String daty,String day,String month){

        List<ESDailyPowerGeneration> list=new ArrayList<>();
        if(indexDto!=null&&!indexDto.isEmpty()){
            for (IndexDto dto : indexDto) {
                ESDailyPowerGeneration dailyPowerGeneration=new ESDailyPowerGeneration(
                        daty+"_"+dto.getAddress(),
                        stationCacheInfoDto.getStationId(),
                        stationCacheInfoDto.getStationName(),
                        stationCacheInfoDto.getStationType(),
                        stationCacheInfoDto.getBelongProvince(),
                        stationCacheInfoDto.getBelongArea(),
                        day,
                        dto.getGatewayId(),
                        new Date(),
                        dto.getValue()!=null?Double.valueOf(dto.getValue()):null,
                        dto.getEquipmentIndexName(),
                        dto.getEquipmentNumber(),
                        dto.getAddress(),
                        month
                );
                list.add(dailyPowerGeneration);
            }
        }
        return list;
    }
    public List<ESMoonPowerGeneration> getESMoonPowerGeneration(StationCacheInfoDto stationCacheInfoDto,List<IndexDto> indexDto,String daty,String day,String year){
        List<ESMoonPowerGeneration> list=new ArrayList<>();
        if(indexDto!=null&&!indexDto.isEmpty()){
            for (IndexDto dto : indexDto) {
                ESMoonPowerGeneration moonPowerGeneration=new ESMoonPowerGeneration(
                        daty+"_"+dto.getAddress(),
                        stationCacheInfoDto.getStationId(),
                        stationCacheInfoDto.getStationName(),
                        stationCacheInfoDto.getStationType(),
                        stationCacheInfoDto.getBelongProvince(),
                        stationCacheInfoDto.getBelongArea(),
                        day,
                        dto.getGatewayId(),
                        new Date(),
                        dto.getValue()!=null?Double.valueOf(dto.getValue()):null,
                        dto.getEquipmentIndexName(),
                        dto.getEquipmentNumber(),
                        dto.getAddress(),
                        year
                );
                list.add(moonPowerGeneration);
            }
        }
        return list;
    }
    public List<ESYearPowerGeneration> getESYearPowerGeneration(StationCacheInfoDto stationCacheInfoDto,List<IndexDto> indexDto,String daty,String day){
        List<ESYearPowerGeneration> list=new ArrayList<>();
        if(indexDto!=null&&!indexDto.isEmpty()){
            for (IndexDto dto : indexDto) {
                ESYearPowerGeneration yearPowerGeneration=new ESYearPowerGeneration(
                        daty+"_"+dto.getAddress(),
                        stationCacheInfoDto.getStationId(),
                        stationCacheInfoDto.getStationName(),
                        stationCacheInfoDto.getStationType(),
                        stationCacheInfoDto.getBelongProvince(),
                        stationCacheInfoDto.getBelongArea(),
                        day,
                        dto.getGatewayId(),
                        new Date(),
                        dto.getValue()!=null?Double.valueOf(dto.getValue()):null,
                        dto.getEquipmentIndexName(),
                        dto.getEquipmentNumber(),
                        dto.getAddress()
                );
                list.add(yearPowerGeneration);
            }
        }
        return list;
    }







}
