package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

/**
 * 风险管控预选人员表
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_risk_control_pre_person")
@ApiModel(value = "TaskRiskControlPrePerson对象", description = "风险管控预选人员表")
public class TaskRiskControlPrePerson extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "任务id")
	private Long taskId;

	@ApiModelProperty(value = "人员id")
	private Long personId;

	@ApiModelProperty(value = "人员id")
	private String personName;

	@ApiModelProperty(value = "人员类型")
	private Long type;

	@ApiModelProperty(value = "是否已经使用")
	private boolean used;

}
