package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.entity.JgVehicleInformation;
import com.yeejoin.amos.boot.module.jg.api.vo.JgVehicleInformationVo;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgVehicleInformationServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgVehicleInformationDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import javax.servlet.http.HttpServletResponse;

/**
 * 车用气瓶控制类
 *
 * @author LiuLin
 * @date 2024-03-18
 */
@RestController
@Api(tags = "车用气瓶控制类Api")
@RequestMapping(value = "/jg-vehicle-information")
public class JgVehicleInformationController extends BaseController {

    @Autowired
    JgVehicleInformationServiceImpl jgVehicleInformationServiceImpl;

    /**
     * 新增(提交)车用气瓶控制类
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增车用气瓶控制类", notes = "新增车用气瓶控制类")
    public ResponseModel<Object> saveOrSubmit(@RequestBody JSONObject map, @RequestParam(value = "submit") String submit) {
        return ResponseHelper.buildResponse(jgVehicleInformationServiceImpl.save(submit, map));
    }

    /**
     * 执行流程
     *
     * @param map map
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/flowExecute")
    @ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
    public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
        jgVehicleInformationServiceImpl.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),
                String.valueOf(map.get("instanceId")),
                String.valueOf(map.get("operate")),
                String.valueOf(map.get("comment")),
                String.valueOf(map.get("nextTaskId")),
                String.valueOf(map.get("equDefineCode")));
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 车用气瓶撤回
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/cancel")
    @ApiOperation(httpMethod = "POST", value = "车用气瓶撤回", notes = "车用气瓶撤回")
    public ResponseModel<Object> cancel(@RequestBody JSONObject map) {
        jgVehicleInformationServiceImpl.cancel(String.valueOf(map.get("instanceId")), String.valueOf(map.get("nextTaskId")));
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 批量删除
     *
     * @param map map
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
    public ResponseModel<Object> deleteBatch(@RequestBody JSONObject map) {
        List<Long> ids = (List<Long>) map.get("ids");
        jgVehicleInformationServiceImpl.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 根据id进行删除
     *
     * @param id id
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteMessage")
    @ApiOperation(httpMethod = "POST", value = "删除", notes = "删除")
    public ResponseModel<Object> deleteMessage(@RequestParam("id") Long id) {
        Long[] ids = {id};
        jgVehicleInformationServiceImpl.deleteBatch(Arrays.asList(ids));
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 车用气瓶查询列表接口
     *
     * @param dto     dto
     * @param current current
     * @param size    size
     * @return Page
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "车用气瓶列表全部数据查询", notes = "车用气瓶列表全部数据查询")
    @GetMapping(value = "/getPageList")
    public ResponseModel<Page<Map<String, Object>>> getPageList(JgVehicleInformationDto dto,
                                                                @RequestParam(value = "sort", required = false) String sort,
                                                                @RequestParam(value = "current") int current,
                                                                @RequestParam(value = "size") int size) {
        Page<Map<String, Object>> page = new Page<>(current, size);
        ReginParams info = getSelectedOrgInfo();
        String companyCode = info.getCompany().getCompanyCode();
        // 使用单位为个人时候 特殊处理
        if (companyCode.split("_").length > 1) {
            companyCode = companyCode.split("_")[1];
        }
        dto.setCurrentUserId(info.getUserModel().getUserId());
        dto.setUseUnitCreditCode(companyCode);
        if (info.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            dto.setDataType(BaseController.COMPANY_TYPE_COMPANY);
        } else {
            dto.setDataType(BaseController.COMPANY_TYPE_SUPERVISION);
        }
        Page<Map<String, Object>> list = jgVehicleInformationServiceImpl.getPageList(dto,sort, page, dto.getRoleIds());
        list.getRecords().forEach(x -> x.put("companyType", info.getCompany().getCompanyType()));
        return ResponseHelper.buildResponse(list);
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除车用气瓶控制类", notes = "根据sequenceNbr删除车用气瓶控制类")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgVehicleInformationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询详情
     *
     * @param sequenceNbr 主键
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个车用气瓶控制类", notes = "根据sequenceNbr查询单个车用气瓶控制类")
    public ResponseModel<JgVehicleInformationVo> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgVehicleInformationServiceImpl.queryBySequenceNbr(sequenceNbr));
    }

	/**
	 * 导出车用气瓶使用标志、使用登记证
	 * @param response response
	 * @param sequenceNbr 主键
	 * @param printType 打印类型
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/export")
	@ApiOperation(httpMethod = "GET", value = "导出车用气瓶使用标志、使用登记证", notes = "普打、套打")
	public void exportVehicleUseRegistrationCertificate(HttpServletResponse response, @RequestParam("sequenceNbr") String sequenceNbr,
							   @RequestParam(value = "printType", defaultValue = "0") String printType) {
		jgVehicleInformationServiceImpl.exportVehicleUseRegistrationCertificate(sequenceNbr, response, printType);
	}

    /**
     * 导出车用气瓶使用登记表
     * @param response response
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportVehicleUseRegistrationForm")
    @ApiOperation(httpMethod = "GET", value = "导出车用气瓶使用登记表")
    public void exportVehicleUseRegistrationForm(HttpServletResponse response,
                                                 @RequestParam("sequenceNbr") String sequenceNbr,
                                                 @RequestParam(value = "printType", defaultValue = "0") String printType) {
        jgVehicleInformationServiceImpl.exportVehicleUseRegistrationForm(sequenceNbr, response, printType);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "车用气瓶使用登记单条作废", notes = "车用气瓶使用登记单条作废")
    @PutMapping(value = "/cancel/application")
    public ResponseModel<JgVehicleInformation> cancelApplication(@RequestBody JgVehicleInformationDto vehicleInformationDto) {
        JgVehicleInformation result = jgVehicleInformationServiceImpl.cancelApplication(vehicleInformationDto.getSequenceNbr(), vehicleInformationDto.getCancelReason());
        return ResponseHelper.buildResponse(result);
    }

    /**
     * 车用气瓶流程错误数据处理
     * @param applyNo applyNo
     * @return s
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/yunWei/handleErrorVehicleForm")
    @ApiOperation(httpMethod = "POST", value = "车用气瓶流程错误数据处理", notes = "车用气瓶流程错误数据处理")
    public ResponseModel<Object> handleErrorVehicleForm(@RequestParam("applyNo") String applyNo) {
        jgVehicleInformationServiceImpl.handleErrorVehicleForm(applyNo);
        return ResponseHelper.buildResponse("申请单【"+applyNo+"】处理成功");
    }

    /**
     * 车用气瓶保存历史数据
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/saveOrUpdateHisData")
    @ApiOperation(httpMethod = "POST", value = "车用气瓶保存历史数据", notes = "车用气瓶保存历史数据")
    public ResponseModel<Object> saveOrUpdateHisData(@RequestBody JSONObject map) {
        return ResponseHelper.buildResponse(jgVehicleInformationServiceImpl.saveOrUpdateHisData(map));
    }
}
