package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.CylinderFillingRecordStatisticsDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.CylinderDPStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 气瓶基本信息
 *
 * @author system_generator
 * @date 2021-12-14
 */
@RestController
@Api(tags = "大屏-气瓶统计Api")
@RequestMapping(value = "/dp/cylinder")
public class CylinderDPStatisticsController extends BaseController {

    private CylinderDPStatisticsServiceImpl dpStatisticsService;

    public CylinderDPStatisticsController(CylinderDPStatisticsServiceImpl dpStatisticsService) {
        this.dpStatisticsService = dpStatisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCylinderStatisticsData")
    @ApiOperation(httpMethod = "GET", value = "获取气瓶统计数据-按照企业名称统计", notes = "获取气瓶统计数据-按照企业名称统计")
    public ResponseModel<List<Map<String, Object>>> getCylinderStatisticsData(@RequestParam(value = "regionCode") String regionCode) throws IOException {
        List<Map<String, Object>> result = dpStatisticsService.getCylinderStatisticsData(regionCode);
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getCylinderStatisticsDataByCity")
    @ApiOperation(httpMethod = "POST", value = "获取气瓶统计数据-按照城市统计", notes = "获取气瓶统计数据-按照城市统计")
    public ResponseModel<Map<String, Object>> getCylinderStatisticsDataByCity(@RequestBody Map<String, Object> map) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }

        Map<String, Object> result = dpStatisticsService.getCylinderStatisticsDataByCity(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getCylinderStatisticsDataByCityForTotal")
    @ApiOperation(httpMethod = "POST", value = "获取气瓶统计数据-按照城市统计", notes = "获取气瓶统计数据-按照城市统计-地图统计")
    public ResponseModel<Map<String, Object>> getCylinderStatisticsDataByCityForTotal(@RequestBody Map<String, Object> map) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }

        Map<String, Object> result = dpStatisticsService.getCylinderStatisticsDataByCityForTotal(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getCylinderStatisticsDataByCityForMap")
    @ApiOperation(httpMethod = "POST", value = "获取气瓶统计数据-按照城市统计", notes = "获取气瓶统计数据-按照城市统计-地图")
    public ResponseModel<List<Map<String, Object>>> getCylinderStatisticsDataByCityForMap(@RequestBody Map<String, Object> map) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }

        List<Map<String, Object>> result = dpStatisticsService.getCylinderStatisticsDataByCityForMap(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "30天的充装量、卸液量数据")
    @GetMapping(value = "/fillingTimesAndQuantity")
    public ResponseModel<List<CylinderFillingRecordStatisticsDto>> fillingTimesAndQuantity(@RequestParam("regionCode") String reginCode) {
        return ResponseHelper.buildResponse(dpStatisticsService.fillingTimesAndQuantity(reginCode));
    }


}
