package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.StCommonServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@RestController
@Api(tags = "统计公共API")
@RequestMapping(value = "/st-common")
public class StCommonController {

    StCommonServiceImpl commonService;

    /**
     * 获取用户regionCode
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUserRegincode")
    @ApiOperation(httpMethod = "GET", value = "获取用户regionCode", notes = "获取用户regionCode")
    public ResponseModel<List<String>> getUserRegincode() {
        List<String> regionList = commonService.getUserRegionCode();
        return ResponseHelper.buildResponse(regionList);
    }
}
