package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Administrator
 */
@Service
public class StCommonServiceImpl {

    public List<String> getUserRegionCode() {
        List<String> regionList = new ArrayList<>();
        AgencyUserModel me = Privilege.agencyUserClient.getme().getResult();
        CompanyModel userCompany = me.getCompanys().get(0);
        String regions = userCompany.getRegionSeq();
        if(regions != null) {
            String[] regionsId = regions.split(",");
            for(String regionId:regionsId) {
                RegionModel region = Systemctl.regionClient.getRegion(Long.valueOf(regionId)).getResult();
                regionList.add(region.getRegionCode() + "");
            }
        }
        return regionList;
    }
}
