package com.yeejoin.amos.boot.module.jg.biz.controller;


import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.ReportAnalysisSearchDTO;
import com.yeejoin.amos.boot.module.jg.api.service.IReportAnalysisService;
import com.yeejoin.amos.boot.module.jg.api.vo.JgBizCountBaseVo;
import com.yeejoin.amos.boot.module.jg.api.vo.JgBizEquipStateCountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/report-analysis")
@Api(tags = "报表分析")
public class ReportAnalysisController extends BaseController {

    private IReportAnalysisService reportAnalysisService;

    public ReportAnalysisController(IReportAnalysisService reportAnalysisService) {
        this.reportAnalysisService = reportAnalysisService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/notice/count/list")
    @ApiOperation("告知类业务办理情况统计列表")
    public ResponseModel<List<JgBizCountBaseVo>> getNoticeCountList(ReportAnalysisSearchDTO reportAnalysisSearchDTO) {
        //设置默认数据权限过滤条件
        this.setDefaultFilterParam(reportAnalysisSearchDTO);
        List<JgBizCountBaseVo> result = reportAnalysisService.getNoticeCountList(reportAnalysisSearchDTO);
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/maintenance/count/list")
    @ApiOperation("维保备案业务办理情况统计列表")
    public ResponseModel<List<JgBizCountBaseVo>> getMaintenanceCountList(ReportAnalysisSearchDTO reportAnalysisSearchDTO) {
        //设置默认数据权限过滤条件
        this.setDefaultFilterParam(reportAnalysisSearchDTO);
        List<JgBizCountBaseVo> result = reportAnalysisService.getMaintenanceCountList(reportAnalysisSearchDTO);
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/register/count/list")
    @ApiOperation("登记类业务办理情况统计列表")
    public ResponseModel<List<JgBizCountBaseVo>> getRegisterCountList(ReportAnalysisSearchDTO reportAnalysisSearchDTO) {
        //设置默认数据权限过滤条件
        this.setDefaultFilterParam(reportAnalysisSearchDTO);
        List<JgBizCountBaseVo> result = reportAnalysisService.getRegisterCountList(reportAnalysisSearchDTO);
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/equip-status/count/list")
    @ApiOperation("设备状态情况统计列表")
    public ResponseModel<List<JgBizEquipStateCountVo>> getEquipStatusCountList(ReportAnalysisSearchDTO reportAnalysisSearchDTO) {
        //设置默认数据权限过滤条件
        this.setDefaultFilterParam(reportAnalysisSearchDTO);
        List<JgBizEquipStateCountVo> result = reportAnalysisService.getEquipStatusCountList(reportAnalysisSearchDTO);
        return ResponseHelper.buildResponse(result);
    }

    private void setDefaultFilterParam(ReportAnalysisSearchDTO reportAnalysisSearchDTO){
        if(StringUtils.isEmpty(reportAnalysisSearchDTO.getReceiveOrgCode())){
            reportAnalysisSearchDTO.setReceiveOrgCode(getSelectedOrgInfo().getCompany().getOrgCode());
        }
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/receive-reg/tree")
    @ApiOperation("查询当前登录人的管辖机构树，显示本级及所有下级，将接收机构转化为登记机关")
    public ResponseModel<List<CompanyBo>> getReceiveCompanyRegTreeWithAuth() {
        List<CompanyBo> result = reportAnalysisService.getReceiveCompanyTreeWithAuth(getSelectedOrgInfo(), true);
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/receive-company/tree")
    @ApiOperation("查询当前登录人的管辖机构树，显示本级及所有下级，接收机构")
    public ResponseModel<List<CompanyBo>> getReceiveCompanyTreeWithAuth() {
        List<CompanyBo> result = reportAnalysisService.getReceiveCompanyTreeWithAuth(getSelectedOrgInfo(), false);
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/biz-type/list")
    @ApiOperation("业务类型枚举")
    public ResponseModel<List<Map<String,Object>>> getBizTypeList(@RequestParam String group) {
        List<Map<String,Object>> result = reportAnalysisService.getBizTypeList(group);
        return ResponseHelper.buildResponse(result);
    }

}
