package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.common.api.entity.AlertUseUnitStatistics;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.YJDPStatisticsServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.dto.AlertUseUnitStatisticsDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.AlertPaperInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.enums.AlertStageEnums;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@Api(tags = "大屏-应急-统计API")
@RequestMapping("/dp/yj")
public class YJDPStatisticsController {


    private YJDPStatisticsServiceImpl statisticsService;

    public YJDPStatisticsController(YJDPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-办理量 (近7日)", notes = "大屏-应急-办理量 (近7日)")
    @PostMapping(value = "/eventStatByDay")
    public ResponseModel<JSONObject> eventStatByDay(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.eventStatByDay(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-电梯数量统计 (按区域)", notes = "大屏-应急-电梯数量统计 (按区域)")
    @PostMapping(value = "/elevatorCountStat")
    public ResponseModel<JSONObject> elevatorCountStat(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.elevatorCountStat(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-事件分布 (按场所)", notes = "大屏-应急-事件分布 (按场所)")
    @PostMapping(value = "/eventStatByLocation")
    public ResponseModel<JSONObject> eventStatByLocation(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.eventStatByLocation(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-故障原因占比", notes = "大屏-应急-故障原因占比")
    @PostMapping(value = "/faultCauseRatio")
    public ResponseModel<JSONObject> faultCauseRatio(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.faultCauseRatio(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-困人救援月度情况", notes = "大屏-应急-困人救援月度情况")
    @PostMapping(value = "/trappedUserCount")
    public ResponseModel<JSONObject> trappedUserCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.trappedUserCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-即时警情列表", notes = "大屏-应急-即时警情列表")
    @PostMapping(value = "/instantAlert")
    public ResponseModel<List<AlertPaperInfoDto>> instantAlert(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.instantAlert(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-即时警情下钻列表", notes = "大屏-应急-即时警情下钻列表")
    @PostMapping(value = "/instantAlertList")
    public ResponseModel<Page<Map<String,Object>>> instantAlertList(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result,
                                                                   @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                   @RequestParam(value = "size", defaultValue = "20") Integer size) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Page<Map<String, Object>> page = new Page<>(current,size);
        return ResponseHelper.buildResponse(statisticsService.instantAlertList(dpFilterParamForDetailDto,page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-即时警情下钻列表类型", notes = "大屏-应急-即时警情下钻列表类型")
    @PostMapping(value = "/getAlertCallType")
    public ResponseModel<List<Map<String, Object>>> getAlertCallType(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getAlertCallType(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-即时警情下钻列表筛选", notes = "大屏-应急-即时警情下钻列表筛选")
    @PostMapping(value = "/getAlertCallSearch")
    public ResponseModel<Map<String,List<Map<String,Object>>>> getAlertCallSearch(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getAlertCallSearch(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-月度困人故障高发使用单位（默认上月度）", notes = "大屏-应急-月度困人故障高发使用单位")
    @PostMapping(value = "/trappedUserHighCompanyCount")
    public ResponseModel<List<AlertUseUnitStatisticsDto>> trappedUserHighCompanyCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.trappedUserHighCompanyCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-维保单位平均救援时间排名", notes = "大屏-应急-维保单位平均救援时间排名")
    @PostMapping(value = "/rankUnitByRescueTime")
    public ResponseModel<List<Map<String, Object>>> rankUnitByRescueTime(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.rankUnitByRescueTime(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-维保单位平均救援时间排名下钻列表", notes = "大屏-应急-维保单位平均救援时间排名下钻列表")
    @PostMapping(value = "/rankUnitByRescueTimePage")
    public ResponseModel<Page<Map<String, Object>>> rankUnitByRescueTimePage(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result,
                                                                             @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                             @RequestParam(value = "size", defaultValue = "20") Integer size) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Page<Map<String, Object>> page = new Page<>(current,size);
        return ResponseHelper.buildResponse(statisticsService.rankUnitByRescueTimePage(page,dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-维保单位平均救援时间排名下钻图表", notes = "大屏-应急-维保单位平均救援时间排名下钻图表")
    @PostMapping(value = "/rankUnitByRescueTimeDetail")
    public ResponseModel<Map<String, Object>> rankUnitByRescueTimeDetail(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.rankUnitByRescueTimeDetail(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-维保单位平均救援时间排名下钻类型", notes = "大屏-应急-维保单位平均救援时间排名下钻类型")
    @PostMapping(value = "/rankUnitByRescueTimeType")
    public ResponseModel<List<Map<String, Object>>> rankUnitByRescueTimeType(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.rankUnitByRescueTimeType(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-各地市应急事件总数排名", notes = "大屏-应急-各地市应急事件总数排名")
    @PostMapping(value = "/regionEventRank")
    public ResponseModel<JSONObject> regionEventRank(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.regionEventRank(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-中间地图图列统计", notes = "大屏-应急-中间地图图列统计")
    @PostMapping(value = "/center-map/legend")
    public ResponseModel<Map<String, Object>> centerMapCountForGlobal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForGlobal(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-中间地图地市统计", notes = "大屏总览中间-地图地市统计")
    @PostMapping(value = "/center-map/overview")
    public ResponseModel<List<Map<String, Object>>> centerMapCountForOverview(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForOverview(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "应急大屏使用-办理量 (近7天)-右上角更多-各地市业务办理情况-地市应急事件总数柱状图",
            notes = "应急大屏使用-办理量 (近7天)-右上角更多-各地市业务办理情况-地市应急事件总数柱状图")
    @PostMapping("/alertRecordBarChart/dp")
    public ResponseModel<Object> alertRecordBarChartForDP(@RequestBody DPFilterParamForDetailDto recordFilterVo) {
        return ResponseHelper.buildResponse(statisticsService.alertRecordBarChartForDP(recordFilterVo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "应急大屏使用-警情类型", notes = "应急大屏使用-警情类型")
    @PostMapping("/alertOperations/dp")
    public ResponseModel<Object> alertOperations() {
        JSONArray objects = new JSONArray();
        objects.add(statisticsService.alertOperations());
        return ResponseHelper.buildResponse(objects);
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "应急大屏使用-报警类型", notes = "应急大屏使用-报警类型")
    @PostMapping("/alertTypeOperations/dp")
    public ResponseModel<Object> alertTypeOperations() {
        JSONArray res = new JSONArray();
        JSONObject jsonObject1 = new JSONObject().fluentPut("label", AlertStageEnums.JQCB.getValue()).fluentPut("value", AlertStageEnums.JQCB.getId());
        JSONObject jsonObject2 = new JSONObject().fluentPut("label", AlertStageEnums.JQGB.getValue()).fluentPut("value", AlertStageEnums.JQGB.getId());
        res.add(jsonObject1);
        res.add(jsonObject2);
        return ResponseHelper.buildResponse(res);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "应急大屏使用-警情来源", notes = "应急大屏使用-警情来源")
    @PostMapping("/alertSourceOperations/dp")
    public ResponseModel<Object> alertSourceOperations() {
        JSONArray res = new JSONArray();
        JSONObject jsonObject1 = new JSONObject().fluentPut("label", AlertStageEnums.DHBJ.getValue()).fluentPut("value", AlertStageEnums.DHBJ.getId());
        JSONObject jsonObject2 = new JSONObject().fluentPut("label", AlertStageEnums.WLJR.getValue()).fluentPut("value", AlertStageEnums.WLJR.getId());
        JSONObject jsonObject3 = new JSONObject().fluentPut("label", AlertStageEnums.APPJJ.getValue()).fluentPut("value", AlertStageEnums.APPJJ.getId());
        res.add(jsonObject1);
        res.add(jsonObject2);
        res.add(jsonObject3);
        return ResponseHelper.buildResponse(res);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "应急大屏使用-办理量 (近7天)-右上角更多-各地市业务办理情况-底部表格",
            notes = "应急大屏使用-办理量 (近7天)-右上角更多-各地市业务办理情况-底部表格")
    @PostMapping("/alertRecordTable/dp")
    public ResponseModel<IPage<Map<String, Object>>> alertRecordTableForDP(@Validated @RequestBody DPFilterParamForDetailDto recordFilterVo,
                                                                           @RequestParam(value = "current") Integer current,
                                                                           @RequestParam(value = "size") Integer size) {
        recordFilterVo.setCurrent(current);
        recordFilterVo.setSize(size);
        return statisticsService.alertRecordTableForDP(recordFilterVo);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "月度困人故障高发使用单位-右上角更多-地市月度应急事件高发使用单位-侧边树",
            notes = "月度困人故障高发使用单位-右上角更多-地市月度应急事件高发使用单位-侧边树")
    @PostMapping("/alertUnitOption/dp")
    public ResponseModel<Object> alertUnitOption() {
        List<JSONObject> subList = Collections.singletonList(new JSONObject()
                .fluentPut("value", "use")
                .fluentPut("title", "使用单位"));
        JSONArray res = new JSONArray();
        JSONObject jsonObject = new JSONObject()
                .fluentPut("title", "企业类型")
                .fluentPut("value", "all")
                .fluentPut("children", subList);
        res.add(jsonObject);
        return ResponseHelper.buildResponse(res);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "月度困人故障高发使用单位-右上角更多-地市月度应急事件高发使用单位-柱状图",
            notes = "月度困人故障高发使用单位-右上角更多-地市月度应急事件高发使用单位-柱状图")
    @PostMapping("/alertUnitBarChart/dp")
    public ResponseModel<JSONObject> alertUnitBarChartForDP(@Validated @RequestBody DPFilterParamForDetailDto detailDto) throws Exception {
        return statisticsService.alertUnitBarChartForDP(detailDto);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "月度困人故障高发使用单位-右上角更多-地市月度应急事件高发使用单位-表格",
            notes = "月度困人故障高发使用单位-右上角更多-地市月度应急事件高发使用单位-表格")
    @PostMapping("/alertUseUnitTable/dp")
    public ResponseModel<IPage<Map<String,Object>>> alertUseUnitTableForDP(@Validated @RequestBody DPFilterParamForDetailDto detailDto,
                                                                               @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                               @RequestParam(value = "size", defaultValue = "20") Integer size) throws Exception {
        detailDto.setCurrent(current);
        detailDto.setSize(size);
        return statisticsService.alertUseUnitTableForDP(detailDto);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "客运索道关键位置监控-列表",
            notes = "客运索道关键位置监控-列表")
    @PostMapping("/keyPositionMonitor/dp")
    public ResponseModel<List<JSONObject>> getKeyPositionMonitor(@Validated @RequestBody DPFilterParamForDetailDto detailDto) {
        detailDto.setEquListCode(EquipmentClassifityEnum.KYSD.getCode());
        return ResponseHelper.buildResponse(statisticsService.getKeyPositionMonitor(detailDto));
    }
}
