package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.Getter;

/**
 * 风险报告处理状态枚举
 */
@Getter
public enum RiskReportProcessStatus {

    DRAFT("草稿"),
    TO_HANDLE("待处理"),
    TO_RECTIFY("待整改"),
    TO_CONFIRM("待确认"),
    COMPLETED("已办理");

    private final String name;

    RiskReportProcessStatus(String name) {
        this.name = name;
    }

    /**
     * 根据中文名称获取枚举
     */
    public static RiskReportProcessStatus fromName(String name) {
        for (RiskReportProcessStatus status : values()) {
            if (status.name.equals(name)) {
                return status;
            }
        }
        return null;
    }
}
