package com.yeejoin.amos.boot.module.ymt.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum EquimentEnum {
    /**
     * 设备状态枚举
     *
     */

    WEIDENGJI("未登记",0),
    ZAIYONG("在用",1),
    TINGYONG("停用",2),
    BAOFEI("报废",3),
    ZHUXIAO("注销",4);
//    QIANCHU("迁出",5),
//    CHAICHU("拆除",6),
//    MULUWAI("目录外",7),
//    FEIFASHEBEI("非法设备",8);
    String name;
    Integer code;

    public static Map<Integer,String> getName=new HashMap<>();
    public static Map<String,Integer> getCode=new HashMap<>();

    static {
        for (EquimentEnum e : EquimentEnum.values()){
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }

    }
}
