package com.yeejoin.amos.boot.module.tcm.biz.controller.statistics.dp;

import com.yeejoin.amos.boot.module.tcm.api.dto.ScreenDto;
import com.yeejoin.amos.boot.module.tcm.api.service.statistics.IScreenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 大屏控制层
 *
 * @author maxy
 * @date 2024-07-09
 */
@RestController
@Api(tags = "警情接警填报记录Api")
@RequestMapping(value = "/statistics")
public class ScreenController {
    @Resource
    private IScreenService screenService;
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/companyInfo")
    @ApiOperation(httpMethod = "POST", value = "大屏企业统计", notes = "大屏企业统计")
    public ResponseModel<Map> companyInfo(@RequestBody ScreenDto screenDto){

        return screenService.companyInfo(screenDto);
    }

}
