package com.yeejoin.amos.boot.module.ymt.flc.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ymt.flc.api.dto.CylinderInfoDto;
import com.yeejoin.amos.boot.module.ymt.flc.api.entity.CylinderInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 气瓶基本信息 Mapper 接口
 *
 * @author system_generator
 * @date 2021-12-14
 */
public interface CylinderInfoMapper extends BaseMapper<CylinderInfo> {

    /**
     * 查询根据公司查询气瓶数量以及过期气瓶数
     * @param sequenceNbr
     * @return
     */
    Map<String, String> queryNumAndOutOfDateNum(@Param("sequenceNbr") Long sequenceNbr);
    

    Integer getMonthInfoTotal(@Param("regionCode") String regionCode);

    /**
     * 获取上个月气瓶总量
     * @return
     */
    Integer getLastMonthInfoTotal(@Param("regionCode") String regionCode);

    /**
     * 获取上上个月气瓶总量
     * @return
     */
    Integer getMonthBeforeLastInfoTotal(@Param("regionCode") String regionCode);

    /**
     * 根据regionCode 获取气瓶数量
     * @param regionCode
     * @return
     */
    Integer getInfoTotalByRegionCode(@Param("regionCode") String regionCode);

    Double queryIntegirtyByAppId(@Param("appId") String appId);

    Integer getWarnNum(String code);
    

    Integer getMonthInfoTotalUnit(@Param("appId") String appId);
    /**
     * 获取上个月气瓶总量-APPID
     * @return
     */
    Integer getLastMonthInfoTotalUnit(@Param("appId") String appId);

    /**
     * 获取上上个月气瓶总量-APPID
     * @return
     */
    Integer getMonthBeforeLastInfoTotalUnit(@Param("appId") String appId);

    Integer countOverDateNumber(@Param("earlyWarningLevel") String earlyWarningLevel);


    Page<CylinderInfoDto> queryPageListByEarlyWarningLevel(Page<CylinderInfoDto> page, @Param("earlyWarningLevel") String earlyWarningLevel);



    /**
     * 查询行政区划下的所有气瓶
     *
     * @param regionCode
     * @return
     */
	List<CylinderInfoDto> listWithRegionCode(Integer regionCode);

    Page<CylinderInfoDto> cyinderInfoList(Page<CylinderInfoDto> page, CylinderInfoDto cylinderInfoDto, String sort, List<String> appids);

    Page<CylinderInfoDto> getCyinderInfoList(Page<CylinderInfoDto> page);

    Page<CylinderInfoDto> cyinderOutInfoList(Page<CylinderInfoDto> page, CylinderInfoDto cylinderInfoDto, String sort, List<String> appids);


    Integer getInfoTotal();
}
