package com.yeejoin.precontrol.common.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

/**
 * 奖励兑换记录
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
public class RewardAndRetributionListVo implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * id
	 */
	@ApiModelProperty(value = "id")
	private Long id;

	/**
	 * taskId
	 */
	@ApiModelProperty(value = "taskId")
	private Long taskId;
	/**
	 * 项目id
	 */
	@ApiModelProperty(value = "项目id")
	private Long projectId;
	/**
	 * 项目名称
	 */
	@ApiModelProperty(value = "项目名称")
	private String projectName;
	/**
	 * 分包商
	 */
	@ApiModelProperty(value = "分包商")
	private String companyName;
	/**
	 * 奖励人
	 */
	@ApiModelProperty(value = "奖励人")
	private String rewardUserName;
	/**
	 * 奖励金额
	 */
	@ApiModelProperty(value = "奖励金额")
	private BigDecimal rewardMoney;
	/**
	 * 惩罚人
	 */
	@ApiModelProperty(value = "惩罚人")
	private String retributionUserName;
	/**
	 * 惩罚金额
	 */
	@ApiModelProperty(value = "惩罚金额")
	private BigDecimal retributionMoney;
	/**
	 * 违章日期
	 */
	@ApiModelProperty(value = "违章日期")
	private Date createDate;
	/**
	 * 违章类型
	 */
	@ApiModelProperty(value = "违章类型")
	private String nature;
	/**
	 * 违章分类
	 */
	@ApiModelProperty(value = "违章分类")
	private String type;

	/**
	 * 开始时间
	 */
	@ApiModelProperty(value = "开始时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date startDate;
	/**
	 * 结束时间
	 */
	@ApiModelProperty(value = "结束时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date endDate;

	/**
	 * 机构code
	 */
	@ApiModelProperty(value = "机构code")
	private String orgCode;

	private String sort;

	/**
	 * 任务结束时间
	 */
	@ApiModelProperty(value = "任务结束时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date endTime;
	
	@ApiModelProperty(value = "按人员查询")
    private Boolean byPerson;

	@ApiModelProperty(value = "按任务查询")
    private Boolean byTask;
	
	@ApiModelProperty(value = "创建人id")
	private Long createPersonId;

	@ApiModelProperty(value = "分包商id")
	private Long companyId;
	
	@ApiModelProperty(value = "uuid")
	private String uuid;
}
