package com.yeejoin.precontrol.common.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.springframework.format.annotation.DateTimeFormat;

import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.TaskPerson;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Dto
 *
 * @author duanwei
 * @date 2022-07-07
 */
@Data
public class TaskWorkVo implements Serializable {

	private static final long serialVersionUID = 1L;

	private Long id;

	@ApiModelProperty(value = "任务id")
	/**
	 * 任务id
	 */
	private Long taskId;
	@ApiModelProperty(value = "项目id")
	/**
	 * 项目id
	 */
	private Long projectId;
	@ApiModelProperty(value = "工作类型")
	/**
	 * 工作类型
	 */
	private String type;
	@ApiModelProperty(value = "发起人")
	/**
	 * 发起人
	 */
	private Long createPersonId;
	@ApiModelProperty(value = "名称")
	/**
	 * 名称
	 */
	private String name;
	@ApiModelProperty(value = "工作项")
	/**
	 * 工作项
	 */
	private String workItem;
	@ApiModelProperty(value = "更新时间")
	/**
	 * 更新时间
	 */
	private Date updateTime;

	private List<Long> personIds;

	private List<Person> persons;

	private List<String> videos;

	private List<String> photos;

	private List<String> files;

	private String createPersonName;

	private String projectName;

	private String orgCode;

	private String taskNo;

	private Date createDate;

	private String sort;

	private String sortName;

	private String sortOrder;
	
	private String postName;
	
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date startDate;
	
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date endDate;
}
