package com.yeejoin.amos.boot.module.jczs.biz.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.yeejoin.amos.boot.module.jczs.biz.utils.RedisUtil;
import com.yeejoin.amos.component.robot.AmosRequestContext;

@Service
public class StartPlatformTokenService {

	@Value("${admin.product}")
	String product;

	@Value("${admin.appkey}")
	String appkey;

	@Value("${admin.user}")
	String user;

	@Value("${admin.password}")
	String password;

	@Value("${amos.secret.key}")
	String secretKey;

	@Autowired
	RedisUtil redisUtil;
	
	@Autowired
	AmosRequestContext amosRequestContext;
	

	public void getToken() {
		RequestContext.setProduct(product);
		RequestContext.setAppKey(appkey);
		String token = amosRequestContext.getToken();
		System.out.println("token:" + token);
		RequestContext.setToken(token);
		redisUtil.set("platform_token", token);
	}
}
