package com.yeejoin.amos.boot.module.ymt.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
/**
 * 安全追溯-检验检测信息表
 *
 * @author cpp
 * @date 2023-04-20 16:36:14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="InspectionDetectionInfo", description="检验检测信息")
public class InspectionDetectionInfoModel extends BaseDto {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "")
    private String instanceId;
    @ApiModelProperty(value = "")
    private String status;
    @ApiModelProperty(value = "检验类型")
    private String inspectType;
    @ApiModelProperty(value = "检验机构名称")
    private String inspectOrgName;
    @ApiModelProperty(value = "检验报告附件")
    private String inspectReport;
    @ApiModelProperty(value = "检验人员")
    private String inspectStaff;
    @ApiModelProperty(value = "检验日期")
    private Date inspectDate;
    @ApiModelProperty(value = "检验结论")
    private String inspectConclusion;
    @ApiModelProperty(value = "安全状况等级")
    private String safetyLevel;
    @ApiModelProperty(value = "检验问题备注")
    private String problemRemark;
    @ApiModelProperty(value = "下次检验日期")
    private Date nextInspectDate;
    @ApiModelProperty(value = "设备唯一标识")
    private String sequenceCode;

    private String superviseCode;
}
