package com.yeejoin.amos.boot.module.ymt.api.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.elasticsearch.common.geo.GeoPoint;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;

/**
 * @author litw
 * @date 2021-09-26.
 */
@Data
@Accessors(chain = true)
@Document(indexName = "elev", shards = 6, replicas = 2)
public class EsElevator {


    /** 主键 */
    @Id
    private Long sequenceNbr;

    /**
     * 注册编码
     */
    @Field(type = FieldType.Text)
    private String registerCode;

    /**
     * 所属省
     */
    @Field(type = FieldType.Text)
    private String province;

    /**
     * 所属地市
     */
    @Field(type = FieldType.Text)
    private String city;

    /**
     * 所属区县
     */
    @Field(type = FieldType.Text)
    private String district;

    /**
     * 所属区域代码
     */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String regionCode;

    /**
     * 电梯识别码
     */
    @Field(type = FieldType.Text)
    private String rescueCode;

    /**
     * 电梯经度
     */
    @Field(type = FieldType.Double)
    private Double longitude;

    /**
     * 电梯纬度
     */
    @Field(type = FieldType.Double)
    private Double latitude;

    /**
     * 经纬度字段
     */
    @GeoPointField
    private GeoPoint location;

    /**
     * 地址
     */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String address;

    /**
     * 内部编码
     */
    @Field(type = FieldType.Text)
    private String innerNum;

}
