package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.yeejoin.amos.boot.module.ccs.api.dto.FireRpnChangeLogDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireRpnChangeLog;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireRpnChangeLogMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireRpnChangeLogService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.HashMap;
import java.util.Map;

/**
 * 风险点变化流水服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireRpnChangeLogServiceImpl extends BaseService<FireRpnChangeLogDto, FireRpnChangeLog, FireRpnChangeLogMapper> implements IFireRpnChangeLogService {

    @Override
    public Map<String, Object> queryForRiseUp(String stationCode) {
        Map<String, Object> result = new HashMap<>();
        //本月
        Map resultMonth = this.baseMapper.queryForRiseUp(stationCode, "1");
        //本季度
        Map resultSeason = this.baseMapper.queryForRiseUp(stationCode, "2");
        //本年
        Map resultYear = this.baseMapper.queryForRiseUp(stationCode, "3");
        result.put("month", resultMonth);
        result.put("season", resultSeason);
        result.put("year", resultYear);
        return result;
    }
}