package com.yeejoin.precontrol.common.enums;

public enum InRiskRegionEnum {
    inRiskRegion(1, "进入风险区域"),
    outRiskRegion(0, "退出风险区域");

    private int status;
    private String description;

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setStatus(String description) {
        this.description = description;
    }

    InRiskRegionEnum(int status, String description) {
        this.status = status;
        this.description = description;
    }

    public static String getDescriptionByStatus(int status) {
        String name = null;
        for (InRiskRegionEnum enumOne : InRiskRegionEnum.values()) {
            if (enumOne.getStatus() == status) {
                name = enumOne.getDescription();
                break;
            }
        }
        return name;
    }

    public static InRiskRegionEnum getEnumByStatus(int status) {
        for (InRiskRegionEnum enumOne : InRiskRegionEnum.values()) {
            if (enumOne.getStatus() == status) {
                return enumOne;
            }
        }
        return null;
    }
}
