package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.enums.ConstructionEnum;
import com.yeejoin.amos.boot.module.jg.biz.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.jg.biz.service.*;
import com.yeejoin.amos.boot.module.ymt.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgConstructionInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgInspectionDetectionInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgMainPartsDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgMaintenanceRecordInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgProtectionDevicesDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgRegisterInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquimentEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.CategoryOtherInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgRegisterInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.SuperviseInfoMapper;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.*;

import static com.alibaba.fastjson.JSON.toJSONString;


/**
 * 注册登记信息表服务实现类
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Service
public class IdxBizJgRegisterInfoServiceImpl extends BaseService<IdxBizJgRegisterInfoDto, IdxBizJgRegisterInfo, IdxBizJgRegisterInfoMapper> implements IIdxBizJgRegisterInfoService {
    //设备信息表单id
    private static final String EQUIPMENT_INFO_FORM_ID = "1734504628768239617";
    private static final String EQUSTATE = "EQU_STATE";
    private static final String CONSTRUCTIONTYPE = "CONSTRUCTION_TYPE";
    private static final String EQUDEFINE = "EQU_DEFINE";
    private static final String EQUDEFINECODE = "EQU_DEFINE_CODE";

    /**
     * levlel=company,是企业,如果不是都是监管单位,
     * * 在接口中查询当前登录人所属单位是监管单位还是企业。
     * * 如果为监管单位添加监管机构查询参数（ORG_BRANCH_CODE）；
     * * 如果为企业添加使用单位查询参数(USE_UNIT_CREDIT_CODE)
     */
    private static final String LEVEL = "company";
    // 新增修改标识
    private static final String OPERATESAVE = "save";
    private static final String OPERATEEDIT = "edit";

    // 主要零部件
    private static final String main_parts = "mainParts";
    // 安全附件
    private static final String protection_devices = "ProtectionDevices";

    @Autowired
    RestHighLevelClient restHighLevelClient;

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    IIdxBizJgUseInfoService idxBizJgUseInfoService;
    @Autowired
    IIdxBizJgDesignInfoService iIdxBizJgDesignInfoService;
    @Autowired
    IIdxBizJgFactoryInfoService iIdxBizJgFactoryInfoService;
    @Autowired
    IIdxBizJgConstructionInfoService iIdxBizJgConstructionInfoService;
    @Autowired
    IIdxBizJgMaintenanceRecordInfoService iIdxBizJgMaintenanceRecordInfoService;
    @Autowired
    IIdxBizJgSupervisionInfoService iIdxBizJgSupervisionInfoService;
    @Autowired
    IIdxBizJgOtherInfoService iIdxBizJgOtherInfoService;
    @Autowired
    IIdxBizJgInspectionDetectionInfoService iIdxBizJgInspectionDetectionInfoService;
    @Autowired
    IIdxBizJgTechParamsElevatorService iIdxBizJgTechParamsElevatorService;
    @Autowired
    IIdxBizJgMainPartsService iIdxBizJgMainPartsService;
    @Autowired
    IIdxBizJgProtectionDevicesService iIdxBizJgProtectionDevicesService;
    @Autowired
    ESEquipmentCategory esEquipmentCategory;
    @Autowired
    ICommonService commonService;

    @Autowired
    private CategoryOtherInfoMapper categoryOtherInfoMapper;
    @Autowired
    private SuperviseInfoMapper superviseInfoMapper;

    /**
     * 设备注册信息
     *
     * @param paramMap
     * @return
     */
    public ResponseModel equipmentRegisterSubmit(Map<String, Object> paramMap) {
        String record = null;
        //操作类型
        try {
            //保存数据
            record = batchSubmitOrUpdate(paramMap);
            //保存Es数据
            if (!ObjectUtils.isEmpty(record)) {
                checkEsData(record);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            //删除数据库数据和ES数据
            if (!ObjectUtils.isEmpty(record)) {
                List<String> records = new ArrayList<>();
                records.add(record);
                superviseInfoMapper.deleteDataAll(records);
                esEquipmentCategory.deleteById(record);
            }
            ResponseModel<Object> response = new ResponseModel<>();
            response.setDevMessage(e.getMessage());
            response.setResult(null);
            response.setMessage("操作失败，请检查数据输入后重新提交");
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return response;
        }
        return ResponseHelper.buildResponse(record);
    }

    /**
     * 删除设备注册信息（批量删除）
     *
     * @param map
     * @return
     */
    public boolean batchDeleteByRecord(Map<String, Object> map) {
        Object recordList = map.get("recordList");
        List<String> records = new ArrayList<>();
        List<ESEquipmentCategoryDto> list = new ArrayList<>();
        //删除ES数据
        if (recordList.toString().contains("[")) {
            for (String record : (List<String>) recordList) {
                records.add(record);
                ESEquipmentCategoryDto esEquipmentCategoryDto = new ESEquipmentCategoryDto();
                esEquipmentCategoryDto.setSEQUENCE_NBR(record);
                list.add(esEquipmentCategoryDto);
            }
        } else {
            records.add(recordList.toString());
            ESEquipmentCategoryDto esEquipmentCategoryDto = new ESEquipmentCategoryDto();
            esEquipmentCategoryDto.setSEQUENCE_NBR(recordList.toString());
            list.add(esEquipmentCategoryDto);
        }

        //删除涉及的19张表的数据
        superviseInfoMapper.deleteDataAll(records);
        //删除es中的数据
        esEquipmentCategory.deleteAll(list);
        return true;
    }

    /**
     * 查询设备注册信息详情
     *
     * @param record
     * @return
     */
    public Map<String, Map<String, Object>> getEquipmentRegisterByRecord(String record) {
        Map<String, Map<String, Object>> resultMap = new HashMap<>();
        Map<String, Object> objMap = getStringObjectMap(record, "");

        if (!ValidationUtil.isEmpty(objMap)) {
            resultMap.put(EQUIPMENT_INFO_FORM_ID, objMap);
        }
        return resultMap;
    }

    /**
     * @param record    设备Id
     * @param fieldType 返回字段类型【CamelCase:驼峰命名，“”：纯大写加下划线】
     * @return
     */
    private Map<String, Object> getStringObjectMap(String record, String fieldType) {
        Map<String, Object> objMap = new HashMap<>();
        //使用信息
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(record);
        if (!ValidationUtil.isEmpty(useInfo)) {
            Map<String, Object> useInfoMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                useInfoMap = Bean.BeantoMap(useInfo);
                useInfoMap.put("province", useInfo.getProvince()+"_"+useInfo.getProvinceName());
                useInfoMap.put("city", useInfo.getCity()+"_"+useInfo.getCityName());
                useInfoMap.put("county", useInfo.getCounty()+"_"+useInfo.getCountyName());
                useInfoMap.put("street", useInfo.getFactoryUseSiteStreet()+"_"+useInfo.getStreetName());
                useInfoMap.put("useinfoSeq", useInfo.getSequenceNbr());
            }else {
                useInfoMap = convertCamelToUnderscore(useInfo, null);
                useInfoMap.put("PROVINCE", useInfo.getProvince()+"_"+useInfo.getProvinceName());
                useInfoMap.put("CITY", useInfo.getCity()+"_"+useInfo.getCityName());
                useInfoMap.put("COUNTY", useInfo.getCounty()+"_"+useInfo.getCountyName());
                useInfoMap.put("STREET", useInfo.getFactoryUseSiteStreet()+"_"+useInfo.getStreetName());
                useInfoMap.put("USEINFO_SEQ", useInfo.getSequenceNbr());
            }
            if(!useInfoMap.isEmpty()){
                objMap.putAll(useInfoMap);
            }
        }
        //设计制造
        IdxBizJgDesignInfo designInfo = iIdxBizJgDesignInfoService.getOneData(record);
        if (!ValidationUtil.isEmpty(designInfo)) {
            Map<String, Object> designInfoMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                designInfoMap = Bean.BeantoMap(designInfo);
                designInfoMap.put("designinfoSeq", designInfo.getSequenceNbr());
                designInfoMap.put("designDoc", JSON.parseArray(designInfo.getDesignDoc()));
                designInfoMap.put("designStandard", JSON.parseArray(designInfo.getDesignStandard()));
            }else {
                String[] fields = {"DESIGN_DOC", "DESIGN_STANDARD"};
                designInfoMap = convertCamelToUnderscore(designInfo, fields);
                designInfoMap.put("DESIGNINFO_SEQ", designInfo.getSequenceNbr());
            }
            if(!designInfoMap.isEmpty()) {
                objMap.putAll(designInfoMap);
            }
        }
        //制造信息
        IdxBizJgFactoryInfo factoryInfo = iIdxBizJgFactoryInfoService.getOneData(record);
        if (!ValidationUtil.isEmpty(factoryInfo)) {
            Map<String, Object> factoryInfoMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                factoryInfoMap = Bean.BeantoMap(factoryInfo);
                String imported = factoryInfo.getImported();
                if ("0".equals(imported)) {
                    factoryInfoMap.put("importedDesc", "否");
                } else if ("1".equals(imported)) {
                    factoryInfoMap.put("importedDesc", "是");
                }
                factoryInfoMap.put("factoryinfoSeq", factoryInfo.getSequenceNbr());
                factoryInfoMap.put("factoryStandard", JSON.parseArray(factoryInfo.getFactoryStandard()));
                factoryInfoMap.put("productQualityYieldProve", JSON.parseArray(factoryInfo.getProductQualityYieldProve()));
                factoryInfoMap.put("insUseMaintainExplain", JSON.parseArray(factoryInfo.getInsUseMaintainExplain()));
            }else {
                String[] fields = {"FACTORY_STANDARD", "PRODUCT_QUALITY_YIELD_PROVE", "INS_USE_MAINTAIN_EXPLAIN"};
                factoryInfoMap = convertCamelToUnderscore(factoryInfo, fields);
                String imported = factoryInfo.getImported();
                if ("0".equals(imported)) {
                    factoryInfoMap.put("IMPORTED_DESC", "否");
                } else if ("1".equals(imported)) {
                    factoryInfoMap.put("IMPORTED_DESC", "是");
                }
                factoryInfoMap.put("FACTORYINFO_SEQ", factoryInfo.getSequenceNbr());
            }
            if(!factoryInfoMap.isEmpty()) {
                objMap.putAll(factoryInfoMap);
            }
        }
        //施工信息 【一对多，暂时只取最新一条数据】
        IdxBizJgConstructionInfo constructionInfo = iIdxBizJgConstructionInfoService.queryNewestDetailByRecord(record);
        if (!ValidationUtil.isEmpty(constructionInfo)) {
            Map<String, Object> constructionInfoMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                constructionInfoMap = Bean.BeantoMap(constructionInfo);
                constructionInfoMap.put("constructioninfoSeq", constructionInfo.getSequenceNbr());
            }else {
                constructionInfoMap = convertCamelToUnderscore(constructionInfo, null);
                constructionInfoMap.put("CONSTRUCTIONINFO_SEQ", constructionInfo.getSequenceNbr());
            }
            if(!constructionInfoMap.isEmpty()) {
                objMap.putAll(constructionInfoMap);
            }
        }
        //注册登记
        IdxBizJgRegisterInfo registerInfo = this.getOne(new QueryWrapper<IdxBizJgRegisterInfo>().eq("RECORD", record));
        if (!ValidationUtil.isEmpty(registerInfo)) {
            String equCategory = registerInfo.getEquCategory();//设备类别
            String equDefine = registerInfo.getEquDefine();//设备品种
            List<EquipmentCategory> categoryList1 = commonService.getEquipmentCategoryList(equCategory, null);
            List<EquipmentCategory> categoryList2 = commonService.getEquipmentCategoryList(equDefine, null);
            Map<String, Object> registerInfoMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                registerInfoMap = Bean.BeantoMap(registerInfo);
                registerInfoMap.put("registerinfoSeq", registerInfo.getSequenceNbr());
                registerInfoMap.put("sequenceNbr", registerInfo.getSequenceNbr());
                registerInfoMap.put("productPhoto", JSON.parseArray(registerInfo.getProductPhoto()));
                if (CollectionUtils.isNotEmpty(categoryList1)) {
                    registerInfoMap.put("equCategoryDesc", categoryList1.get(0).getName());
                }
                if (CollectionUtils.isNotEmpty(categoryList2)) {
                    registerInfoMap.put("equDefineDesc", categoryList2.get(0).getName());
                }
            }else {
                String[] fields = {"PRODUCT_PHOTO"};
                registerInfoMap = convertCamelToUnderscore(registerInfo, fields);
                registerInfoMap.put("REGISTERINFO_SEQ", registerInfo.getSequenceNbr());
                registerInfoMap.put("SEQUENCE_NBR", registerInfo.getSequenceNbr());
                if (CollectionUtils.isNotEmpty(categoryList1)) {
                    registerInfoMap.put("EQU_CATEGORY_DESC", categoryList1.get(0).getName());
                }
                if (CollectionUtils.isNotEmpty(categoryList2)) {
                    registerInfoMap.put("EQU_DEFINE_DESC", categoryList2.get(0).getName());
                }
            }
            if(!registerInfoMap.isEmpty()) {
                objMap.putAll(registerInfoMap);
            }
        }
        //维保备案【一对多，暂时只取最新一条数据】
        IdxBizJgMaintenanceRecordInfo maintenanceRecordInfo = iIdxBizJgMaintenanceRecordInfoService.queryNewestDetailByRecord(record);
        if (!ValidationUtil.isEmpty(maintenanceRecordInfo)) {
            Map<String, Object> maintenanceRecordInfoMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                maintenanceRecordInfoMap = Bean.BeantoMap(maintenanceRecordInfo);
                maintenanceRecordInfoMap.put("maintenancerecordinfoSeq", maintenanceRecordInfo.getSequenceNbr());
            }else {
                maintenanceRecordInfoMap = convertCamelToUnderscore(maintenanceRecordInfo, null);
                maintenanceRecordInfoMap.put("MAINTENANCERECORDINFO_SEQ", maintenanceRecordInfo.getSequenceNbr());
            }
            if(!maintenanceRecordInfoMap.isEmpty()) {
                objMap.putAll(maintenanceRecordInfoMap);
            }
        }
        //监督管理
        IdxBizJgSupervisionInfo supervisionInfo = iIdxBizJgSupervisionInfoService.getOneData(record);
        if (!ValidationUtil.isEmpty(supervisionInfo)) {
            Map<String, Object> supervisionInfoMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                supervisionInfoMap = Bean.BeantoMap(supervisionInfo);
                supervisionInfoMap.put("supervisioninfoSeq", supervisionInfo.getSequenceNbr());
            }else {
                supervisionInfoMap = convertCamelToUnderscore(supervisionInfo, null);
                supervisionInfoMap.put("SUPERVISIONINFO_SEQ", supervisionInfo.getSequenceNbr());
            }
            if(!supervisionInfoMap.isEmpty()) {
                objMap.putAll(supervisionInfoMap);
            }
        }
        //其他信息
        IdxBizJgOtherInfo otherInfo = iIdxBizJgOtherInfoService.getOneData(record);
        if (!ValidationUtil.isEmpty(otherInfo)) {
            Map<String, Object> otherInfoMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                otherInfoMap = Bean.BeantoMap(otherInfo);
                otherInfoMap.put("otherinfoSeq", otherInfo.getSequenceNbr());
            }else {
                otherInfoMap = convertCamelToUnderscore(otherInfo, null);
                otherInfoMap.put("OTHERINFO_SEQ", otherInfo.getSequenceNbr());
            }
            if(!otherInfoMap.isEmpty()) {
                objMap.putAll(otherInfoMap);
            }
        }
        //检验检测【一对多，暂时只取最新一条数据】
        IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = iIdxBizJgInspectionDetectionInfoService.queryNewestDetailByRecord(record);
        if (!ValidationUtil.isEmpty(inspectionDetectionInfo)) {
            Map<String, Object> inspectionDetectionInfoMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                inspectionDetectionInfoMap = Bean.BeantoMap(inspectionDetectionInfo);
                inspectionDetectionInfoMap.put("inspectiondetectioninfoSeq", inspectionDetectionInfo.getSequenceNbr());
                inspectionDetectionInfoMap.put("inspectReport", JSON.parseArray(inspectionDetectionInfo.getInspectReport()));
            }else {
                String[] fields = {"INSPECT_REPORT"};
                inspectionDetectionInfoMap = convertCamelToUnderscore(inspectionDetectionInfo, fields);
                inspectionDetectionInfoMap.put("INSPECTIONDETECTIONINFO_SEQ", inspectionDetectionInfo.getSequenceNbr());
            }
            if(!inspectionDetectionInfoMap.isEmpty()) {
                objMap.putAll(inspectionDetectionInfoMap);
            }
        }

        //电梯
        IdxBizJgTechParamsElevator elevator = iIdxBizJgTechParamsElevatorService.getOneData(record);
        if (!ValidationUtil.isEmpty(elevator)) {
            Map<String, Object> elevatorMap = null;
            if(!ValidationUtil.isEmpty(fieldType)){
                elevatorMap = Bean.BeantoMap(elevator);
                elevatorMap.put("elevatorSeq", elevator.getSequenceNbr());
                elevatorMap.put("explosionproofSignComplete", JSON.parseArray(elevator.getExplosionproofSignComplete()));
            }else {
                String[] fields = {"EXPLOSIONPROOF_SIGN_COMPLETE"};
                elevatorMap = convertCamelToUnderscore(elevator, fields);
                elevatorMap.put("ELEVATOR_SEQ", elevator.getSequenceNbr());
            }
            if(!elevatorMap.isEmpty()) {
                objMap.putAll(elevatorMap);
            }
        }
        //厂车
        //索道
        //游乐设施
        //锅炉
        //压力容器
        //压力管道
        //起重机械

        //主要零部件【一对多，查出多条数据】
        List<IdxBizJgMainParts> mainParts = iIdxBizJgMainPartsService.queryListByRecord(record);
        if (!ValidationUtil.isEmpty(mainParts)) {
            Map<String, Object> mainPartsResultMap = new HashMap<>();
            if(!ValidationUtil.isEmpty(fieldType)){
                List<Map<String, Object>> list = new ArrayList<>();
                for(IdxBizJgMainParts mainPart : mainParts){
                    Map<String, Object> mainPartsMap = null;
                    mainPartsMap = Bean.BeantoMap(mainPart);
                    mainPartsMap.put("mainpartsSeq", mainPart.getSequenceNbr());
                    list.add(mainPartsMap);
                }
               if(!ValidationUtil.isEmpty(list)){
                   mainPartsResultMap.put("mainparts",list);
               }
            }else {
                List<Map<String, Object>> list = new ArrayList<>();
                for(IdxBizJgMainParts mainPart : mainParts){
                    Map<String, Object> mainPartsMap = null;
                    mainPartsMap = convertCamelToUnderscore(mainPart, null);
                    mainPartsMap.put("MAINPARTS_SEQ", mainPart.getSequenceNbr());
                    list.add(mainPartsMap);
                }
                if(!ValidationUtil.isEmpty(list)){
                    mainPartsResultMap.put("MAINPARTS",list);
                }
            }

            if(!mainPartsResultMap.isEmpty()) {
                objMap.putAll(mainPartsResultMap);
            }
        }
        //安全附件【一对多，查出多条数据】
        List<IdxBizJgProtectionDevices> protectionDevices = iIdxBizJgProtectionDevicesService.queryListByRecord(record);
        if (!ValidationUtil.isEmpty(protectionDevices)) {
            Map<String, Object> protectionDevicesResultMap = new HashMap<>();

            if(!ValidationUtil.isEmpty(fieldType)){
                List<Map<String, Object>> list = new ArrayList<>();
                for(IdxBizJgProtectionDevices protectionDevice : protectionDevices){
                    Map<String, Object> protectionDeviceMap = null;
                    protectionDeviceMap = Bean.BeantoMap(protectionDevice);
                    protectionDeviceMap.put("protectiondevicesSeq", protectionDevice.getSequenceNbr());
                    list.add(protectionDeviceMap);
                }
                if(!ValidationUtil.isEmpty(list)){
                    protectionDevicesResultMap.put("protectionDevices",list);
                }
            }else {
                List<Map<String, Object>> list = new ArrayList<>();
                for(IdxBizJgProtectionDevices protectionDevice : protectionDevices){
                    Map<String, Object> protectionDeviceMap = null;
                    protectionDeviceMap = convertCamelToUnderscore(protectionDevice, null);
                    protectionDeviceMap.put("PROTECTIONDEVICES_SEQ", protectionDevice.getSequenceNbr());
                    list.add(protectionDeviceMap);
                }
                if(!ValidationUtil.isEmpty(list)){
                    protectionDevicesResultMap.put("PROTECTIONDEVICES",list);
                }
            }
            if(!protectionDevicesResultMap.isEmpty()) {
                objMap.putAll(protectionDevicesResultMap);
            }
        }
        return objMap;
    }

    public Map<String, Object> getDetailByRecord(String record) {
        return getStringObjectMap(record, "");
    }

    public Map<String, Object> getDetailFieldCamelCaseByRecord(String record) {
        return getStringObjectMap(record, "CamelCase");
    }


    /**
     * 设备注册信息分页查询
     *
     * @param map
     * @return
     */
    public Page<JSONObject> queryForEquipmentRegisterPage(JSONObject map) {
        Page<JSONObject> result = new Page<>(map.getInteger("number"), map.getInteger("size"));
        SearchRequest request = new SearchRequest();
        request.indices("idx_biz_view_jg_all");
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.trackTotalHits(true);
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();

        //根据当前登录人查询
        if (!ValidationUtil.isEmpty(map.get(EQUSTATE))) {
            map.put(EQUSTATE, EquimentEnum.getCode.get(map.get(EQUSTATE).toString()).toString());
        }
        //获取当前登录人单位类型
        List<JSONObject> companyType = getCompanyType();
        if (!ValidationUtil.isEmpty(companyType)) {
            JSONObject object = getCompanyType().get(0);
            String level = object.getString("level");
            String code = object.getString("orgCode");
            String companyCode = object.getString("companyCode").contains("_") ?
                    object.getString("companyCode").split("_")[1] : object.getString("companyCode");
            String type = object.getString("companyType");

            // 根据当前登录用户类型及管辖机构筛选条件添加对应参数
            if (!ValidationUtil.isEmpty(level)) {
                if (LEVEL.equals(level)) {
                    //企业
                    if (!ValidationUtil.isEmpty(type) && ValidationUtil.equals(type, "使用单位")) {
                        map.put("USE_UNIT_CREDIT_CODE", companyCode);
                    } else if (!ValidationUtil.isEmpty(type) && ValidationUtil.equals(type, "安装改造维修单位")) {
                        map.put("USC_UNIT_CREDIT_CODE", companyCode);
                    }

                    if (!ObjectUtils.isEmpty(map.getString("ORG_BRANCH_CODE"))) {
                        BoolQueryBuilder query = QueryBuilders.boolQuery();
                        String test = QueryParser.escape(map.getString("ORG_BRANCH_CODE"));
                        query.must(QueryBuilders.matchPhrasePrefixQuery("ORG_BRANCH_CODE", test));
                        boolMust.must(query);
                    }
                } else {
                    if (!ObjectUtils.isEmpty(map.getString("ORG_BRANCH_CODE"))) {
                        String paramCode = map.getString("ORG_BRANCH_CODE");
                        if (paramCode.contains(code)) {
                            BoolQueryBuilder query = QueryBuilders.boolQuery();
                            String test = QueryParser.escape(map.getString("ORG_BRANCH_CODE"));
                            query.must(QueryBuilders.matchPhrasePrefixQuery("ORG_BRANCH_CODE", test));
                            boolMust.must(query);
                        } else {
                            return result;
                        }
                    } else {
                        //监管单位
                        map.put("ORG_BRANCH_CODE", code);
                    }
                }
            }
        }

        // 默认条件【STATUS==="" || null】
        BoolQueryBuilder meBuilder = QueryBuilders.boolQuery();
        meBuilder.must(QueryBuilders.boolQuery()
                .should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery("STATUS")))
                .should(QueryBuilders.boolQuery().must(QueryBuilders.matchPhraseQuery("STATUS", ""))));
        boolMust.must(meBuilder);

        String queryType = map.getString("QUERY_TYPE");
        // //查询 安装告知【可告知设备列表】【EQU_STATE=== null】
        if (!ObjectUtils.isEmpty(queryType) && ValidationUtil.equals(queryType, "AZ")) {
            BoolQueryBuilder azBuilder = QueryBuilders.boolQuery();
            azBuilder.mustNot(QueryBuilders.existsQuery("EQU_STATE"));
            boolMust.must(azBuilder);
        }
        //查询 维保备案【可绑定设备列表】【(EQU_STATE=== null） && (INSPECT_REPORT！==""  && !null)】
        // if (!ObjectUtils.isEmpty(queryType) && ValidationUtil.equals(queryType, "WB")) {
        //     BoolQueryBuilder wbBuilder = QueryBuilders.boolQuery();
        //     wbBuilder.mustNot(QueryBuilders.existsQuery("EQU_STATE"));
        //     wbBuilder.must(QueryBuilders.existsQuery("INSPECT_REPORT"));
        //     wbBuilder.mustNot(QueryBuilders.matchPhraseQuery("INSPECT_REPORT", ""));
        //     boolMust.must(wbBuilder);
        // }
        //查询 使用登记【可选设备列表】【EQU_STATUS=== null && (INSPECT_REPORT！=="" && !null) && (USE_ORG_CODE!=="" && !null)】
        if (!ObjectUtils.isEmpty(queryType) && ValidationUtil.equals(queryType, "SY")) {
            BoolQueryBuilder syBuilder = QueryBuilders.boolQuery();
            syBuilder.mustNot(QueryBuilders.existsQuery("EQU_STATE"));
            syBuilder.must(QueryBuilders.existsQuery("INSPECT_REPORT"));
            syBuilder.mustNot(QueryBuilders.matchPhraseQuery("INSPECT_REPORT", ""));
            syBuilder.must(QueryBuilders.existsQuery("USE_ORG_CODE"));
            syBuilder.mustNot(QueryBuilders.matchPhraseQuery("USE_ORG_CODE", ""));
            boolMust.must(syBuilder);
        }

        //通用匹配规则，其他条件构建
        if (!ObjectUtils.isEmpty(map.getString("SEQUENCE_NBR"))) {
            BoolQueryBuilder seqBuilder = QueryBuilders.boolQuery();
            String param = map.getString("SEQUENCE_NBR");
            String[] split = param.split(",");
            for (String seq : split) {
                seqBuilder.should(QueryBuilders.termQuery("SEQUENCE_NBR.keyword", seq));
            }
            seqBuilder.minimumShouldMatch(1);
            boolMust.must(seqBuilder);
        }
        if (!ObjectUtils.isEmpty(map.getString("EQU_CATEGORY"))) {
            BoolQueryBuilder pBuilder = QueryBuilders.boolQuery();
            String param = QueryParser.escape(map.getString("EQU_CATEGORY"));
            pBuilder.must(QueryBuilders.matchPhraseQuery("EQU_CATEGORY", "*" + param + "*"));
            boolMust.must(pBuilder);

        }
        if (!ObjectUtils.isEmpty(map.getString("USE_PLACE"))) {
            BoolQueryBuilder pBuilder = QueryBuilders.boolQuery();
            String param = QueryParser.escape(map.getString("USE_PLACE"));
            pBuilder.must(QueryBuilders.matchPhraseQuery("USE_PLACE", "*" + param + "*"));
            boolMust.must(pBuilder);
        }
        //设备状态
        if (!ObjectUtils.isEmpty(map.getString("EQU_STATE"))) {
            BoolQueryBuilder esBuilder = QueryBuilders.boolQuery();
            String param = QueryParser.escape(map.getLong("EQU_STATE").toString());
            esBuilder.must(QueryBuilders.matchQuery("EQU_STATE", param));
            boolMust.must(esBuilder);
        }
        //使用单位
        if (!ObjectUtils.isEmpty(map.getString("USE_UNIT_CREDIT_CODE"))) {
            BoolQueryBuilder uuccBuilder = QueryBuilders.boolQuery();
            String param = QueryParser.escape(map.getString("USE_UNIT_CREDIT_CODE"));
            uuccBuilder.must(QueryBuilders.matchPhraseQuery("USE_UNIT_CREDIT_CODE", param));
            boolMust.must(uuccBuilder);
        }
        //安装改造维修单位
        if (!ObjectUtils.isEmpty(map.getString("USC_UNIT_CREDIT_CODE"))) {
            BoolQueryBuilder uuccBuilder = QueryBuilders.boolQuery();
            String param = QueryParser.escape(map.getString("USC_UNIT_CREDIT_CODE"));
            uuccBuilder.must(QueryBuilders.matchPhraseQuery("USC_UNIT_CREDIT_CODE", param));
            boolMust.must(uuccBuilder);
        }
        //监管码
        if (!ObjectUtils.isEmpty(map.getString("SUPERVISORY_CODE"))) {
            BoolQueryBuilder scBuilder = QueryBuilders.boolQuery();
            String param = map.getString("SUPERVISORY_CODE");
            String[] split = param.split(",");
            for (String code : split) {
                scBuilder.should(QueryBuilders.termQuery("SUPERVISORY_CODE", code));
            }
            scBuilder.minimumShouldMatch(1);
            boolMust.must(scBuilder);
        }
        //设备种类编码
        if (!ObjectUtils.isEmpty(map.getString("EQU_LIST_CODE"))) {
            BoolQueryBuilder elcBuilder = QueryBuilders.boolQuery();
            String test = QueryParser.escape(map.getString("EQU_LIST_CODE"));
            elcBuilder.must(QueryBuilders.matchPhraseQuery("EQU_LIST_CODE", test));
            boolMust.must(elcBuilder);
        }
        //设备种类名称
        if (!ObjectUtils.isEmpty(map.getString("EQU_LIST"))) {
            BoolQueryBuilder elBuilder = QueryBuilders.boolQuery();
            String test = QueryParser.escape(map.getString("EQU_LIST"));
            elBuilder.must(QueryBuilders.matchPhraseQuery("EQU_LIST", "*" + test + "*"));
            boolMust.must(elBuilder);
        }


        builder.query(boolMust);
        builder.sort("REC_DATE", SortOrder.DESC);
        builder.from((map.getInteger("number") - 1) * map.getInteger("size"));
        builder.size(map.getInteger("size"));
        request.source(builder);
        List<JSONObject> list = new LinkedList<>();
        long totle = 0;

        try {
            SearchResponse response = restHighLevelClient.search(request, RequestOptions.DEFAULT);
            for (org.elasticsearch.search.SearchHit hit : response.getHits().getHits()) {
                System.out.println(hit);
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hit);
                JSONObject dto2 = jsonObject.getJSONObject("sourceAsMap");
                if (!ValidationUtil.isEmpty(dto2.get(CONSTRUCTIONTYPE))) {
                    //转化施工类型
                    Integer integer = Integer.valueOf(dto2.get(CONSTRUCTIONTYPE).toString());
                    String status = ConstructionEnum.getName.get(integer);
                    dto2.put(CONSTRUCTIONTYPE, status);
                }
                list.add(dto2);
            }
            totle = response.getInternalResponse().hits().getTotalHits().value;
            result.setRecords(list);
            result.setTotal(totle);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    /**
     * 获取当前登录人单位类型
     *
     * @return
     */
    public List<JSONObject> getCompanyType() {

        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        List<CompanyModel> companys = reginParams.getUserModel().getCompanys();

        List<JSONObject> objectList = new ArrayList<>();
        if (!ValidationUtil.isEmpty(companys)) {
            for (CompanyModel company : companys) {
                JSONObject object = new JSONObject();
                object.put("level", company.getLevel());
                object.put("orgCode", company.getOrgCode());
                object.put("companyCode", company.getCompanyCode());
                object.put("companyType", company.getCompanyType());
                objectList.add(object);
            }
        }
        return objectList;
    }

    private String batchSubmitOrUpdate(Map<String, Object> map) {
        Date date = new Date();
        String record = null;
        LinkedHashMap equipmentInfoForm = (LinkedHashMap) map.get(EQUIPMENT_INFO_FORM_ID);
        //操作类型
        String operateType = ValidationUtil.isEmpty(equipmentInfoForm.get("SEQUENCE_NBR")) ? OPERATESAVE : OPERATEEDIT;
        record = OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : equipmentInfoForm.get("RECORD").toString();

        //使用信息
        IdxBizJgUseInfo useInfo = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgUseInfo.class);
        useInfo.setRecord(record);
        useInfo.setRecDate(date);
        useInfo.setSequenceNbr(OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : String.valueOf(equipmentInfoForm.get("USEINFO_SEQ")));
        idxBizJgUseInfoService.saveOrUpdateData(useInfo);

        //设计制造
        IdxBizJgDesignInfo designInfo = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgDesignInfo.class);
        designInfo.setRecord(record);
        designInfo.setRecDate(date);
        designInfo.setSequenceNbr(OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : String.valueOf(equipmentInfoForm.get("DESIGNINFO_SEQ")));
        iIdxBizJgDesignInfoService.saveOrUpdateData(designInfo);

        //制造信息
        IdxBizJgFactoryInfo factoryInfo = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgFactoryInfo.class);
        factoryInfo.setRecord(record);
        factoryInfo.setRecDate(date);
        factoryInfo.setSequenceNbr(OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : String.valueOf(equipmentInfoForm.get("FACTORYINFO_SEQ")));
        iIdxBizJgFactoryInfoService.saveOrUpdateData(factoryInfo);

        //施工信息
        IdxBizJgConstructionInfo constructionInfo = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgConstructionInfo.class);
        constructionInfo.setRecord(record);
        constructionInfo.setRecDate(date);
        constructionInfo.setSequenceNbr(OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : String.valueOf(equipmentInfoForm.get("CONSTRUCTIONINFO_SEQ")));
        iIdxBizJgConstructionInfoService.saveOrUpdateData(constructionInfo);

        //注册登记
        IdxBizJgRegisterInfo registerInfo = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgRegisterInfo.class);
        registerInfo.setRecord(record);
        registerInfo.setRecDate(date);
        registerInfo.setSequenceNbr(OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : String.valueOf(equipmentInfoForm.get("REGISTERINFO_SEQ")));
        this.saveOrUpdate(registerInfo);

        //维保备案
        IdxBizJgMaintenanceRecordInfo maintenanceRecordInfo = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgMaintenanceRecordInfo.class);
        maintenanceRecordInfo.setRecord(record);
        maintenanceRecordInfo.setRecDate(date);
        maintenanceRecordInfo.setSequenceNbr(OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : String.valueOf(equipmentInfoForm.get("MAINTENANCERECORDINFO_SEQ")));
        iIdxBizJgMaintenanceRecordInfoService.saveOrUpdateData(maintenanceRecordInfo);

        //监督管理
        IdxBizJgSupervisionInfo supervisionInfo = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgSupervisionInfo.class);
        supervisionInfo.setRecord(record);
        supervisionInfo.setRecDate(date);
        supervisionInfo.setSequenceNbr(OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : String.valueOf(equipmentInfoForm.get("SUPERVISIONINFO_SEQ")));
        iIdxBizJgSupervisionInfoService.saveOrUpdateData(supervisionInfo);

        //其他信息
        IdxBizJgOtherInfo otherInfo = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgOtherInfo.class);
        otherInfo.setRecord(record);
        otherInfo.setRecDate(date);
        otherInfo.setSequenceNbr(OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : String.valueOf(equipmentInfoForm.get("OTHERINFO_SEQ")));
        iIdxBizJgOtherInfoService.saveOrUpdateData(otherInfo);

        //检验检测
        IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgInspectionDetectionInfo.class);
        inspectionDetectionInfo.setRecord(record);
        inspectionDetectionInfo.setRecDate(date);
        inspectionDetectionInfo.setSequenceNbr(OPERATESAVE.equals(operateType) ? UUID.randomUUID().toString() : String.valueOf(equipmentInfoForm.get("INSPECTIONDETECTIONINFO_SEQ")));
        iIdxBizJgInspectionDetectionInfoService.saveOrUpdateData(inspectionDetectionInfo);


        //八大类技术参数表
        //电梯
        IdxBizJgTechParamsElevator elevator = JSON.parseObject(JSON.toJSONString(equipmentInfoForm), IdxBizJgTechParamsElevator.class);
        if (!ValidationUtil.isEmpty(elevator)) {
            elevator.setRecord(record);
            elevator.setRecDate(date);
            elevator.setSequenceNbr(OPERATESAVE.equals(operateType) ? null : String.valueOf(equipmentInfoForm.get("ELEVATOR_SEQ")));
            iIdxBizJgTechParamsElevatorService.saveOrUpdateData(elevator);
        }
        //厂车
        //索道
        //游乐设施
        //锅炉
        //压力容器
        //压力管道
        //起重机械

        //八大类技术参数中主要零部件和安全附件表
        List<IdxBizJgMainParts> mainPartsList = new ArrayList<>();
        List<IdxBizJgProtectionDevices> protectionDevicesList = new ArrayList<>();
        //要零部件
        List<String> subFormMainPartsList = new ArrayList<>();
        subFormMainPartsList.add("subForm_fie04854f2");
        mainPartsList = getAccessoryEntity(equipmentInfoForm, subFormMainPartsList, main_parts, record, date, operateType);
        //安全附件
        List<String> subFormProtectionDevicesList = new ArrayList<>();
        subFormProtectionDevicesList.add("subForm_d4xdzhsgdj");
        protectionDevicesList = getAccessoryEntity(equipmentInfoForm, subFormProtectionDevicesList, protection_devices, record, date, operateType);

        if (!ValidationUtil.isEmpty(mainPartsList)) {
            iIdxBizJgMainPartsService.saveOrUpdateBatchData(mainPartsList);
        }
        if (!ValidationUtil.isEmpty(protectionDevicesList)) {
            iIdxBizJgProtectionDevicesService.saveOrUpdateBatchData(protectionDevicesList);
        }
        return record;
    }


    public void checkEsData(String id) {
        Map<String, Object> map = categoryOtherInfoMapper.selectDataById(id);
        categoryOtherInfoMapper.updateEsStatus(id);
        ESEquipmentCategoryDto dto = JSON.parseObject(toJSONString(map), ESEquipmentCategoryDto.class);
        Optional<ESEquipmentCategoryDto> data = esEquipmentCategory.findById(id);
        if (!ObjectUtils.isEmpty(data)) {
            esEquipmentCategory.deleteById(id);
        }
        if (!ObjectUtils.isEmpty(dto)) {
            long time = Timestamp.valueOf(map.get("REC_DATE").toString().substring(0, 19)).getTime();
            dto.setREC_DATE(time);
            esEquipmentCategory.save(dto);
        }
    }

    private List getAccessoryEntity(Map<String, Object> map, List<String> list, String subFormType, String record, Date date, String type) {
        List<IdxBizJgMainParts> mainPartsList = new ArrayList<>();
        List<IdxBizJgProtectionDevices> protectionDevicesList = new ArrayList<>();

        if ("mainParts".equals(subFormType)) {
            for (Object s : list) {
                List subFormMainPartsList = (ArrayList) map.get(s);
                if (!ObjectUtils.isEmpty(subFormMainPartsList)) {
                    for (Object obj : subFormMainPartsList) {
                        HashMap<String, Object> objMap = (HashMap<String, Object>) obj;
                        IdxBizJgMainParts mainParts = JSON.parseObject(JSON.toJSONString(objMap), IdxBizJgMainParts.class);
                        mainParts.setRecord(record);
                        mainParts.setRecDate(date);
                        mainParts.setSequenceNbr("save".equals(type) ? null : String.valueOf(objMap.get("MAINPARTS_SEQ")));
                        mainPartsList.add(mainParts);
                    }
                }
            }
            return mainPartsList;
        } else {
            for (Object s : list) {
                List subFormProtectionDevicesList = (ArrayList) map.get(s);
                if (!ObjectUtils.isEmpty(subFormProtectionDevicesList)) {
                    for (Object obj : subFormProtectionDevicesList) {
                        HashMap<String, Object> objMap = (HashMap<String, Object>) obj;
                        IdxBizJgProtectionDevices protectionDevices = JSON.parseObject(JSON.toJSONString(objMap), IdxBizJgProtectionDevices.class);
                        protectionDevices.setRecord(record);
                        protectionDevices.setRecDate(date);
                        protectionDevices.setSequenceNbr("save".equals(type) ? null : String.valueOf(objMap.get("PROTECTIONDEVICES_SEQ")));
                        protectionDevicesList.add(protectionDevices);
                    }
                }
            }
            return protectionDevicesList;
        }
    }

    /**
     * 将对象的属性由驼峰转为纯大写下划线格式
     *
     * @param object
     * @return
     * @throws IllegalAccessException
     */
    public static Map<String, Object> convertCamelToUnderscore(Object object, String[] strToJsonArrayFields) {
        Map<String, Object> result = new HashMap<>();
        Class<?> clazz = object.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            String underscoreFieldName = StringUtils.camelToUnderline(fieldName).toUpperCase();
            Object value;
            try {
                value = field.get(object);
                //需要转为jsonArray的字段
                if (!ValidationUtil.isEmpty(strToJsonArrayFields) && Arrays.asList(strToJsonArrayFields).contains(underscoreFieldName)) {
                    value = JSON.parseArray((String) field.get(object));
                }
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if(!ValidationUtil.isEmpty(value)){
                result.put(underscoreFieldName.toUpperCase(), value);
            }
        }
        return result;
    }
}