package com.yeejoin.amos.boot.module.ymt.api.enums;

/**
 * <pre>
 * 特种设备类别枚举
 * </pre>
 *
 * @author tb
 */
public enum SpecialEquipmentCategoryEnum {

	ELEVATOR("3000", "电梯"),
	PRESSURE_VESSEL("2000", "压力容器");

	/**
	 * 编码
	 */
	private String code;

	/**
	 * 名称
	 */
	private String name;

	// 构造方法
	SpecialEquipmentCategoryEnum(String code, String name) {
		this.code = code;
		this.name = name;
	}

	public static SpecialEquipmentCategoryEnum getEnum(String code) {
		for (SpecialEquipmentCategoryEnum specialEquipmentCategoryEnum : SpecialEquipmentCategoryEnum.values()) {
			if (specialEquipmentCategoryEnum.getCode().equals(code)) {
				return specialEquipmentCategoryEnum;
			}
		}
		return null;
	}

	public String getCode() {
		return code;
	}

	public String getName() {
		return name;
	}
}
