package com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.module.jg.api.annotation.DictCode2DictName;
import lombok.Data;

/**
 * 登记证
 */
@Data
public class CertificateVo {

    @ExcelIgnore
    String sequenceNbr;
    
    @ExcelProperty(value = "使用登记证编号")
    String useRegistrationCode;
    
    @ExcelProperty(value = "登记类型")
    String regType;
    
    @ExcelProperty(value = "使用单位")
    String useUnitName;
    
    @ExcelProperty(value = "使用单位地址")
    String useUnitAddress;
    
    @ExcelProperty(value = "登记机关")
    String receiveOrgName;
    
    @ExcelProperty(value = "设备种类")
    @DictCode2DictName(typeHandler = "equipCategoryDictTypeHandler")
    String equList;
    
    @ExcelProperty(value = "设备类别")
    @DictCode2DictName(typeHandler = "equipCategoryDictTypeHandler")
    String equCategory;
    
    @ExcelProperty(value = "设备品种")
    @DictCode2DictName(typeHandler = "equipCategoryDictTypeHandler")
    String equDefine;
    
    @ExcelProperty(value = "设备使用地址")
    String equUseAddress;
    
    @ExcelProperty(value = "使用登记证状态")
    String certificateStatus;
    
    @ExcelProperty(value = "办理日期")
    String auditPassDate;

    @ExcelProperty(value = "产品名称")
    String productName;

    @ExcelProperty(value = "产品编号")
    String factoryNum;

    @ExcelProperty(value = "单位内编号")
    String useInnerCode;

    @ExcelProperty(value = "设备代码")
    String equCode;

    @ExcelProperty(value = "监管码")
    String supervisoryCode;

    @ExcelProperty(value = "设备状态")
    String equStateName;

    @ExcelProperty(value = "工程（装置）名称")
    String projectContraption;

    @ExcelProperty(value = "工程（装置）编号")
    String projectContraptionNo;

    @ExcelProperty(value = "管道设备数量（m）")
    String pipelineLength;

    @ExcelProperty(value = "管道使用地点")
    String fullAddress;
}
