package com.yeejoin.amos.boot.module.jyjc.api.model;


import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2023-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JyjcInspectionApplicationModel", description = "")
public class JyjcInspectionApplicationModel extends BaseModel {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "检验检测单位编码")
    private String inspectionUnitCode;

    @ApiModelProperty(value = "检验检测单位名称")
    private String inspectionUnitName;

    @ApiModelProperty(value = "检验检测类型")
    private String inspectionType;

    @ApiModelProperty(value = "检验检测类型名称")
    private String inspectionTypeName;

    @ApiModelProperty(value = "设备种类")
    private String equipClassify;

    @ApiModelProperty(value = "报检单号")
    private String applicationNo;

    @ApiModelProperty(value = "申请日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applicationDate;

    @ApiModelProperty(value = "检验检测类别")
    private String inspectionClassify;

    @ApiModelProperty(value = "申请联系人")
    private String applicationContactName;

    @ApiModelProperty(value = "申请联系人电话")
    private String applicationContactPhone;

    @ApiModelProperty(value = "申请说明")
    private String applicationRemark;

    @ApiModelProperty(value = "业务负责人")
    private String inspectionChargePerson;

    @ApiModelProperty(value = "项目负责人联系电话（检验员联系电话）")
    private String inspectionChargePhone;

    @ApiModelProperty(value = "说明（受理说明、退回原因、转办说明）")
    private String processDescription;

    @ApiModelProperty(value = "原始报检单号")
    private String originalApplicationNo;

    @ApiModelProperty(value = "受理日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date acceptDate;

    @ApiModelProperty(value = "报检单位编号")
    private String applicationUnitCode;

    @ApiModelProperty(value = "报检单位名称")
    private String applicationUnitName;

    @ApiModelProperty(value = "报检单位地址")
    private String address;

    @ApiModelProperty(value = "监管单位名称")
    private String superviseOrgName;

    @ApiModelProperty(value = "包含设备数量（冗余）")
    private Integer numberOfEquip;

    @ApiModelProperty(value = "工作流执行角色")
    private String workflowRole;

    @Setter
    @ApiModelProperty(value = "工作流实例ID")
    private String processInstanceId;

    @ApiModelProperty(value = "工作流key")
    private String processKey;

    @ApiModelProperty(value = "申请单二维码")
    private String applicationQrcode;

    @ApiModelProperty(value = "状态")
    private String status;
    @ApiModelProperty(value = "状态名称")
    private String statusName;

    @ApiModelProperty(value = "备注(无用预留)")
    private String remark;

    @ApiModelProperty(value = "备注2(预留)")
    private String remark2;

    @ApiModelProperty(value = "业务类型（与菜单对应拆表使用）")
    private String bizType;

    @ApiModelProperty(value = "操作类型 0 新增 2 编辑 1 暂存")
    private String operationType;

    @ApiModelProperty(value = "操作类型 0 新增 2 编辑 1 暂存")
    private String workflowNode;

    @ApiModelProperty(value = "内部人员代码")
    private String innerPersonCode;

    @ApiModelProperty(value = "操作类型 0 新增 2 编辑 1 暂存")
    private List<Map<String, Object>> equip;

    @ApiModelProperty("检验结果方式")
    private String resultType;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecuteIds;

    @ApiModelProperty(value = "发起人id用于撤回操作")
    private String promoter;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "下一步任务id")
    private String nextTaskId;

    @ApiModelProperty(value = "下一步执行人Ids")
    private String nextExecuteUserIds;

    @ApiModelProperty(value = "下一步任务名称")
    private String nextTaskName;

    @ApiModelProperty(value = "设备种类编码")
    private String equList;


    @ApiModelProperty(value = "设备种类名称")
    private String equListName;


    @ApiModelProperty(value = "设备类别code")
    private String equCategory;

    /**
     * 设备品种code
     */
    @TableField("equ_define")
    private String equDefine;

    @ApiModelProperty(value = "监管码")
    private String supervisoryCode;


    @ApiModelProperty(value = "对接单位code")
    private String dockingUnitCode;


    private String instanceId;

    @ApiModelProperty(value = "是否已经进行计划排期")
    private Boolean isExistPlanData;

    @ApiModelProperty(value = "计划下发日期,统计办理时效使用，来源JyjcInspectionApplication.planCreateDate")
    private Date planCreateDate;

    @ApiModelProperty(value = "地市")
    private String city;

    @ApiModelProperty(value = "区县")
    private String county;

    @ApiModelProperty(value = "计划检验日期")
    private LocalDate planInspectionDate;

    @ApiModelProperty(value = "登录人公司code")
    private String loginPersonCompanyCode;

    /**
     * 是否必须处理： true-必须处理，false-可不予受理
     */
    private Boolean isMustAccept;

    @ApiModelProperty(value = "装置id")
    private String projectContraptionId;

    @ApiModelProperty(value = "设备分类，大型游乐设施使用")
    private String equipTag1;

    @ApiModelProperty(value = "设备的使用单位,报检监督检验规则使用")
    private String useUnitCreditCode;

    public String getProcessInstanceId() {
        return this.instanceId != null ? this.instanceId : this.processInstanceId;
    }

}
