package com.yeejoin.precontrol.common.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.TaskRiskControlDto;
import com.yeejoin.precontrol.common.entity.TaskRiskControl;
import com.yeejoin.precontrol.common.entity.publics.CommonPageable;
import com.yeejoin.precontrol.common.vo.*;

/**
 * 风险管控任务表 服务类
 *
 * @author duanwei
 * @date 2021-01-28
 */
public interface ITaskRiskControlService extends IService<TaskRiskControl> {
	
	TaskRiskControlVo save(TaskRiskControlVo taskRiskControlVo);

	TaskRiskControlVo createTask(TaskRiskControlVo taskRiskControlVo);

	TaskRiskControlVo createTaskByFbs(TaskRiskControlVo taskRiskControlVo);
	
	TaskRiskControlVo create(TaskRiskControlVo taskRiskControlVo);

	TaskRiskControlVo nextStage(TaskRiskControlVo taskRiskControlVo);

	TaskRiskControlVo previousStage(TaskRiskControlVo taskRiskControlVo);
	
	TaskRiskControlVo doKnowledge(TaskRiskControlVo taskRiskControlVo);

	TaskRiskControlVo doExam(TaskRiskControlVo taskRiskControlVo, Boolean qualified);

	TaskRiskControlVo doCheck(TaskRiskControlVo taskRiskControlVo);
	
	TaskRiskControlVo reCreate(TaskRiskControlVo taskRiskControlVo);
	
	TaskRiskControlVo reCreateBySec(TaskRiskControlVo taskRiskControlVo);
	
	boolean cancel(TaskRiskControlVo taskRiskControlVo);

	TaskRiskControlVo read(TaskRiskControlVo taskRiskControlVo);

	/**
	 * 风险计划任务分页列表
	 *
	 * @param pageNum            当前页
	 * @param pageSize           页大小
	 * @param taskRiskControlDto 查询参数
	 * @return
	 */
	IPage<TaskRiskControlVo> listByPage(Integer pageNum, Integer pageSize, TaskRiskControlDto taskRiskControlDto);

	/**
	 * 根据id查询详情
	 *
	 * @param id
	 * @return
	 */
	TaskRiskControlVo getDetailById(Long id);

	/**
	 * 查询开始日期年
	 *
	 *
	 * @param orgCode 数据权限
	 * @param level   等级
	 * @return List<String>
	 */
	List<String> listYear(String orgCode, String level);

	/**
	 * 按照年查询数据
	 *
	 * @param pageable  分页
	 * @param level     等级
	 * @param name      名称
	 * @param status    状态
	 * @param beginDate 开始日期
	 * @param endDate   结束日期
	 * @param orgCode   机构
	 * @return Page<TaskRiskControlAppVo>
	 */
	Page<TaskRiskControlAppVo> listTaskByYearPage(CommonPageable pageable, Integer level, String name, String status,
			String beginDate, String endDate, String orgCode);

	/**
	 * 根据id查询小程序显示当前任务详情
	 *
	 * @param id
	 * @return
	 */
	TaskRiskControlVo taskDetail(Long id, Long personId);

	/**
	 * 获取风险作业行为轨迹
	 *
	 * @param taskRiskControlId
	 * @param personId
	 * @return
	 */
	Map<String, Object> getRiskWorkTrajectory(Long taskRiskControlId, Long personId);

	/**
	 * 计划任务统计
	 * 
	 * @param param 查询参数
	 * @return Object
	 */
	Object statisticsByLevel(Map<String, Object> param);

	/**
	 * 根据当前人员id查询当前所关联计划
	 *
	 * @param id
	 * @return
	 */
	Page<TaskRiskControlVo> myListByPage(CommonPageableDto pageable, Long personId, TaskRiskControlDto taskRiskControlDto);

	/**
	 * 进出场
	 *
	 * @param operate      0：出场，1：进场
	 * @param taskPersonId 任务人员id
	 */
	void entryOrExitRiskRegion(Integer operate, Long taskPersonId, Long taskRiskControlId);

	/**
	 * 人员统计
	 * 
	 * @param taskRiskControlId id
	 * @return Object
	 */
	Object personStatistics(Long taskRiskControlId);

	/**
	 * 人员列表
	 * 
	 * @param taskRiskControlId id
	 * @param status            状态
	 * @return List<PersonVo>
	 */
	List<TaskWorkPersonVo> personListInTaskRisk(Long taskRiskControlId, Integer status);

	/**
	 * 批量删除
	 *
	 * @param idList
	 * @return
	 */
	String deleteByIds(List<String> idList);

	/**
	 * 根据配置获取数据
	 *
	 * @return
	 */
    List<TaskRiskControlVo> listByConfig(String orgCode);

	/**
	 * 消息通知--发送风险作业消息
	 *
	 * @param riskControlVo 风险作业
	 * @param personId 接收人员id
	 */
	void taskRiskNotice(TaskRiskControlVo riskControlVo, Long personId);

	TaskRiskControlDetailVo taskRiskDetail(Long id);

	List<TaskWorkPersonVo> riskPersonList(Long id, Long value);

	List<TaskRiskControlDetailVo> riskNeedProcessList(String orgCode, Long projectId);

	IPage<Object> riskWorkPageInfo(CommonPageableDto pageable, String orgCode, Integer status,TaskRiskControlVo taskRiskControlVo);

	IPage<Object> antiViolationPageInfo(CommonPageableDto pageable, String orgCode, Integer status, Long projectId);

	void nullFiledCheck(TaskRiskControl taskRiskControl);

}
