package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.annotations.TableFormat;
import com.yeejoin.precontrol.common.entity.HazardousWorkResult;
import com.yeejoin.precontrol.common.entity.TaskPerson;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @description: 三交三查
 * @author: duanwei
 * @date: 2020-07-17 15:48
 **/
@Data
public class SingTaskPayCheckVo {

    //人员类型 0主持人 1交底人 2施工负责人 3安全员 4记录人 5交底人员 6技术员 7工程人员 8施工人员 9违章人员 10分包商负责人 99 发布人
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long id;

    @ApiModelProperty(value = "所属项目id")
    @TableFormat(entityName = "rpm_project", fieldName = "name", operFieldName = "projectName")
    private Long projectId;
    private String projectName;

    @ApiModelProperty(value = "任务编号")
    private String taskNo;

    @ApiModelProperty(value = "发起人id")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "createPersonName")
    private Long createPersonId;
    @ApiModelProperty(value = "发起人名称")
    private String createPersonName;

    @ApiModelProperty(value = "这次任务，人员的权限类型")
    private Long taskPersonRoleType;

    @ApiModelProperty(value = "起止时间")
    private Date startTime;

    @ApiModelProperty(value = "任务状态")
    private String status;

    @ApiModelProperty(value = "任务状态名称")
    private String statusName;

    @ApiModelProperty(value = "天气")
    private String weather;

    @ApiModelProperty(value = "施工任务")
    private Long constructionTask;

    @ApiModelProperty(value = "技术要求")
    private Long technicalRequire;

    @ApiModelProperty(value = "安全环保措施")
    private Long environmentProtect;

    @ApiModelProperty(value = "是否风险作业")
    private Long riskOperation;

    @ApiModelProperty(value = "风险作业")
    private String riskType;
    @ApiModelProperty(value = "风险作业Id")
    private Long riskTypeId;

    @ApiModelProperty(value = "安全员")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "safetyOfficerName")
    private Long safetyOfficerId;
    private String safetyOfficerName;

    @ApiModelProperty(value = "技术员")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "technicianName")
    private Long technician;
    private String technicianName;

    @ApiModelProperty(value = "工程人员")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "engineeringStaffName")
    private Long engineeringStaff;
    private String engineeringStaffName;


    @ApiModelProperty(value = "施工人员")
    private List<Long> builderId;

    @ApiModelProperty(value = "着装")
    private Long dress;

    @ApiModelProperty(value = "三宝(安全帽、安全带、安全鞋)")
    private Long saftTreasure;

    @ApiModelProperty(value = "精神状态")
    private Long mentalState;

    @ApiModelProperty(value = "安全员数据")
    @ImagePrefix
    private TaskPersonAndImageInfo safetyOfficerObject;


    @ApiModelProperty(value = "项目部安全员数据")
    @ImagePrefix
    private TaskPersonAndImageInfo platformSafetyOfficerObject;

    @ApiModelProperty(value = "发起人数据")
    @ImagePrefix
    private TaskPersonAndImageInfo createPersonObject;


    @ApiModelProperty(value = "技术员照片数据")
    @ImagePrefix
    private List<TaskPersonAndImageInfo> technicianObject;

    @ApiModelProperty(value = "工程人员照片数据")
    @ImagePrefix
    private List<TaskPersonAndImageInfo> engineeringStaffObject;

    @ApiModelProperty(value = "施工人员照片数据")
    @ImagePrefix
    private List<TaskPersonAndImageInfo> builderObject;


    @ApiModelProperty(value = "作业票id")
    private Long workTicketId;
    @ApiModelProperty(value = "作业票名称")
    private String workTicketName;

    @ApiModelProperty(value = "图片")
    @ImagePrefix
    private List<String> filePath;

    @ApiModelProperty(value = "作业票图片")
    @ImagePrefix
    private List<String> workTicketFilePath;

    @ApiModelProperty(value = "安全员检查项")
    private List<HazardousWorkResult> hazardousWorkResultList;

    @ApiModelProperty(value = "平台安全员检查项")
    private List<HazardousWorkResult> platformHazardousWorkResultList;

    @ApiModelProperty(value = "附件")
    @ImagePrefix
    private List<String> attachment;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    @ApiModelProperty(value = "未完成任务的当前状态")
    private Long currentStatus;
    @ApiModelProperty(value = "风险作业确认状态")
    private Long riskStatus;
    @ApiModelProperty(value = "施工人员确认状态")
    private Long builderStatus;
    
    private TaskPerson taskPerson;
}

