package com.yeejoin.equipmanage.controller;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.dto.OrgMenuDto;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.feign.morphic.model.ResourceDTO;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.equipmanage.common.entity.SourceScene;
import com.yeejoin.equipmanage.common.entity.dto.BuildIsRiskDTO;
import com.yeejoin.equipmanage.common.entity.dto.BuildSearchDTO;
import com.yeejoin.equipmanage.common.entity.vo.EquiplistSpecificBySystemVO;
import com.yeejoin.equipmanage.common.entity.vo.PointTreeVo;
import com.yeejoin.equipmanage.common.vo.BuildingTreeAndEquipVO;
import com.yeejoin.equipmanage.common.vo.BuildingTreeVo;
import com.yeejoin.equipmanage.service.IBuilldService;
import com.yeejoin.equipmanage.service.IFormInstanceService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;

/**
 * @author ZeHua Li
 * @date 2020/11/12 15:49
 * @since v2.0
 */
@RestController
@Api(tags = "消防建筑")
@RequestMapping(value = "/building", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class BuildingController extends AbstractBaseController {

    @Autowired
    IBuilldService buildService;

    @Autowired
    IFormInstanceService formInstanceService;
    @Value("${window.vedioFormat}")
    String vedioFormat;
    /**
     * @param groupCode
     * @Description 根据groupCode查询allowOperation对应的操作菜单
     * @Return List<DictionarieValueModel>
     * @Date 2020/12/18 10:13
     */
    @GetMapping("/rightClickMenu")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据groupCode查询allowOperation对应的操作菜单", notes = "查询")
    public List<DictionarieValueModel> rightClickMenu(@RequestParam("groupCode") String groupCode) {
        return buildService.rightClickMenu(groupCode);
    }

    @PostMapping(value = "/sceneCreate")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "创建画布")
    public Map<String, String> createMorphic(@RequestBody Map<String, String> map) {
        return buildService.createMorphic(map);
    }

    @PutMapping(value = "/sceneSave")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "更新保存画布")
    public ResourceDTO updateMorphic(@RequestBody ResourceDTO resourceDTO) {
        return buildService.updateMorphic(resourceDTO);
    }

    /**
     * 删除画布
     *
     * @return
     */
    @DeleteMapping(value = "/isDeleteCanvas")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "删除画布")
    public Boolean isDeleteCanvas(@RequestBody Long id) {
        return buildService.isDeleteCanvas(id);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("建筑分页列表")
    @GetMapping(value = "/page")
    public Page buildingList(Page page, BuildSearchDTO dto) {
        return buildService.buildingList(page, dto);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防建筑树")
    @GetMapping(value = "/tree")
    public List<BuildingTreeVo> getBuildingTree() {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
        return buildService.getBuildingTree(bizOrgCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防建筑树带筛选")
    @GetMapping(value = "/treeByName")
    public List<BuildingTreeVo> treeByName(@RequestParam(required = false) String name) {
        ReginParams reginParams = getSelectedOrgInfo();
        if (ObjectUtils.isEmpty(reginParams) || ObjectUtils.isEmpty(reginParams.getPersonIdentity()) || StringUtils.isEmpty(reginParams.getPersonIdentity().getBizOrgCode())) {
            return new ArrayList<>();
        }
        String bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
        return buildService.treeByName(bizOrgCode, name);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防建筑树列表信息")
    @GetMapping(value = "/getBuildingList")
    public  List<Map<String, Object>>  getBuildingTreeList() {
        return buildService.getBuildingDetaiList();
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防建筑层级树")
    @GetMapping(value = "/tierTree")
    public List<BuildingTreeVo> getBuildingTierTree(@RequestParam(required = false) Integer tier) {
        return buildService.getBuildingTierTree(tier);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防建筑树")
    @GetMapping(value = "/BuildingtreeAndEquip")
    public List<BuildingTreeAndEquipVO> gettreeAndEquip() {
        return buildService.gettreeAndEquip();
    }

    @GetMapping(value = "/scenesList")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据类型，instanceId获取画布list")
    public List<SourceScene> getScenesList(@RequestParam Long instanceId, @RequestParam String groupType) {
        return buildService.getScenesList(instanceId, groupType);
    }

    @GetMapping(value = "/{floorId}/pointInFloor")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询指定楼层下装备、摄像头")
    public List<EquiplistSpecificBySystemVO> getPointInFloor(@PathVariable Long floorId) {
        return buildService.getPointInFloor(floorId);
    }

    @PostMapping(value = "/commonSave")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "通用保存")
    public Object save(
            @RequestParam(value = "groupCode") String groupCode,
            @RequestParam(value = "instanceId", required = false) String instanceId,
            @RequestBody Map<String, Object> map) {
        String orgCode = getOrgCode();
        return buildService.saveForm(groupCode, orgCode, map, instanceId);
    }

    @GetMapping(value = "/pointTree")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "建筑装备树", notes = "楼层点位图使用")
    public Object getBuildTree(@RequestParam(required = false) String bizOrgCode,@RequestParam(required = false) String instanceId) {

        return buildService.getBuildTree(bizOrgCode,instanceId);
    }

    @GetMapping(value = "/buuildTree")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "按需加载建筑装备树", notes = "楼层点位图使用")
    public Object getBuildTreeNew(@RequestParam(required = false) String bizOrgCode,@RequestParam(required = false) String instanceId,@RequestParam(required = false) String displayName) {
        return buildService.getEquipTree(bizOrgCode,instanceId,displayName);
    }

    @GetMapping(value = "/equipTree")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "按需加载建筑装备树", notes = "楼层点位图使用")
    public Object getEquipTreeNew(@RequestParam(required = false) String bizOrgCode,@RequestParam(required = false) String instanceId) {
        return buildService.getBuildTreeNew(bizOrgCode,instanceId);
    }


    @GetMapping(value = "/pointTreeNotEqu")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "建筑装备树", notes = "楼层点位")
    public Object pointTreeNotEqu(@RequestParam(required = false) String bizOrgCode) {
        if(vedioFormat.equals("hls")){
            bizOrgCode=null;
        }
        return buildService.getBuildTreeNot(bizOrgCode);
    }

    @GetMapping(value = "/3dPointTree")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "建筑装备树", notes = "三维使用")
    public List<PointTreeVo> get3dBuildTree() {
        return buildService.get3dBuildTree();
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "通用更新")
    @PutMapping(value = "/commonUpdate")
    public Object update(
            @RequestParam Long instanceId,
            @RequestParam(value = "groupCode", required = false) String groupCode,
            @RequestBody Map<String, Object> map) {
        String orgCode = getOrgCode();
        return buildService.updateForm(instanceId, orgCode, map, groupCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询详情")
    @GetMapping(value = "/getOne")
    public Map<String, Object> getOne(@RequestParam Long instanceId) {
        return buildService.buildingDetail(instanceId);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除")
    @DeleteMapping(value = "/{instanceId}")
    public Boolean delete(@PathVariable Long instanceId) {
        return buildService.deleteBuilding(instanceId);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询树节点对应的操作")
    @GetMapping(value = "/allPermission")
    public Map<String, Object> getAllPermission() {
        return buildService.getAllPermission();
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据instanceId、groupType，获取建筑楼层list")
    @GetMapping(value = "/getBuildFloorList")
    public List<BuildSearchDTO> getBuildFloorList(BuildSearchDTO dto) {
        return formInstanceService.getBuildFloorList(dto);
    }

    /**
     * 获取权限公司树
     *
     * @return list
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据登陆人获取公司树", notes = "根据登陆人获取公司树")
    @GetMapping(value = "/companyTreeByUserAndType")
    public List<OrgMenuDto> companyTreeByUserAndType() {
        return buildService.companyTreeByUserAndType();
    }

    /**
     * 根据instanceId，获取建筑楼层信息
     *
     * @param instanceId
     * @param fileCategory 文件分类
     * @param isDetail     是否详情：1是，0否
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据instanceId，获取建筑楼层信息")
    @GetMapping(value = "/findByInstanceId")
    public List<LinkedHashMap<String, Object>> findByInstanceId(@RequestParam Long instanceId, @RequestParam(required = false) String fileCategory, @RequestParam Boolean isDetail) {
        return formInstanceService.findByInstanceId(instanceId, fileCategory, isDetail);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据instanceId，获取实例信息")
    @GetMapping(value = "/getFormInstanceById")
    public Map<String, Object>  getFormInstanceById(@RequestParam Long instanceId) {
        return formInstanceService.getFormInstanceById(instanceId);
    }

    @GetMapping(value = "/getEveryCount")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询建筑画布下装备")
    public Map<String, Object> getEveryCount(@RequestParam Long id, @RequestParam String groupType, @RequestParam(required = false) String bizOrgCode) {
        return buildService.getEveryCount(id, groupType, bizOrgCode);
    }

    @GetMapping(value = "/getChildrenNotIsRiskList")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询未设置风险区域的子风险区域列表")
    public List<BuildIsRiskDTO> getChildrenNotIsRiskList(@RequestParam String instanceId) {
        return buildService.getChildrenNotIsRiskList(instanceId);
    }

    @PutMapping(value = "unbind/region")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "解除区域与建筑绑定关系")
    public void unbindRelation(@RequestParam Long instanceId) {
        buildService.unbindRelation(instanceId);
    }


    @GetMapping(value = "/getBuildDetaliByFloorId")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询建筑详细信息")
    public Map<String, Object> getBuildDetaliByFloorId(@RequestParam String instanceId) {
        return buildService.getBuildDetaliByFloorId(instanceId);
    }

    @GetMapping(value = "/getBuildingAbsolutePosition")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询建筑位置全路径")
    public Map<Long, String> getBuildDetaliByFloorId() {
        return buildService.getBuildingAbsolutePosition();
    }

    @GetMapping(value = "/getBuildingCodeKeyMap")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询所有建筑的code与id对应关系")
    public Map<String, Long> getBuildingCodeKey() {
        return buildService.getBuildingCodeKey();
    }

    @PostMapping(value = "/getStorageTankCode")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据所属单位Id生成储罐编号")
    public Map<String, String> getStorageTankCode(@RequestParam String belongUnitId, @RequestParam String groupCode) {
        return buildService.getStorageTankCodeByBelongUnitId(belongUnitId,groupCode);
    }

    // 需求958 导出模板需要列表获取建筑 by kongfm 2021-09-15
    @GetMapping(value = "/getAllBuilding")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询所有建筑用于数据字典")
    public List<LinkedHashMap<String, Object>> getAllBuilding() {
        return buildService.getAllBuilding();
    }


    @GetMapping(value = "/getBuildingToLongitudeAndLatitude")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询指定建筑的经纬度信息")
    public Map<String, String> getBuildingToLongitudeAndLatitude(@RequestParam String instanceId){
    	return buildService.getBuildingToLongitudeAndLatitude(instanceId);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("公司消防建筑树")
    @GetMapping(value = "/companyBuildingTree")
    public List<BuildingTreeVo> getCompanyBuildingTree(@RequestParam(required = false, value = "type")String type) {
        return buildService.getCompanyBuildingTree(null, type);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("单位树")
    @GetMapping(value = "/selectCompanyTree")
    public List<BuildingTreeVo> selectCompanyTree(@RequestParam(value = "authKey", required = false) String authKey ) {
        return buildService.selectCompanyTree(authKey);
    }

    @ApiOperation(value = "查询指定单位的建筑树")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{bizOrgCode}/tree")
    public List<BuildingTreeVo> buildingTree(
            @ApiParam(value = "单位编码") @PathVariable String bizOrgCode){
        return buildService.getBuildingTreeInOrgCode(bizOrgCode);
    }

    @ApiOperation(value = "查询指定单位的建筑树")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{bizOrgCode}/treeNew")
    public List<BuildingTreeVo> buildingTreeNew(
            @ApiParam(value = "单位编码") @PathVariable String bizOrgCode){
        return buildService.getBuildingTreeInMyOrgCode(bizOrgCode);
    }


    @ApiOperation(value = "查询指定单位的建筑树")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/myTree")
    public List<BuildingTreeVo> buildingTreeByMyCompany(){
        ReginParams reginParams = getSelectedOrgInfo();

        return buildService.getBuildingTreeInMyOrgCode(reginParams.getPersonIdentity().getBizOrgCode());
    }

    @ApiOperation(value = "查询指定单位的建筑树")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/myTreeList")
    public List<BuildingTreeVo> buildingTreeByMyCompanyToList(){
        ReginParams reginParams = getSelectedOrgInfo();

        return buildService.getBuildingTreeInMyOrgCodeList(reginParams.getPersonIdentity().getBizOrgCode());
    }

}
