package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.PersonCertificateServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.PersonCertificateDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 人员资质
 *
 * @author system_generator
 * @date 2023-04-20
 */
@RestController
@Api(tags = "人员资质Api")
@RequestMapping(value = "/person-certificate")
public class PersonCertificateController extends BaseController {

    @Autowired
    PersonCertificateServiceImpl personCertificateServiceImpl;

    /**
     * 新增人员资质
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增人员资质", notes = "新增人员资质")
	public ResponseModel<PersonCertificateDto> save(@RequestBody PersonCertificateDto model) {
	    model = personCertificateServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新人员资质", notes = "根据sequenceNbr更新人员资质")
	public ResponseModel<PersonCertificateDto> updateBySequenceNbrPersonCertificate(@RequestBody PersonCertificateDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(personCertificateServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除人员资质", notes = "根据sequenceNbr删除人员资质")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(personCertificateServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个人员资质",  notes = "根据sequenceNbr查询单个人员资质")
	public ResponseModel<PersonCertificateDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(personCertificateServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "人员资质分页查询",  notes = "人员资质分页查询")
	public ResponseModel<Page<PersonCertificateDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<PersonCertificateDto> page = new Page<PersonCertificateDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(personCertificateServiceImpl.queryForPersonCertificatePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "人员资质列表全部数据查询",   notes = "人员资质列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<PersonCertificateDto>> selectForList() {
	    return ResponseHelper.buildResponse(personCertificateServiceImpl.queryForPersonCertificateList());
	}
}
