package com.yeejoin.amos.boot.module.jg.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 更名变更登记
 *
 * @author system_generator
 * @date 2023-12-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgChangeRegistrationNameDto", description = "更名变更登记")
public class JgChangeRegistrationNameDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "申请日期")
    private Date applyDate;

    @ApiModelProperty(value = "办理状态")
    private String auditStatus;

    @ApiModelProperty(value = "登记机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "登记机构代码")
    private String receiveOrgCode;

    @ApiModelProperty(value = "登记机构公司代码")
    private String receiveCompanyCode;

    @ApiModelProperty(value = "终审通过时间")
    private Date auditPassDate;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date createDate;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "原使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "新使用单位名称")
    private String newUseUnitName;

    @ApiModelProperty(value = "证照图片（更名后证照）")
    private String changeCertificate;

    @ApiModelProperty(value = "证照图片（更名后证照）集合")
    private List<Map<String, Object>> changeCertificateList;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "流程执行顺序标识")
    private String executeSequence;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecutorIds;

    @ApiModelProperty(value = "任务发起人id")
    private String promoter;

    /**
     * 流程状态
     */
    @TableField("instance_status")
    private String instanceStatus;

    private List<String> roleIds;


    // 区分监管和企业
    private String type;


    /**
     * 下一步任务id
     */
    private String nextTaskId;


}
