package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aspose.words.SaveFormat;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.IDataDictionaryService;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgChangeRegistrationTransferService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgMaintainNoticeService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgTransferNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.biz.utils.FileExporter;
import com.yeejoin.amos.boot.module.jg.biz.utils.ImageUtils;
import com.yeejoin.amos.boot.module.jg.biz.utils.JsonUtils;
import com.yeejoin.amos.boot.module.jg.biz.utils.WordTemplateUtils;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.PrivilegeFeginService;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActTaskDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import javax.servlet.http.HttpServletResponse;
import java.awt.print.Book;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 装备分类服务实现类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@Service
@Slf4j
public class CommonServiceImpl implements ICommonService {

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    CommonMapper commonMapper;

    @Autowired
    IDataDictionaryService iDataDictionaryService;


    @Value("classpath:/json/superviseBusinessCategory.json")
    private Resource superviseBusinessCategory;


    @Value("classpath:/json/urlInfo.json")
    private Resource urlInfo;
    //行政区划redis缓存key
    private static final String PROVINCE = "PROVINCE";
    private static final String CITY = "CITY";
    private static final String REGION = "REGION";
    private static final String STREET = "STREET";
    //行政区划level
    private static final String PROVINCE_LEVEL = "1";
    private static final String CITY_LEVEL = "2";
    private static final String REGION_LEVEL = "3";
    private static final String STREET_LEVEL = "4";

    //判断行政区划查询市还是区
    private static final String END_CODE = "0000";
    //判断行政区划查询街道
    private static final String STREET_END_CODE = "00";

    //管辖机构redis缓存key
    private static final String REGULATOR_UNIT_TREE = "REGULATOR_UNIT_TREE";

    //行政审批局redis缓存key
    private static final String ADMINISTRATION_UNIT_TREE = "ADMINISTRATION_UNIT_TREE";

    @Value("${regulator.unit.code}")
    private String code;

    @Autowired
    PrivilegeFeginService privilegeFeginService;

    // 业务通用发起——基本信息
    private static final String basic = "basic";
    // 业务通用发起——告知单详情
    private static final String notice = "notice";
    // 业务通用发起——安装告知表单key
    private static final String AZGZ_FORM_ID = "1734141426742095873";
    // 业务通用发起——移装变更表单key
    private static final String YZBG_PAGE_ID = "changeRegistrationTransfer";
    // 业务通用发起——改造告知表单key
    private static final String GZGZ_PAGE_ID = "reformNoticeAdd";
    // 业务通用发起——维修告知表单key
    private static final String WXGZ_PAGE_ID = "maintainInfo";
    // 业务通用发起——移装告知表单key
    private static final String YZGZ_PAGE_ID = "transferNoticeAdd";
    // 业务通用发起——单位变更表单key
    private static final String DWBG_PAGE_ID = "changeRegisInfo";
    // 业务通用发起——设备注销表单key
    private static final String SBZX_PAGE_ID = "jgScrapCancelAdd";
    // 业务通用发起——更名变更表单key
    private static final String GMBG_PAGE_ID = "jgRegistrationInfo";

    @Autowired
    private IJgInstallationNoticeService iJgInstallationNoticeService;

    @Autowired
    JgMaintenanceContractServiceImpl jgMaintenanceContractServiceImpl;

    @Autowired
    JgUseRegistrationServiceImpl jgUseRegistrationServiceImpl;

    @Autowired
    JgEquipTransferServiceImpl jgEquipTransferServiceImpl;

    @Autowired
    JgReformNoticeServiceImpl jgReformNoticeService;

    @Autowired
    private IJgMaintainNoticeService iJgMaintainNoticeService;
    @Autowired
    private IJgTransferNoticeService jgTransferNoticeService;

    @Autowired
    JgChangeRegistrationReformServiceImpl jgChangeRegistrationReformServiceImpl;

    @Autowired
    IJgChangeRegistrationTransferService jgChangeRegistrationTransferService;

    @Autowired
    JgChangeRegistrationUnitServiceImpl jgChangeRegistrationUnitServiceImpl;

    @Autowired
    JgChangeRegistrationNameServiceImpl jgChangeRegistrationNameService;

    @Autowired
    JgEnableDisableServiceImpl jgEnableDisableServiceImpl;

    @Autowired
    JgScrapCancelServiceImpl jgScrapCancelService;

    public static byte[] file2byte(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            //当文件没有结束时，每次读取一个字节显示
            byte[] data = new byte[in.available()];
            in.read(data);
            in.close();
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<EquipmentCategory> getEquipmentCategoryList(String code, String type) {
        List<EquipmentCategory> result = new ArrayList<>();

        LambdaQueryWrapper<EquipmentCategory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(EquipmentCategory::getCode, code);
        EquipmentCategory equipmentCategory = equipmentCategoryMapper.selectOne(wrapper);
        if (ObjectUtils.isEmpty(type)) {
            if (!ValidationUtil.isEmpty(equipmentCategory)) {
                result.add(equipmentCategory);
            }
        } else {
            LambdaQueryWrapper<EquipmentCategory> wrapper2 = new LambdaQueryWrapper<>();
            wrapper2.eq(EquipmentCategory::getParentId, equipmentCategory.getId());
            List<EquipmentCategory> equipmentCategories = equipmentCategoryMapper.selectList(wrapper2);
            if (!ValidationUtil.isEmpty(equipmentCategories)) {
                result = equipmentCategories;
            }
        }
        return result;
    }

    @Override
    public List<LinkedHashMap> getRegion(String level, String parentId) {
        List<LinkedHashMap> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(level)) {
            list = (List<LinkedHashMap>) redisUtils.get(PROVINCE);
            return ObjectUtils.isEmpty(list) ? getProvinceList(level) : list;
        } else if (!ObjectUtils.isEmpty(parentId)) {
            String regionCode = parentId.split("_")[0];
            //regionCode不是以00结尾查询街道，以0000结果查询市、否则查询区
            if (!regionCode.endsWith(STREET_END_CODE)) {
                list = ObjectUtils.isEmpty(redisUtils.get(STREET)) ? getProvinceList(STREET_LEVEL) : (List<LinkedHashMap>) redisUtils.get(STREET);
            } else if (regionCode.endsWith(END_CODE)) {
                list = ObjectUtils.isEmpty(redisUtils.get(CITY)) ? getProvinceList(CITY_LEVEL) : (List<LinkedHashMap>) redisUtils.get(CITY);
            } else {
                list = ObjectUtils.isEmpty(redisUtils.get(REGION)) ? getProvinceList(REGION_LEVEL) : (List<LinkedHashMap>) redisUtils.get(REGION);
            }
            return list.stream().filter(r -> regionCode.equals(r.get("parentRegionCode").toString())).collect(Collectors.toList());
        } else {
            return new ArrayList<>();
        }
    }


    public List<LinkedHashMap> getProvinceList(String level) {
        FeignClientResult result = privilegeFeginService.getProvince(level);
        List<LinkedHashMap> list = (List<LinkedHashMap>) result.getResult();
        for (LinkedHashMap linkedHashMap : list) {
            linkedHashMap.put("sequenceNbr", linkedHashMap.get("regionCode"));
        }
        switch (level) {
            case PROVINCE_LEVEL:
                redisUtils.set(PROVINCE, list);
                break;
            case CITY_LEVEL:
                redisUtils.set(CITY, list);
                break;
            case REGION_LEVEL:
                redisUtils.set(REGION, list);
                break;
            case STREET_LEVEL:
                redisUtils.set(STREET, list);
                break;
            default:
                log.error("不支持的行政区划：{}", level);
                break;
        }
        return list;
    }


    @Override
    public List<LinkedHashMap> getTree() {
        List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
        //判断redis是否存在管辖机构树
        return !ObjectUtils.isEmpty(result) ? result : creatTree();
    }

    @Override
    public List<LinkedHashMap> creatTree() {
        FeignClientResult tree = privilegeFeginService.queryAgencyTreeForCache(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        List<LinkedHashMap> treeData = deleteRegulatorTreeData(result);
        List<LinkedHashMap> supervisionTree = treeData.stream().filter(e -> code.equals(e.get("orgCode"))).collect(Collectors.toList());
        List<LinkedHashMap> resultTree = updateNullChildren(supervisionTree);
        redisUtils.set(REGULATOR_UNIT_TREE, resultTree);
        return resultTree;
    }

    @Override
    public List<LinkedHashMap> getApproveTree() {
        List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(ADMINISTRATION_UNIT_TREE);
        //判断redis是否存在行政审批局树
        return !ObjectUtils.isEmpty(result) ? result : creatApproveTree();
    }


    @Override
    public List<LinkedHashMap> creatApproveTree() {
        FeignClientResult tree = privilegeFeginService.queryAgencyTreeForCache(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        List<LinkedHashMap> children = (List<LinkedHashMap>) result.get(0).get("children");
        List<LinkedHashMap> treeData = deleteTreeData(children);
        List<LinkedHashMap> resultTree = updateNullChildren(treeData);
        redisUtils.set(ADMINISTRATION_UNIT_TREE, resultTree);
        return resultTree;
    }

    @Override
    public List<Map<String, Object>> superviseBusinessCategory(String type) {
        Map<String, List<Map<String, Object>>> resourceJson = JsonUtils.getResourceJson(superviseBusinessCategory);
        return resourceJson.get(type);
    }

    private List<LinkedHashMap> deleteTreeData(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            // 删除非行政审批局
            if (!e.get("companyType").toString().contains("行政审批局")) {
                it.remove();
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                deleteTreeData((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }


    @Override
    public List<Map<String, Object>> getUnitListByType(String type) {

        if (type.equals("use")) {
            type = "使用单位";
        } else if (type.equals("maintenance")) {
            type = "安装改造维修单位";
        } else if (type.equals("inspection")) {
            type = "检验检测机构";
        }
        return commonMapper.getUnitListByType(type);
    }

    @Override
    public List<Map<String, Object>> getSecurityAdmin(String type, String companyCode) {
        if (ObjectUtils.isEmpty(companyCode)) {
            ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            CompanyBo company = reginParams.getCompany();
            companyCode = company.getCompanyCode();
        }
        String postName = null;
        if (type.equals("use")) {
            postName = "安全管理员";
        }
        if (type.equals("jyjc")) {
            postName = "检验检测人员";
        }
        if (type.equals("agw")) {
            postName = "安改维负责人";
        }
        if (type.equals("wbry")) {
            postName = "维保人员";
        }
        return ObjectUtils.isEmpty(postName) ? new ArrayList<>() : commonMapper.getSecurityAdmin(companyCode, postName);
    }

    @Override
    public Map<String, Object> getUserInfo(String sequenceNbr) {
        return commonMapper.getUserInfo(sequenceNbr.split("_")[0]);
    }

    @Override
    public Map<String, Object> getEnterpriseInfo(String sequenceNbr) {
        return commonMapper.getEnterpriseInfo(sequenceNbr);
    }

    @Override
    public List<Map<String, Object>> getEnterpriseEmployee(String unitCode) {
        return commonMapper.getEnterpriseEmployee(unitCode);
    }

    /**
     * 将管辖机构树中children为[]的修改为null
     *
     * @param result
     * @return
     */
    private List<LinkedHashMap> updateNullChildren(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            //将管辖机构树中children为[]的修改为null
            if (e.get("children") != null) {
                if (((List<LinkedHashMap>) e.get("children")).size() == 0) {
                    e.put("children", null);
                }
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                updateNullChildren((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }

    /**
     * 删除管辖机构树中level为使用单位的数据
     *
     * @param result 管辖机构树
     * @return 筛选过滤后不包含使用单位的管辖机构树
     */
    private List<LinkedHashMap> deleteRegulatorTreeData(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            //删除使用单位
            if ("company".equals(e.get("level"))) {
                it.remove();
            }
            if (e.get("companyName").toString().contains("行政审批局")) {
                it.remove();
            }
            // 删除检验检测机构
            if (!"company".equals(e.get("level")) && e.get("companyType").toString().contains("检验检测机构")) {
                it.remove();
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                deleteRegulatorTreeData((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }

    @Override
    public void generateCertificateReport(Map<String, Object> map, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        // 组装模板变量
        map.put("useRegistrationCode", Optional.ofNullable(map.get("useRegistrationCode")).orElse("").toString()); // 编号
        map.put("useUnitName", Optional.ofNullable(map.get("useUnitName")).orElse("").toString());  // 使用单位名称
        map.put("fullAddress", Optional.ofNullable(map.get("fullAddress")).orElse("").toString());  // 设备使用地点
        map.put("equList", Optional.ofNullable(map.get("equList")).orElse("").toString());  // 设备种类
        map.put("equipDefine", Optional.ofNullable(map.get("equipDefine")).orElse("").toString());  // 设备品种
        map.put("equipCode", Optional.ofNullable(map.get("equipCode")).orElse("").toString());  // 设备代码
        map.put("equipCategory", Optional.ofNullable(map.get("equipCategory")).orElse("").toString());  // 设备类别
        map.put("useInnerCode", Optional.ofNullable(map.get("useInnerCode")).orElse("").toString());  // 单位内编号
        map.put("factoryNum", Optional.ofNullable(map.get("factoryNum")).orElse("").toString());  // 产品编号
        map.put("receiveOrgName", Optional.ofNullable(map.get("receiveOrgName")).orElse("").toString());  // 登记机关
        map.put("giveOutYear", Optional.ofNullable(map.get("giveOutYear")).orElse("").toString());  // 发证日期-年
        map.put("giveOutMonth", Optional.ofNullable(map.get("giveOutMonth")).orElse("").toString());  // 发证日期-月
        map.put("giveOutDay", Optional.ofNullable(map.get("giveOutDay")).orElse("").toString());  // 发证日期-日
        // 生成二维码
        String qrCode = ImageUtils.generateQRCode(Optional.ofNullable(map.get("supervisoryCode")).orElse("").toString(), 100, 100);
        map.put("supervisoryCode", qrCode);  // 监管二维码

        // word转pdf
        File pdfFile;
        try {
            pdfFile = this.wordToPdf("equipment-registration-certificate-report.ftl", map);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

//        // 上传pdf至文件服务器
//        String url = this.uploadFile(pdfFile);

        // 删除临时文件
//        try {
//            Files.deleteIfExists(pdfFile.toPath());
//        } catch (IOException e) {
//            log.error("删除临时文件失败：{}", e);
//        }

        try {
            byte[] bytes = file2byte(pdfFile);
            String docTitle = pdfFile.getName();
            FileExporter.exportFile(FileExporter.FileType.valueOf("pdf"), docTitle, bytes, response);
        } catch (Exception e) {
            log.error("pdf文件转换失败：{}", e);
        } finally {
            try {
                Files.deleteIfExists(pdfFile.toPath());
            } catch (Exception e) {
                log.error("文件找不到，删除失败：{}", e);
            }
        }
    }


    /**
     * word 转 pdf
     *
     * @param wordPath word文件路径
     */
    private File wordToPdf(String wordPath, Map<String, Object> placeholders) throws Exception {
        Assert.hasText(wordPath, "word文件路径不能为空");

        String tempFileName = "特种设备使用登记证_" + System.currentTimeMillis() + "_temp.pdf";

        WordTemplateUtils instance = WordTemplateUtils.getInstance();

        return instance.fillAndConvertDocFile(wordPath, tempFileName, placeholders, SaveFormat.PDF);
    }

    /**
     * 上传文件至文件服务器
     *
     * @param file 文件
     */
    private String uploadFile(File file) {
        Assert.notNull(file, "文件不能为空");

        MultipartFile multipartFile = new ByteArrayMultipartFile("file", "file.pdf", "application/pdf", file2byte(file));
        FeignClientResult<Map<String, String>> result = Systemctl.fileStorageClient.updateCommonFile(multipartFile);
        String urlString = "";
        if (result != null) {
            for (String s : result.getResult().keySet()) {
                urlString = s;
            }
        }
        return urlString;
    }


    @Override
    public void invokeBusinessProcess(String submitType, Map<String, Object> map, ReginParams reginParams) {
        Map<String, Object> basicObj = (Map<String, Object>) map.get(basic);
        Map<String, Object> noticeObj = (Map<String, Object>) map.get(notice);
        Map<String, Object> provideMap = new HashMap<>();

        String type = (String) basicObj.get("type");
        if (type.equals(ApplicationFormTypeEnum.AZGZ.getBusinessCode())) {

            JgInstallationNoticeDto jgInstallationNoticeDto = JSON.parseObject(JSON.toJSONString(noticeObj), JgInstallationNoticeDto.class);
            jgInstallationNoticeDto.setReceiveOrgCreditCode(!ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject1 = (JSONObject) JSONObject.toJSON(jgInstallationNoticeDto);
            provideMap.put(AZGZ_FORM_ID, jsonObject1);
            JSONObject jsonObject = new JSONObject(provideMap);
            iJgInstallationNoticeService.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.GZGZ.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(GZGZ_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            jgReformNoticeService.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.WXGZ.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(WXGZ_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            iJgMaintainNoticeService.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.YZGZ.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(YZGZ_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            jgTransferNoticeService.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.SYDJ.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            if (submitType.equals("1")) {
                jsonObject.put("submit", Boolean.TRUE);
            }
            jgUseRegistrationServiceImpl.save(jsonObject);
        } else if (type.equals(ApplicationFormTypeEnum.GZBG.getBusinessCode())) {
            //兼容业务逻辑代码
            if(submitType.equals("1")){
                noticeObj.put("submit","true");
            }
            noticeObj.put("receiveCompanyCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            jgChangeRegistrationReformServiceImpl.save(jsonObject);
        } else if (type.equals(ApplicationFormTypeEnum.YZBG.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(YZBG_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            jgChangeRegistrationTransferService.createTransfer(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.DWBG.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(DWBG_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            jgChangeRegistrationUnitServiceImpl.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.WBBA.getBusinessCode())) {
            noticeObj.put("pageType","add");
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            jgMaintenanceContractServiceImpl.saveOrSubmit(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.SBYJ.getBusinessCode())) {

            JgEquipTransferDto jgEquipTransferDto = JSON.parseObject(JSON.toJSONString(noticeObj), JgEquipTransferDto.class);
            JSONObject jsonObject = (JSONObject) JSONObject.toJSON(jgEquipTransferDto);
            jgEquipTransferServiceImpl.saveTransfer(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.SBZX.getBusinessCode())) {

            noticeObj.put("receiveOrgCreditCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(SBZX_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            jgScrapCancelService.save(submitType, jsonObject);
        } else if (type.equals(ApplicationFormTypeEnum.GMBG.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(GMBG_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            jgChangeRegistrationNameService.save2(submitType, jsonObject);
        } else if (type.equals(ApplicationFormTypeEnum.TYQY.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            jgEnableDisableServiceImpl.saveOrUpdate(jsonObject);
        }
    }


    public void deleteTaskModel(String id) {
        List<TaskV2Model> result = Systemctl.taskV2Client.selectListByRelationId(id).getResult();
        TaskV2Model model = result.stream().sorted((r1, r2) -> r2.getCreateDate().compareTo(r1.getCreateDate())) // 按时间降序排序
                .findFirst()
                .orElse(null);
        Systemctl.taskV2Client.delete(String.valueOf(model.getSequenceNbr()));

    }


    /**
     * 待办新增接口
     **/
    public void buildTaskModel(List<TaskModelDto> list) {
        list.forEach(obj -> {
            TaskV2Model model = new TaskV2Model();
            BeanUtil.copyProperties(obj, model);
            String urlParams = "";
            try {
                urlParams = "&" + toQueryParams(obj.getModel());
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            List<Map> urlList = JsonUtils.getResourceList(urlInfo);
            for (Map map : urlList) {
                if (map.get("type").equals(obj.getTaskType()) && map.get("pageType").equals("look")) {
                    model.setRoutePath(map.get("url").toString().replace("{roleIds}", obj.getNextExecuteUser()) + urlParams+"&executeUserIds="+model.getExecuteUserIds());
                    break;
                }
            }
            model.setTaskStatus(0);
            model.setFlowInstanceId(model.getRelationId());
            model.setTaskTitle(obj.getStartUser() + "发起了" + obj.getTaskName());
            model.setTaskSource("workFlow");
            model.setExtras(JSON.toJSONString(obj.getModel()));
            // model.setTerminal(params.getOrDefault("terminal","WEB").toString());
            model.setCreateDate(new Date());
            model.setRecUserId(RequestContext.getExeUserId());
            model.setAgencyCode(RequestContext.getAgencyCode());
            Systemctl.taskV2Client.create(model);
        });

    }


    /**
     * 待办编辑接口
     * 参数
     * taskStatus
     * taskStatusLabel 操作名称  1驳回 2通过 3重新提交
     * flowStatusLabel  任务状态枚举code
     * 流程实例id  instanceId
     * flowCode 任务id

     **/
    public TaskV2Model updateTaskModel(Map<String, Object> params) {
        String exeUserId = RequestContext.getExeUserId();
        List<TaskV2Model> result = Systemctl.taskV2Client.selectListByRelationId(params.get("relationId").toString()).getResult();

        // TaskV2Model model = result.stream().filter(e->e.getFlowCode().equals(params.get("flowCode").toString())).sorted((r1, r2) -> r2.getSequenceNbr().compareTo(r2.getSequenceNbr())) // 按时间降序排序
        //         .findFirst()
        //         .orElse(null);
        TaskV2Model model =  result.stream().sorted((r1, r2) -> r2.getSequenceNbr().compareTo(r1.getSequenceNbr())) // 按时间降序排序
                .findFirst()
                .orElse(null);
        if (model == null) {
            return null;
        }

        model.setFlowStatus(Integer.valueOf(params.get("flowStatus").toString()));
        model.setFlowStatusLabel(params.get("flowStatusLabel").toString());
        model.setTaskStatus(Integer.valueOf(params.get("taskStatus").toString()));
        model.setTaskStatusLabel(params.get("taskStatusLabel").toString());
        model.setEndUserId(exeUserId);
        model.setEndDate(new Date());

//        String[] roleIds = model.getRoutePath().split("roleIds=");
//        String[] userIds = roleIds[1].split("&userId");
//        String url = roleIds[0]+"roleIds="+"55555"+"&userId"+ userIds[1];
//        String tarUrl = url.replaceFirst("&executeUserIds=", "");
//        tarUrl+"&executeUserIds="

       // model.setRoutePath( roleIds[0]+"roleIds="+"55555"+"&userId"+userIds[1]);
        model.setRoutePath(model.getRoutePath().replace("roleIds=","roleIds=55555&fq="));
        Systemctl.taskV2Client.update(model, model.getSequenceNbr());
        //修改model并返回 用于组装新待办
        model.setEndUserId(null);
        model.setTaskStatus(null);
        model.setEndDate(null);
        model.setSequenceNbr(null);
        model.setCreateDate(new Date());
        model.setStartDate(new Date());
        return model;
    }

    /**
     * 待办编辑接口       【如果没有代办直接返回空，业务判断】   ---- 在用，误删
     * 参数
     * taskStatus
     * taskStatusLabel 操作名称  1驳回 2通过 3重新提交
     * flowStatusLabel  任务状态枚举code
     * 流程实例id  instanceId
     * flowCode 任务id

     **/
    public TaskV2Model updateTaskModelNew(Map<String, Object> params) {
        String exeUserId = RequestContext.getExeUserId();
        List<TaskV2Model> result = Systemctl.taskV2Client.selectListByRelationId(params.get("relationId").toString()).getResult();

        // TaskV2Model model = result.stream().filter(e->e.getFlowCode().equals(params.get("flowCode").toString())).sorted((r1, r2) -> r2.getSequenceNbr().compareTo(r2.getSequenceNbr())) // 按时间降序排序
        //         .findFirst()
        //         .orElse(null);
        TaskV2Model model =  result.stream().sorted((r1, r2) -> r2.getSequenceNbr().compareTo(r1.getSequenceNbr())) // 按时间降序排序
                .findFirst()
                .orElse(null);
        if (model != null) {
            model.setFlowStatus(Integer.valueOf(params.get("flowStatus").toString()));
            model.setFlowStatusLabel(params.get("flowStatusLabel").toString());
            model.setTaskStatus(Integer.valueOf(params.get("taskStatus").toString()));
            model.setTaskStatusLabel(params.get("taskStatusLabel").toString());
            model.setEndUserId(exeUserId);
            model.setEndDate(new Date());
            model.setRoutePath(model.getRoutePath().replace("roleIds=","roleIds=55555&fq="));
            Systemctl.taskV2Client.update(model, model.getSequenceNbr());
        } else {
            model = new TaskV2Model();
            model.setFlowStatus(Integer.valueOf(params.get("flowStatus").toString()));
            model.setFlowStatusLabel(params.get("flowStatusLabel").toString());
            model.setTaskStatus(Integer.valueOf(params.get("taskStatus").toString()));
            model.setTaskStatusLabel(params.get("taskStatusLabel").toString());
        }
        //修改model并返回 用于组装新待办
        model.setEndUserId(null);
        model.setTaskStatus(null);
        model.setEndDate(null);
        model.setSequenceNbr(null);
        model.setCreateDate(new Date());
        model.setStartDate(new Date());
        return model;
    }


    /**
     * 待办 撤回
     * @param id 工作流实例id
     * @param obj 自己的实体：taskType为BusinessTypeEnum code；nextExecuteUser
     */
    public void rollbackTask(String id, JSONObject obj) {
        List<TaskV2Model> result = Systemctl.taskV2Client.selectListByRelationId(id).getResult();
        List<TaskV2Model> list = result.stream().sorted((r1, r2) -> r2.getSequenceNbr().compareTo(r1.getSequenceNbr())).collect(Collectors.toList());
        TaskV2Model model = list.get(0);
        Systemctl.taskV2Client.delete(String.valueOf(model.getSequenceNbr()));
        if (list.size()>1){
            TaskV2Model lastTaskModel = list.get(1);
            lastTaskModel.setEndUserId(null);
            lastTaskModel.setEndDate(null);
            lastTaskModel.setTaskStatus(0);
            lastTaskModel.setTaskStatusLabel("待处理");
            lastTaskModel.setFlowCode(obj.get("nextTaskId").toString());
            String urlParams = "";
            try {
                urlParams = "&" + toQueryParams(obj);
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            List<Map> urlList = JsonUtils.getResourceList(urlInfo);
            for (Map map : urlList) {
                if (map.get("type").equals(obj.get("taskType")) && map.get("pageType").equals("look")) {
                    model.setRoutePath(map.get("url").toString().replace("{roleIds}",obj.get("nextExecuteUser").toString()) + urlParams);
                    break;
                }
            }
            Systemctl.taskV2Client.update(lastTaskModel, lastTaskModel.getSequenceNbr());
        }
    }

    public <T> String toQueryParams(T obj) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();

        for (Class<?> clazz = obj.getClass(); !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();

            for (Field field : fields) {
                if (!Modifier.isStatic(field.getModifiers())) {
                    field.setAccessible(true);

                    try {
                        Object value = field.get(obj);

                        if (value != null && !"".equals(value)) {
                            String encodedValue = URLEncoder.encode(value.toString(), "UTF-8");
                            sb.append(field.getName()).append('=').append(encodedValue).append('&');
                        }
                    } catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    /**
     * 根据流程状态name 获取流程状态code
     *
     * @param name 流程状态name
     * @return 流程状态code
     */
    public Integer getDictionaryCodeByName(String name) {
        List<DataDictionary> jggzzz = iDataDictionaryService.getByType("JGGZZZ");
        for (DataDictionary item : jggzzz) {
            if (item.getName().equals(name)) {
                return Integer.parseInt(item.getCode());
            }
        }
        return null;
    }

    /**
     * 根据工作流返回信息，组装业务需要的数据
     *
     * @param processTaskDTOS 工作流返回信息
     * @return 组装后的信息
     */
    public List<WorkflowResultDto> buildWorkFlowInfo(List<ProcessTaskDTO> processTaskDTOS) {
        List<WorkflowResultDto> workflowResultDtoList = new ArrayList<>();
        processTaskDTOS.forEach(item -> {
            WorkflowResultDto workflowResultDto = new WorkflowResultDto();
            if (!ObjectUtils.isEmpty(item.getProcessInstance())) {
                workflowResultDto.setInstanceId(item.getProcessInstance().getId());
            }
            if (!ObjectUtils.isEmpty(item.getTask())) {
                workflowResultDto.setTaskName(item.getTask().getName());
            }
            if (!ObjectUtils.isEmpty(item.getCandidateGroups())) {
                workflowResultDto.setExecutorRoleIds(String.join(",", item.getCandidateGroups()));
            }
            if (!ObjectUtils.isEmpty(item.getStartUser())) {
                workflowResultDto.setStartUserId(item.getStartUser().getUserId());
                workflowResultDto.setStartUserName(item.getStartUser().getRealName());
            }
            if (!ObjectUtils.isEmpty(item.getExecutor())) {
                workflowResultDto.setExecutorId(item.getExecutor().getUserId());
                workflowResultDto.setExecutorName(item.getExecutor().getRealName());
            }
            if (!CollectionUtils.isEmpty(item.getNextTask())) {
                ActTaskDTO actTaskDTO = item.getNextTask().get(0);
                workflowResultDto.setNextTaskId(actTaskDTO.getId());
                workflowResultDto.setNextTaskCode(actTaskDTO.getKey());
                workflowResultDto.setNextTaskName(actTaskDTO.getName());
                List<String> nextGroups = item.getNextCandidateGroups().get(actTaskDTO.getId());
                String join = String.join(",", nextGroups);
                workflowResultDto.setNextExecutorRoleIds(join);
                List<String> nextUserIds = item.getNextTaskExecutor().get(actTaskDTO.getId()).stream().map(AgencyUserModel::getUserId).collect(Collectors.toList());
                String nextUserIdsString = String.join(",", nextUserIds);
                workflowResultDto.setNextExecutorUserIds(nextUserIdsString);
            }
            workflowResultDtoList.add(workflowResultDto);
        });
        return workflowResultDtoList;
    }
}