package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.dao.mapper.DataDictionaryMapper;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgInstallationNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNotice;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNoticeEq;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgInstallationNoticeEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgInstallationNoticeMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgConstructionInfoService;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgUseInfoService;
import com.yeejoin.amos.boot.module.jg.biz.utils.ImageUtils;
import com.yeejoin.amos.boot.module.jg.biz.utils.WordTemplateUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import fr.opensagres.xdocreport.core.io.IOUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.alibaba.fastjson.JSON.parseArray;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
@Slf4j
public class JgInstallationNoticeServiceImpl extends BaseService<JgInstallationNoticeDto,JgInstallationNotice,JgInstallationNoticeMapper> implements IJgInstallationNoticeService {

    private static final String SUBMIT_TYPE_FLOW = "1";
    private static final String PROCESS_DEFINITION_KEY = "installationNotificationNew";
    private static final String TABLE_PAGE_ID = "1734141426742095873";
    private static final String CONSTRUCTION_TYPE = "SGLX";
    private static final String CONSTRUCTION_TYPE_NAME = "安装";


    //西安行政区划code
    private static final String XIAN = "610100";

    //咸阳行政区划code
    private static final String XIAN_YANG = "610400";

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;

    @Autowired
    JgInstallationNoticeEqMapper jgInstallationNoticeEqMapper;

    @Autowired
    private JgInstallationNoticeMapper jgInstallationNoticeMapper;

//    @Autowired
//    private EquipmentCategoryServiceImpl equipmentCategoryService;
    @Autowired
    RegistrationInfoMapper tzsJgRegistrationInfoMapper;
    @Autowired
    OtherInfoMapper tzsJgOtherInfoMapper;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    SupervisoryCodeInfoMapper supervisoryCodeInfoMapper;

    @Autowired
    IIdxBizJgConstructionInfoService constructionInfoService;

    @Autowired
    IIdxBizJgUseInfoService useInfoService;

    @Autowired
    private DataDictionaryMapper dataDictionaryMapper;

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private TzBaseUnitLicenceMapper baseUnitLicenceMapper;

    @Value("classpath:/json/urlInfo.json")
    public Resource bizTypeInfo;

    @Autowired
    private TransactionDefinition transactionDefinition;

    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    @Autowired
    AmosRequestContext amosRequestContext;

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 安装告知
     */
    @Override
    public Map<String, Map<String, Object>> queryBySequenceNbr(Long sequenceNbr) {
        // 安装告知信息
        JgInstallationNotice notice = jgInstallationNoticeMapper.selectById(sequenceNbr);
        if (Objects.isNull(notice)) {
            return null;
        }
        Map<String, Object> installationInfo = BeanUtil.beanToMap(notice);

        installationInfo.put("province", notice.getProvince() + "_" + notice.getProvinceName());
        installationInfo.put("city", notice.getCity() + "_" + notice.getCityName());
        installationInfo.put("county", notice.getCounty() + "_" + notice.getCountyName());
        installationInfo.put("useUnitCreditCode", notice.getUseUnitCreditCode() + "_" + notice.getUseUnitName());
        installationInfo.put("receiveOrgCreditCode", notice.getReceiveOrgCreditCode() + "_" + notice.getReceiveOrgName());
        installationInfo.put("installLeaderId", notice.getInstallLeaderId() + "_" + notice.getInstallLeaderName());
        if(!ValidationUtil.isEmpty(notice.getInspectUnitId()) && !ValidationUtil.isEmpty(notice.getInspectUnitName())) {
            installationInfo.put("inspectUnitId", notice.getInspectUnitId() + "_" + notice.getInspectUnitName());
        }
        if(!ValidationUtil.isEmpty(notice.getFactoryUseSiteStreet()) && !ValidationUtil.isEmpty(notice.getStreetName())) {
            installationInfo.put("factoryUseSiteStreet", notice.getFactoryUseSiteStreet() + "_" + notice.getStreetName());
        }

        String[] fields = {"productPhoto", "designDoc", "designStandard", "factoryStandard",
                "productQualityYieldProve", "insUseMaintainExplain", "inspectReport",
                "proxyStatementAttachment", "installContractAttachment"};

        // 设备信息
        List<Map<String, Object>> equipmentInfos = jgInstallationNoticeMapper.queryEquipInformation(sequenceNbr);

        for (String s:fields) {
            if(installationInfo.containsKey(s)) {
                installationInfo.put(s, parseArray(installationInfo.get(s).toString()));
            }
            if(equipmentInfos.get(0).containsKey(s)) {
                equipmentInfos.get(0).put(s, parseArray(equipmentInfos.get(0).get(s).toString()));
            }
        }

        return new HashMap<String, Map<String, Object>>() {{
            this.put("installationInfo", installationInfo);
            this.put("equipmentInfo", equipmentInfos.get(0));
        }};
    }

    /**
     * 更新安装告知
     *
     * @param noticeDto 安装告知
     */
    @SuppressWarnings({"rawtypes", "Duplicates"})
    public JgInstallationNoticeDto updateInstallationNotice(String submitType, JgInstallationNoticeDto noticeDto, String op) {
       boolean instancedId = ObjectUtils.isEmpty(noticeDto.getInstanceId());
        if (Objects.isNull(noticeDto) || StringUtils.isEmpty(submitType)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        String[] taskName = new String[]{"流程结束"};
        // 字段转换
        this.convertField(noticeDto);
        ArrayList<String> roleListFirst = new ArrayList<>();
        ArrayList<String> roleListSecond = new ArrayList<>();
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            AjaxResult ajaxResult;
            // 发起流程
            if (!StringUtils.hasText(noticeDto.getInstanceId())) {
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                dto.setBusinessKey("1");
                try {
                    ajaxResult = Workflow.taskClient.startByVariable(dto);
                    String instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
                    noticeDto.setInstanceId(instanceId);
                    // 查询下节点任务
                    getNext(roleListFirst, instanceId,taskName);
                    noticeDto.setInstanceStatus(String.join(",", roleListFirst));
                } catch (Exception e) {
                    log.error("提交失败：{}", e);
                }
            }

            JgInstallationNotice notice = new JgInstallationNotice();
            BeanUtils.copyProperties(noticeDto,notice);

            boolean submit = submit(notice, op);

            if(submit) {
                // 查询下节点任务
                getNext(roleListSecond, notice.getInstanceId(),taskName);
                notice.setStatus(taskName[0]);
                if (!ObjectUtils.isEmpty(notice.getInstanceStatus())) {
                    notice.setInstanceStatus(notice.getInstanceStatus() + "," + roleListSecond);
                } else {
                    notice.setInstanceStatus(String.join(",", roleListSecond));
                }
                notice.setPromoter(RequestContext.getExeUserId());
                notice.setNextExecuteIds(String.join(",", roleListSecond));
                notice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                jgInstallationNoticeMapper.updateById(notice);
            }
            if (!instancedId) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("relationId", notice.getInstanceId());
                map.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
                map.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
                updateTaskModel(map,null);
            }

            TaskV2Model taskV2Model = new TaskV2Model();
            //获取待办任务执行人
            List<AgencyUserModel> userList = Privilege.agencyUserClient
                    .queryByRoleId(notice.getNextExecuteIds(), null,Boolean.FALSE).getResult();
            List<String> userIds = userList.stream().map(AgencyUserModel::getUserId).collect(Collectors.toList());
            taskV2Model.setExecuteUserIds(CollectionUtils.isEmpty(userIds)?"": String.join(",", userIds));
            taskV2Model.setExtras(JSON.toJSONString(notice));
            taskV2Model.setRelationId(notice.getInstanceId());
            Map<String, Object> userOrgRoleMap = FeignUtil.remoteCall(() -> Privilege.userOrgRoleClient.getme());
            List<String> userOrgRoleList = (List<String>) userOrgRoleMap.get("roleId");
            String roleIds = String.join(",", userOrgRoleList);
            taskV2Model.setTaskType("installNotice");
            taskV2Model.setTaskTypeLabel("安装告知");
            String url = getUrl(taskV2Model.getTaskType(), "look");
            String format = String.format(url, notice.getSequenceNbr(), notice.getNextExecuteIds(), notice.getNextExecuteIds(), notice.getNoticeStatus(), notice.getInstanceId());
            taskV2Model.setRoutePath(format);


            taskV2Model.setTaskTitle(notice.getStatus());
            taskV2Model.setTaskName(notice.getStatus());
            taskV2Model.setTaskStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode());
            taskV2Model.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
            taskV2Model.setTaskCode(notice.getApplyNo());
            buildTaskModel(taskV2Model);
        } else {
            JgInstallationNotice bean = new JgInstallationNotice();
            BeanUtils.copyProperties(noticeDto, bean);
            jgInstallationNoticeMapper.updateById(bean);
        }
        return noticeDto;
    }



    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 安装告知列表
     */
    @Override
    public Page<JgInstallationNoticeDto> queryForJgInstallationNoticePage(Page<JgInstallationNotice> page, JgInstallationNoticeDto model, String type , ReginParams reginParams) {

        String orgCode;
        orgCode = reginParams.getCompany().getCompanyCode();

        Page<JgInstallationNotice> noticePage = jgInstallationNoticeMapper.queryForPage(page, model, type, orgCode);

        // 将Page<JgInstallationNotice>转化为Page<JgInstallationNoticeDto>
        Page<JgInstallationNoticeDto> noticeDtoPage = new Page<>();
        BeanUtils.copyProperties(noticePage, noticeDtoPage, "records");
        List<JgInstallationNoticeDto> records = noticePage.getRecords().stream().map(notice -> {
            JgInstallationNoticeDto noticeDto = new JgInstallationNoticeDto();
            BeanUtils.copyProperties(notice, noticeDto);
            if (Objects.nonNull(notice.getNoticeStatus())) {
                String noticeStatusDesc = FlowStatusEnum.getNameByType(Long.valueOf(notice.getNoticeStatus()));
                noticeDto.setNoticeStatusDesc(noticeStatusDesc);
            }
            return noticeDto;
        }).collect(java.util.stream.Collectors.toList());
        noticeDtoPage.setRecords(records);

        return noticeDtoPage;
    }

    /**
     * 列表查询 示例
     */
    public List<JgInstallationNoticeDto> queryForJgInstallationNoticeList() {
        return this.queryForList("", false);
    }

    /**
     * 批量删除
     *
     * @param sequenceNbrs 主键
     * @return 是否删除成功
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteForBatch(Long[] sequenceNbrs) {
        if (Objects.isNull(sequenceNbrs) || sequenceNbrs.length == 0) {
            return false;
        }
        Collection<JgInstallationNotice> jgInstallationNotices = this.listByIds(Arrays.asList(sequenceNbrs));
        jgInstallationNotices.forEach(notice -> {
            if (StringUtils.hasText(notice.getInspectUnitId())) {
                throw new IllegalStateException("所选数据已存在流程，不能删除！");
            }
            notice.setIsDelete(true);
        });
        return this.updateBatchById(jgInstallationNotices);
    }

    /**
     * 打印安装告知单
     *
     * @param sequenceNbr 主键
     * @return pdf文件路径
     */
    @Override
    public void generateInstallationNoticeReport(Long sequenceNbr, HttpServletResponse response) {
        if (Objects.isNull(sequenceNbr)) {
            throw new IllegalArgumentException("参数不能为空");
        }

        JgInstallationNotice jgInstallationNotice = this.getById(sequenceNbr);
        List<Map<String, Object>> informationList = jgInstallationNoticeMapper.queryEquipInformation(sequenceNbr);
        if (Objects.isNull(jgInstallationNotice) || CollectionUtils.isEmpty(informationList)) {
            throw new IllegalArgumentException("安装告知单不存在");
        }
        Map<String, Object> installation = informationList.get(0);

        String useCode = String.valueOf(installation.get("installUnitCreditCode"));
        LambdaQueryWrapper<TzBaseUnitLicence> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TzBaseUnitLicence::getUnitCode, useCode);
        List<TzBaseUnitLicence> list = baseUnitLicenceMapper.selectList(wrapper);

        ArrayList<String> installLicenseNoList = new ArrayList<>();
        ArrayList<String> installLicenseExpirationDateList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(tzBaseUnitLicence -> {
                // 因模板许可证编号配置最多支持三个，再多样式混乱，目前返回三个
                if (installLicenseNoList.size() < 3) {
                    installLicenseNoList.add(tzBaseUnitLicence.getCertNo());
                    installLicenseExpirationDateList.add(DateUtils.convertDateToString(tzBaseUnitLicence.getExpiryDate(), DateUtils.DATE_PATTERN));
                }
            });
        }

        Function<String, String> getValue = key -> installation.getOrDefault(key, "").toString();

        // 组装模板变量
        Map<String, Object> placeholders = new HashMap<>();
        placeholders.put("sequenceNbr", getValue.apply("sequenceNbr"));
        placeholders.put("installUnitName", getValue.apply("installUnitName"));
        placeholders.put("applyNo", getValue.apply("applyNo"));
        placeholders.put("productName", getValue.apply("productName"));
        placeholders.put("equipType", getValue.apply("equType"));
        placeholders.put("equipCode", getValue.apply("equRegisterCode"));
        placeholders.put("produceCode", getValue.apply("factoryNum")); // TODO: 出厂编号
        placeholders.put("produceUnitName", getValue.apply("produceUnitName"));
        placeholders.put("produceLicenseNum", getValue.apply("produceLicenseNum"));
        placeholders.put("installUnitAddress", getValue.apply("provinceName") + getValue.apply("cityName") + getValue.apply("countyName") + getValue.apply("streetName") + getValue.apply("address"));
        placeholders.put("installStartDate", getValue.apply("installStartDate"));
        placeholders.put("installType", "安装告知"); // TODO: 施工类别
        placeholders.put("installLicenseNo", getValue.apply("installLicenseNo"));
        placeholders.put("installLicenseExpirationDate", getValue.apply("installLicenseExpirationDate"));
        placeholders.put("installLeaderName", getValue.apply("installLeaderName"));
        placeholders.put("installLeaderPhone", getValue.apply("installLeaderPhone"));
        placeholders.put("fullAddress", getValue.apply("provinceName") + getValue.apply("cityName") + getValue.apply("countyName") + getValue.apply("streetName") + getValue.apply("address"));
        placeholders.put("useUnitName", getValue.apply("useUnitName"));
        placeholders.put("useUnitLeaderName", getValue.apply("safetyManager"));
        placeholders.put("useUnitLeaderPhone", getValue.apply("safetyManagerPhone"));
        placeholders.put("useUnitLeaderAddress", getValue.apply("address"));

        placeholders.put("installLicenseNoList", installLicenseNoList);
        placeholders.put("installLicenseExpirationDateList", installLicenseExpirationDateList);

        // 生成二维码
        String qrCode = ImageUtils.generateQRCode(getValue.apply("applyNo"), 300, 300);
        placeholders.put("qrCode", qrCode);

//        String url = WordTemplateUtils.templateToPdf("installation-notification-report.ftl", placeholders);

        // 更新到数据库
//        jgInstallationNotice.setNoticeReportUrl(url);
//        this.updateById(jgInstallationNotice);
//
//        return url;
        String tempFileName = "安装告知单_" + System.currentTimeMillis() + "_temp";
        WordTemplateUtils.templateToPdfDownload(tempFileName, "installation-notification-report.ftl", placeholders, response);
    }

    @Override
    @SuppressWarnings({"Duplicates", "rawtypes"})
    @Transactional(rollbackFor = Exception.class)
    public void saveNotice(String submitType, JSONObject jgInstallationNoticeDtoMap, ReginParams reginParams) {
        String[] taskName = new String[]{"流程结束"};

//        TransactionStatus transactionStatus = platformTransactionManager.getTransaction(transactionDefinition);

//        JgInstallationNoticeDto model = BeanUtil.toBeanIgnoreError(jgInstallationNoticeDtoMap.get(TABLE_PAGE_ID).toString(), JgInstallationNoticeDto.class);
        JgInstallationNoticeDto model = JSON.parseObject(jgInstallationNoticeDtoMap.get(TABLE_PAGE_ID).toString(), JgInstallationNoticeDto.class);
        // 字段转换
        convertField(model);

        // 获取告知设备列表
        List<Map<String, Object>> deviceList = model.getDeviceList();
        if (CollectionUtils.isEmpty(deviceList)) {
            throw new BadRequest("设备列表为空");
        }

        // 获取告知单号
        ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.AZGZ.getCode(), deviceList.size());
        if (!ObjectUtils.isEmpty(listResponseModel) && listResponseModel.getStatus() != HttpStatus.OK.value()) {
            log.error("告知单获取失败: {}", listResponseModel.getMessage());
            throw new BadRequest("告知单生成失败！");
        }
        List<String> applyNoList = listResponseModel.getResult();
        if (CollectionUtils.isEmpty(applyNoList)) {
            log.error("告知单返回为空");
            throw new BadRequest("告知单生成失败！");
        }


        List<JgInstallationNotice> list = new ArrayList<>();
        List<JgInstallationNoticeEq> equipList = new ArrayList<>();
        deviceList.forEach(obj -> {
            JgInstallationNoticeEq jgRelationEquip = new JgInstallationNoticeEq();
            JgInstallationNotice dto = new JgInstallationNotice();
            BeanUtils.copyProperties(model, dto);
            int i = deviceList.indexOf(obj);
            String applyNo = applyNoList.get(i);
            dto.setApplyNo(applyNo);
            dto.setNoticeDate(new Date());
            if(SUBMIT_TYPE_FLOW.equals(submitType)) {
                dto.setPromoter(RequestContext.getExeUserId());
                dto.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
            }
            dto.setCreateUserId(RequestContext.getExeUserId());
            dto.setInstallUnitName(reginParams.getCompany().getCompanyName());
            dto.setInstallUnitCreditCode(reginParams.getCompany().getCompanyCode());
            dto.setEquList((String.valueOf(obj.get("EQU_CATEGORY"))));
            dto.setEntrustingUnitName(dto.getUseUnitName());
            StringBuffer buffer = new StringBuffer();
            buffer.append(dto.getProvinceName()).append(dto.getCityName()).append(dto.getCountyName()).append(dto.getAddress());
            dto.setEquAddress(buffer.toString());
            jgRelationEquip.setEquId(String.valueOf(obj.get("SEQUENCE_NBR")));
            jgRelationEquip.setEquipTransferId(applyNo);
            list.add(dto);
            equipList.add(jgRelationEquip);
        });

        jgInstallationNoticeMapper.insertBatchSomeColumn(list);

        List<JgInstallationNoticeEq> jgRelationEquipList = equipList.stream().map(jgRelationEquip -> {
            List<JgInstallationNotice> collect = list.stream().filter(jgInstallationNotice -> jgRelationEquip.getEquipTransferId().equals(jgInstallationNotice.getApplyNo())).collect(Collectors.toList());
            Long sequenceNbr = collect.get(0).getSequenceNbr();
            return jgRelationEquip.setEquipTransferId(String.valueOf(sequenceNbr));
        }).collect(Collectors.toList());

        jgInstallationNoticeEqMapper.insertBatchSomeColumn(jgRelationEquipList);


        // 需要在事务提交之后，否则事务隔离查询不出数据
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                List<ActWorkflowStartDTO> workflowStartDTOS = new ArrayList<>();
                list.forEach(item -> {
                    if (SUBMIT_TYPE_FLOW.equals(submitType)) {
                        // 发起流程
                        ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                        dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                        dto.setBusinessKey(item.getSequenceNbr() + "");
                        dto.setCompleteFirstTask(Boolean.TRUE);
                        workflowStartDTOS.add(dto);
                    }
                });
                try {
                    actWorkflowBatchDTO.setProcess(workflowStartDTOS);
                    Workflow.taskV2Client.startByVariableBatch(actWorkflowBatchDTO);
                } catch (Exception e) {
                    log.error("提交失败：{}", e);
                }
            }


        });




//        platformTransactionManager.commit(transactionStatus);




//        list.forEach(item -> {
//            // 代办业务
//            if(SUBMIT_TYPE_FLOW.equals(submitType)) {
//                TaskV2Model taskV2Model = new TaskV2Model();
//                //获取待办任务执行人
//                List<AgencyUserModel> userList = Privilege.agencyUserClient
//                        .queryByRoleId(item.getNextExecuteIds(), null,Boolean.FALSE).getResult();
//                List<String> userIds = userList.stream().map(AgencyUserModel::getUserId).collect(Collectors.toList());
//                taskV2Model.setExecuteUserIds(CollectionUtils.isEmpty(userIds)?"": String.join(",", userIds));
//                taskV2Model.setExtras(JSON.toJSONString(item));
//                taskV2Model.setRelationId(item.getInstanceId());
//                Map<String, Object> userOrgRoleMap = FeignUtil.remoteCall(() -> Privilege.userOrgRoleClient.getme());
//                List<String> userOrgRoleList = (List<String>) userOrgRoleMap.get("roleId");
//                String roleIds = String.join(",", userOrgRoleList);
//                taskV2Model.setTaskType("installNotice");
//                taskV2Model.setTaskTypeLabel("安装告知");
//                String url = getUrl(taskV2Model.getTaskType(), "look");
//                String format = String.format(url, item.getSequenceNbr(), item.getNextExecuteIds(), item.getNextExecuteIds(), item.getNoticeStatus(), item.getInstanceId());
//                taskV2Model.setRoutePath(format);
//                taskV2Model.setTaskTitle(item.getStatus());
//                taskV2Model.setTaskName(item.getStatus());
//                taskV2Model.setTaskStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode());
//                taskV2Model.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
//                taskV2Model.setTaskCode(item.getApplyNo());
//                buildTaskModel(taskV2Model);
//            }
//        });


    }

    void getNext(ArrayList<String> roleListFirst, String instanceId, String[] taskName) {
        AjaxResult aj = Workflow.taskClient.getTaskNoAuth(instanceId);
        JSONObject taskNoAuth = JSON.parseObject(JSON.toJSONString(aj.get("data")));
        if (!ObjectUtils.isEmpty(taskNoAuth)) {
            String nextTaskId = taskNoAuth.getString("id");
            AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
            taskName[0] = taskNoAuth.getString("name");
            JSONArray data = parseArray(JSON.toJSONString(taskGroupName.get("data")));
            for (Object datum : data) {
                if (((Map) datum).containsKey("groupId")) {
                    roleListFirst.add(((Map) datum).get("groupId").toString());
                }
            }
        }
    }

    private void convertField(JgInstallationNoticeDto model) {
        // 处理图片
        if(!ValidationUtil.isEmpty(model.getProxyStatementAttachmentList())) {
            model.setProxyStatementAttachment(JSON.toJSONString(model.getProxyStatementAttachmentList()));
        }
        if(!ValidationUtil.isEmpty(model.getInstallContractAttachmentList())) {
            model.setInstallContractAttachment(JSON.toJSONString(model.getInstallContractAttachmentList()));
        }

        // 分割省市区字段
        String province = model.getProvince();
        if (!ObjectUtils.isEmpty(province)) {
            String[] provinceList = province.split("_");
            if (provinceList.length > 1) {
                model.setProvince(provinceList[0]);
                model.setProvinceName(provinceList[1]);
            }
        }

        String city = model.getCity();
        if (!ObjectUtils.isEmpty(city)) {
            String[] cityList = city.split("_");
            if (cityList.length > 1) {
                model.setCity(cityList[0]);
                model.setCityName(cityList[1]);
            }
        }

        String county = model.getCounty();
        if (!ObjectUtils.isEmpty(county)) {
            String[] countyList = county.split("_");
            if (countyList.length > 1) {
                model.setCounty(countyList[0]);
                model.setCountyName(countyList[1]);
            }
        }

        String factoryUseSiteStreet = model.getFactoryUseSiteStreet();
        if (!ObjectUtils.isEmpty(factoryUseSiteStreet)) {
            String[] factoryUseSiteStreetList = factoryUseSiteStreet.split("_");
            if (factoryUseSiteStreetList.length > 1) {
                model.setFactoryUseSiteStreet(factoryUseSiteStreetList[0]);
                model.setStreetName(factoryUseSiteStreetList[1]);
            }
        }

        // 分割单位
        String useUnitId = model.getUseUnitCreditCode();
        if (!ObjectUtils.isEmpty(useUnitId)) {
            String[] useUnitList = useUnitId.split("_");
            if (useUnitList.length > 1) {
                model.setUseUnitCreditCode(useUnitList[0]);
                model.setUseUnitName(useUnitList[1]);
            }
        }

        String receiveOrgId = model.getReceiveOrgCreditCode();
        if (!ObjectUtils.isEmpty(receiveOrgId)) {
            String[] receiveOrgIdList = receiveOrgId.split("_");
            if (receiveOrgIdList.length > 1) {
                model.setReceiveOrgCreditCode(receiveOrgIdList[0]);
                model.setReceiveOrgName(receiveOrgIdList[1]);
            }
        }

        String inspectUnitId = model.getInspectUnitId();
        if (!ObjectUtils.isEmpty(inspectUnitId)) {
            String[] inspectUnitIdList = inspectUnitId.split("_");
            if (inspectUnitIdList.length > 1) {
                model.setInspectUnitId(inspectUnitIdList[0]);
                model.setInspectUnitName(inspectUnitIdList[1]);
            }
        }

        String installLeaderId = model.getInstallLeaderId();
        if (!ObjectUtils.isEmpty(installLeaderId)) {
            String[] leaderList = installLeaderId.split("_");
            if (leaderList.length > 1) {
                model.setInstallLeaderId(leaderList[0]);
                model.setInstallLeaderName(leaderList[1]);
            }
        }
    }

    private String convertImageUrl(List<Map<String, String>> urlList) {
        String urls = "";
        if (!CollectionUtils.isEmpty(urlList)) {
            urls = urlList.stream().map(map -> map.get("url")).collect(Collectors.joining(","));
        }
        return urls;
    }

    public boolean submit(JgInstallationNotice notice,String op) {

        AjaxResult ajaxResult = Workflow.taskClient.getTask(notice.getInstanceId());
        JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
        String taskId = dataObject.getString("id");
        //组装信息
        TaskResultDTO dto = new TaskResultDTO();
        dto.setResultCode("approvalStatus");
        dto.setTaskId(taskId);
        if(!ValidationUtil.isEmpty(notice.getProcessAdvice())) {
            dto.setComment(notice.getProcessAdvice());
        }
        HashMap<String, Object> map = new HashMap<>();
        if(notice.getNoticeStatus().equals("6614") || notice.getNoticeStatus().equals("6615") ) {
            map.put("approvalStatus", "提交");
        } else {
            map.put("approvalStatus", op);
        }

        dto.setVariable(map);
        //执行流程
        AjaxResult ajaxResult1 = null;
        try {
            ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);
            if (ajaxResult1.get("code").equals(200)) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            log.error("提交失败：{}", e);
            return false;
        }
    }

    public void cancel(JgInstallationNoticeDto noticeDto) {
        String[] taskName = new String[]{"流程结束"};
        FeignClientResult ajaxResult = Workflow.taskV2Client.rollBack(noticeDto.getInstanceId());
        JgInstallationNotice jgInstallationNotice = this.baseMapper.selectById(noticeDto.getSequenceNbr());
        ArrayList<String> roleList = new ArrayList<>();
        if(ajaxResult.getStatus() == 200) {

//            HashMap<String, Object> map = new HashMap<>();
//            map.put("relationId", noticeDto.getInstanceId());
//            map.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
//            map.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
//            map.put("isDelete", Boolean.TRUE);
//            updateTaskModel(map);

            getNext(roleList, noticeDto.getInstanceId(),taskName);
            jgInstallationNotice.setStatus(taskName[0]);
            jgInstallationNotice.setPromoter("");
            jgInstallationNotice.setNextExecuteIds(String.join(",", roleList));
            jgInstallationNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.ROLLBACK.getCode()));
            jgInstallationNoticeMapper.updateById(jgInstallationNotice);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void accept(JgInstallationNoticeDto dto,String op) {
        String[] taskName = new String[]{"流程结束"};
        String userId = RequestContext.getExeUserId();
        JgInstallationNotice jgInstallationNotice = this.jgInstallationNoticeMapper.selectById(dto.getSequenceNbr());
        jgInstallationNotice.setProcessAdvice(dto.getProcessAdvice());
        ArrayList<String> roleList = new ArrayList<>();
        boolean submit = submit(jgInstallationNotice, op);
//        if(submit) {
////            getNext(roleList, dto.getInstanceId(),taskName);
////            jgInstallationNotice.setStatus(taskName[0]);
//            if("0".equals(op)) {
//                finishTask(jgInstallationNotice);
//            } else {
//                jgInstallationNotice.setPromoter("");
//                jgInstallationNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.REJECTED.getCode()));
//
//                HashMap<String, Object> map = new HashMap<>();
//                map.put("relationId", jgInstallationNotice.getInstanceId());
//                map.put("taskStatus", FlowStatusEnum.REJECTED.getCode());
//                map.put("taskStatusLabel", FlowStatusEnum.REJECTED.getName());
//                TaskV2Model taskV2ModelOld = updateTaskModel(map);
//                TaskV2Model taskV2Model = new TaskV2Model();
//                //获取待办任务执行人
//                List<AgencyUserModel> userList = Privilege.agencyUserClient
//                        .queryByRoleId(jgInstallationNotice.getNextExecuteIds(), null,Boolean.FALSE).getResult();
//                List<String> userIds = userList.stream().map(AgencyUserModel::getUserId).collect(Collectors.toList());
//                taskV2Model.setExecuteUserIds(taskV2ModelOld.getRecUserId());
//                taskV2Model.setExtras(JSON.toJSONString(jgInstallationNotice));
//                taskV2Model.setRelationId(jgInstallationNotice.getInstanceId());
//                Map<String, Object> userOrgRoleMap = FeignUtil.remoteCall(() -> Privilege.userOrgRoleClient.getme());
//                List<String> userOrgRoleList = (List<String>) userOrgRoleMap.get("roleId");
//                String roleIds = String.join(",", userOrgRoleList);
//                taskV2Model.setTaskType("installNotice");
//                taskV2Model.setTaskTypeLabel("安装告知");
//                String url = getUrl(taskV2Model.getTaskType(), "edit");
//                String format = String.format(url, jgInstallationNotice.getSequenceNbr(), jgInstallationNotice.getNextExecuteIds(), jgInstallationNotice.getNextExecuteIds(), jgInstallationNotice.getNoticeStatus(), "", jgInstallationNotice.getInstanceId());
//                taskV2Model.setRoutePath(format);
//                taskV2Model.setTaskTitle(jgInstallationNotice.getStatus());
//                taskV2Model.setTaskName(jgInstallationNotice.getStatus());
//                taskV2Model.setTaskStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode());
//                taskV2Model.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
//                taskV2Model.setTaskCode(jgInstallationNotice.getApplyNo());
//                buildTaskModel(taskV2Model);
//            }
//            jgInstallationNoticeMapper.updateById(jgInstallationNotice);
//        }
    }

    public void finishTask(JgInstallationNotice jgInstallationNotice) {
        String ym = null;
        try {
            ym = DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN_MM);
        } catch (ParseException e) {
            log.error("日期转换失败：{}", e);
        }
        // 组装设备注册代码
        StringBuffer stringBuffer = new StringBuffer();
        LambdaQueryWrapper<JgInstallationNoticeEq> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JgInstallationNoticeEq::getEquipTransferId,jgInstallationNotice.getSequenceNbr());
        JgInstallationNoticeEq jgRelationEquip = jgInstallationNoticeEqMapper.selectOne(queryWrapper);

        LambdaQueryWrapper<OtherInfo> queryWrapper1 = new LambdaQueryWrapper<>();
        queryWrapper1.eq(OtherInfo::getRecord,jgRelationEquip.getEquId());
        OtherInfo tzsJgOtherInfo = tzsJgOtherInfoMapper.selectOne(queryWrapper1);

        LambdaQueryWrapper<RegistrationInfo> queryWrapper2 = new LambdaQueryWrapper<>();
        queryWrapper2.eq(RegistrationInfo::getRecord,jgRelationEquip.getEquId());
        RegistrationInfo tzsJgRegistrationInfo = tzsJgRegistrationInfoMapper.selectOne(queryWrapper2);

        stringBuffer.append(tzsJgRegistrationInfo.getEquCategory()).append(jgInstallationNotice.getCity()).append(ym);
        String equCode = stringBuffer.toString();

        ResponseModel<String> responseModel  = tzsServiceFeignClient.deviceRegistrationCode(equCode);
        String deviceRegistrationCode = responseModel.getResult();
        Map<String, Object> map = new HashMap<>();
        map.put("cityCode",jgInstallationNotice.getCity());
        map.put("countyCode",jgInstallationNotice.getCounty());
        map.put("equCategory",tzsJgRegistrationInfo.getEquCategory());
        map.put("isXiXian", jgInstallationNotice.getIsXixian() == null ? "null" : jgInstallationNotice.getIsXixian().equals("0") ? "null" : "1");
        Map<String, Object> mapCode;
        ResponseModel<Map<String, Object>> code = tzsServiceFeignClient.createCode(map);
        mapCode = code.getResult();

        LambdaQueryWrapper<SupervisoryCodeInfo> queryWrapper3 = new LambdaQueryWrapper<>();
        queryWrapper3.eq(SupervisoryCodeInfo::getSupervisoryCode,mapCode.get("superviseCode").toString());
        SupervisoryCodeInfo supervisoryCodeInfo = supervisoryCodeInfoMapper.selectOne(queryWrapper3);
        supervisoryCodeInfo.setStatus("1");
        supervisoryCodeInfoMapper.updateById(supervisoryCodeInfo);
        jgInstallationNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
        jgInstallationNotice.setHandleDate(new Date());

        Map<String,Object> map1 =new HashMap<>();

        // 更新其他业务表
        if(!ValidationUtil.isEmpty(mapCode.get("code96333"))) {
            tzsJgOtherInfo.setCode96333(mapCode.get("code96333").toString());
            map1.put("CODE96333",tzsJgOtherInfo.getCode96333() );
        }
        tzsJgOtherInfo.setSupervisoryCode(mapCode.get("superviseCode").toString());
        tzsJgRegistrationInfo.setEquCode(deviceRegistrationCode);
        jgInstallationNotice.setEquRegisterCode(deviceRegistrationCode);
        jgInstallationNotice.setSupervisoryCode(mapCode.get("superviseCode").toString());
        Map<String,Map<String,Object>> objMap = new HashMap<>();
        map1.put("EQU_CODE",tzsJgRegistrationInfo.getEquCode() );
        map1.put("SUPERVISORY_CODE",tzsJgOtherInfo.getSupervisoryCode());
        map1.put("USE_UNIT_CREDIT_CODE",jgInstallationNotice.getUseUnitCreditCode());
        map1.put("USE_UNIT_NAME",jgInstallationNotice.getUseUnitName());

        map1.put("USC_UNIT_CREDIT_CODE",jgInstallationNotice.getInstallUnitCreditCode());
        map1.put("USC_UNIT_NAME",jgInstallationNotice.getInstallUnitName());
        objMap.put(tzsJgOtherInfo.getRecord(),map1);
        jgInstallationNotice.setPromoter("");
        tzsServiceFeignClient.commonUpdateEsDataByIds(objMap);
        tzsJgOtherInfoMapper.updateById(tzsJgOtherInfo);
        tzsJgRegistrationInfoMapper.updateById(tzsJgRegistrationInfo);

        // 更新施工信息表
        IdxBizJgConstructionInfo idxBizJgConstructionInfo = constructionInfoService.queryNewestDetailByRecord(jgRelationEquip.getEquId());
        if (!ObjectUtils.isEmpty(idxBizJgConstructionInfo)) {
            idxBizJgConstructionInfo.setUscUnitCreditCode(jgInstallationNotice.getInstallUnitCreditCode());
            idxBizJgConstructionInfo.setUscUnitName(jgInstallationNotice.getInstallUnitName());
            idxBizJgConstructionInfo.setUscDate(jgInstallationNotice.getInstallStartDate());
            // 获取施工类型id
            LambdaQueryWrapper<DataDictionary> lambda = new LambdaQueryWrapper<>();
            lambda.eq(DataDictionary::getType, CONSTRUCTION_TYPE);
            lambda.eq(DataDictionary::getName, CONSTRUCTION_TYPE_NAME);
            List<DataDictionary> dataDictionaries = dataDictionaryMapper.selectList(lambda);
            if (!CollectionUtils.isEmpty(dataDictionaries)) {
                idxBizJgConstructionInfo.setConstructionType(String.valueOf(dataDictionaries.get(0).getSequenceNbr()));
            }
            constructionInfoService.saveOrUpdateData(idxBizJgConstructionInfo);
        }

        // 使用信息表更新是否西咸
        IdxBizJgUseInfo useInfo = useInfoService.getOneData(jgRelationEquip.getEquId());
        if (!ObjectUtils.isEmpty(useInfo)) {
            useInfo.setUseUnitCreditCode(jgInstallationNotice.getUseUnitCreditCode());
            useInfo.setUseUnitName(jgInstallationNotice.getUseUnitName());
            useInfo.setIsNotXiXian(jgInstallationNotice.getIsXixian() == null ? "0" : jgInstallationNotice.getIsXixian());
            useInfoService.saveOrUpdateData(useInfo);
        }
    }


    public void buildTaskModel(TaskV2Model model){
//        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        model.setStartDate(new Date());
        model.setTaskSource("workFlow");
        model.setCreateDate(new Date());
        //model.setFinishStatus(Boolean.FALSE);
        model.setAgencyCode("tzs");
        model.setTaskTitle("发起了" + model.getTaskTitle());
        Systemctl.taskV2Client.create(model);
    }

    public TaskV2Model  updateTaskModel(Map<String, Object> params, JSONObject jsonObject){
        JSONObject userJson = null;
        if(jsonObject != null){
            userJson = JSON.parseObject(jsonObject.get("user").toString());
        }
        List<TaskV2Model> result =Systemctl.taskV2Client.selectListByRelationId(params.get("relationId").toString()).getResult();
        TaskV2Model model = result.stream().min((r1, r2) -> r2.getSequenceNbr().compareTo(r1.getSequenceNbr()))
                .orElse(null);
        if(model == null){
            return null;
        }
        model.setTaskStatus(Integer.valueOf(params.get("taskStatus").toString()));
        model.setRoutePath(model.getRoutePath().replace("nextExecuteIds", "nextExecuteIdsOld"));
        model.setTaskStatusLabel(params.get("taskStatusLabel").toString());
        model.setEndDate(new Date());
        //model.setFinishStatus(Boolean.TRUE);
        model.setEndUserId(userJson != null ? userJson.get("userId").toString() : "");
        if (params.containsKey("isDelete")) {
            Systemctl.taskV2Client.delete(model.getSequenceNbr().toString());
        } else {
            Systemctl.taskV2Client.update(model, model.getSequenceNbr());
        }
        return model;
    }

    private String getUrl(String type, String pageType) {
        String json = null;
        try {
            json = IOUtils.toString(bizTypeInfo.getInputStream(), java.lang.String.valueOf(StandardCharsets.UTF_8));
        } catch (IOException e) {
            e.printStackTrace();
        }
        List<Map> list = parseArray(json, Map.class);
        String url = null;
        for (Map map : list) {
            if (map.get("type").equals(type)&& pageType.equals(map.get("pageType"))){
                url = map.get("url").toString();
                break;
            }
        }
        return url;
    }

    public void updateByWorkFlow(JSONObject jsonObject) {
        String businessKey = jsonObject.getString("businessKey");
        JgInstallationNotice jgInstallationNotice = this.getById(businessKey);
        List<String> list = (List<String>) jsonObject.get("candidateGroups");
        JSONArray executor = parseArray(jsonObject.get("executor").toString());
        List<String> userList = new ArrayList<>();
        for (Object datum : executor) {
            if (((Map) datum).containsKey("userId")) {
                userList.add(((Map) datum).get("userId").toString());
            }
        }
        String userIds = String.join(",", userList);
        jgInstallationNotice.setInstanceId(jsonObject.get("processInstanceId").toString());
        jgInstallationNotice.setNextExecuteIds(String.join(",", list));
        jgInstallationNotice.setInstanceStatus(jgInstallationNotice.getInstanceStatus() + "," + String.join(",", list));
        jgInstallationNotice.setStatus(jsonObject.get("nodeName").toString());
        FlowStatusEnum noticeStatus = this.buildNoticeStatus(jgInstallationNotice.getApprovalStatus());
        jgInstallationNotice.setNoticeStatus(noticeStatus.getCode() + "");
        this.updateById(jgInstallationNotice);

        if (!"撤回".equals(jgInstallationNotice.getApprovalStatus())) {
            //  创建待办
            TaskV2Model taskV2Model = new TaskV2Model();
            taskV2Model.setExecuteUserIds(userIds);
            taskV2Model.setExtras(JSON.toJSONString(jgInstallationNotice));
            taskV2Model.setRelationId(jgInstallationNotice.getInstanceId());
            taskV2Model.setTaskType("installNotice");
            taskV2Model.setTaskTypeLabel("安装告知");
            String url = getUrl(taskV2Model.getTaskType(), "look");
            String format = String.format(url, jgInstallationNotice.getSequenceNbr(), jgInstallationNotice.getNextExecuteIds(), jgInstallationNotice.getNextExecuteIds(), jgInstallationNotice.getNoticeStatus(), jgInstallationNotice.getInstanceId());
            taskV2Model.setRoutePath(format);
            taskV2Model.setTaskTitle(jgInstallationNotice.getStatus());
            taskV2Model.setTaskName(jgInstallationNotice.getStatus());
            taskV2Model.setTaskStatus(noticeStatus.getCode());
            taskV2Model.setTaskStatusLabel(noticeStatus.getName());
            taskV2Model.setTaskCode(jgInstallationNotice.getApplyNo());
            taskV2Model.setStartUserId(jgInstallationNotice.getCreateUserId());
            //taskV2Model.setCreateUserId(jgInstallationNotice.getCreateUserId());
            buildTaskModel(taskV2Model);
        }
    }

    private FlowStatusEnum buildNoticeStatus(String approvalStatus){
        if("提交".equals(approvalStatus)){
            return FlowStatusEnum.TO_BE_PROCESSED;
        } else if("驳回".equals(approvalStatus)  || "1".equals(approvalStatus)){
            return FlowStatusEnum.REJECTED;
        } else if("通过".equals(approvalStatus) || "0".equals(approvalStatus)){
            return FlowStatusEnum.TO_BE_FINISHED;
        } else {
            return FlowStatusEnum.ROLLBACK;
        }
    }


    public void completeWorkFlow(String approvalStatus, JSONObject jsonObject) {
        // 1.更新业务字段
        String businessKey = jsonObject.getString("businessKey");
        JgInstallationNotice jgInstallationNotice = this.getById(businessKey);
        jgInstallationNotice.setInstanceId(jsonObject.get("processInstanceId").toString());
        jgInstallationNotice.setStatus(jsonObject.get("nodeName").toString());
        jgInstallationNotice.setApprovalStatus(approvalStatus);
        FlowStatusEnum noticeStatus = this.buildNoticeStatus(jgInstallationNotice.getApprovalStatus());
        jgInstallationNotice.setNoticeStatus(noticeStatus.getCode() + "");
        this.updateById(jgInstallationNotice);
        if ("撤回".equals(approvalStatus)) {
            // 删除待办
            HashMap<String, Object> map = new HashMap<>();
            map.put("relationId", jgInstallationNotice.getInstanceId());
            map.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
            map.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
            map.put("isDelete", Boolean.TRUE);
            updateTaskModel(map, jsonObject);
        } else {
            // 更新代办为已完成及更新url
            List<TaskV2Model> result = Systemctl.taskV2Client.selectListByRelationId(jgInstallationNotice.getInstanceId()).getResult();
            // 按时间降序排序
            TaskV2Model model = result.stream().min((r1, r2) -> r2.getSequenceNbr().compareTo(r1.getSequenceNbr()))
                    .orElse(null);
            if (model == null) {
                return;
            }
            String url = getUrl(model.getTaskType(), "look");
            String format = String.format(url, jgInstallationNotice.getSequenceNbr(), jgInstallationNotice.getNextExecuteIds(), jgInstallationNotice.getNextExecuteIds(), jgInstallationNotice.getNoticeStatus(), jgInstallationNotice.getInstanceId());
            model.setRoutePath(format);
            model.setRoutePath(model.getRoutePath().replace("nextExecuteIds", "nextExecuteIdsOld"));
            model.setTaskStatusLabel(jsonObject.get("nodeName").toString());
            model.setEndDate(new Date());
            //model.setFinishStatus(Boolean.TRUE);
            JSONObject userJson = JSON.parseObject(jsonObject.get("user").toString());
            model.setEndUserId(userJson.get("userId").toString());
            Systemctl.taskV2Client.update(model, model.getSequenceNbr());
        }
    }
}