package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.dto.TaskModelDto;
import com.yeejoin.amos.boot.module.jg.api.dto.WorkflowResultDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRegistrationHistory;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.EquipTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgUseRegistrationService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgFactoryInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.OtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgRegisterInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.InspectionDetectionInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.OtherInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.*;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.*;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
public class JgUseRegistrationServiceImpl extends BaseService<JgUseRegistrationDto, JgUseRegistration, JgUseRegistrationMapper> implements IJgUseRegistrationService {

    @Autowired
    private UseInfoMapper useInfoMapper;
    @Autowired
    private InspectionDetectionInfoMapper inspectionDetectionInfoMapper;
    @Autowired
    private OtherInfoMapper otherInfoMapper;
    @Autowired
    private JgUseRegistrationEqMapper jgRelationEquipMapper;
    @Autowired
    WorkFlowFeignService workFlowFeginService;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    JgRegistrationHistoryServiceImpl jgRegistrationHistoryService;
    @Autowired
    IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;
    @Autowired
    private IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;
    @Autowired
    private IdxBizJgUseInfoServiceImpl idxBizJgUseInfoService;
    @Autowired
    private IdxBizJgFactoryInfoServiceImpl idxBizJgFactoryInfoService;
    @Autowired
    ICommonService commonService;
    @Autowired
    CommonServiceImpl commonServiceImpl;
    @Autowired
    CmWorkflowServiceImpl cmWorkflowService;

    public Page<Map<String, Object>> getList(JgUseRegistrationDto dto, Page<Map<String, Object>> page, List<String> roleIds) {
        Page<Map<String, Object>> listPage = this.baseMapper.getListPage(page, dto, roleIds);
        return listPage;
    }

    public Page<Map<String, Object>> getEquipList(Page<Map<String, Object>> page, String factoryNum, String equList, String equCategory) {
        return this.baseMapper.getEquipListPage(page, factoryNum, equList, equCategory);
    }

    public void updateEquipMessage(String currentDocumentId, String useOrgCode) {
        LambdaQueryWrapper<JgRegistrationHistory> lambdaSelect = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambdaSelect.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambdaSelect);
        JSONObject map = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
        UseInfo useInfo = new UseInfo();
        BeanUtil.copyProperties(map, useInfo);
        LambdaQueryWrapper<UseInfo> lambda = new QueryWrapper<UseInfo>().lambda();
        lambda.eq(UseInfo::getRecord, map.get("equipId"));
        // 更新使用信息
        useInfoMapper.update(useInfo, lambda);
        InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
        BeanUtil.copyProperties(map, inspectionDetectionInfo);
        LambdaQueryWrapper<InspectionDetectionInfo> inspectionLambda = new QueryWrapper<InspectionDetectionInfo>().lambda();
        inspectionLambda.eq(InspectionDetectionInfo::getRecord, map.get("equipId"));
        // 更新检验检测信息
        inspectionDetectionInfo.setInspectReport(null);
        inspectionDetectionInfoMapper.update(inspectionDetectionInfo, inspectionLambda);
        // 更新设备使用登记证
        idxBizJgRegisterInfoMapper.updateUseOrgCodeByEquip(String.valueOf(map.get("equipId")), useOrgCode);
    }

    public void updateHistory(JSONObject map, String equipId, String currentDocumentId, String supervisoryCode) {
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getEquId, equipId);
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        lambda.eq(JgRegistrationHistory::getRegistrationClass, "使用登记");
        Integer integer = jgRegistrationHistoryService.getBaseMapper().selectCount(lambda);
        if (integer > 0) {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(map));
            jgRegistrationHistoryService.update(jgRegistrationHistory, lambda);
        } else {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(map));
            jgRegistrationHistory.setStatus("new");
            jgRegistrationHistory.setRegistrationClass("使用登记");
            jgRegistrationHistory.setSupervisoryCode(supervisoryCode);
            jgRegistrationHistory.setEquId(equipId);
            jgRegistrationHistory.setCurrentDocumentId(currentDocumentId);
            jgRegistrationHistoryService.save(jgRegistrationHistory);
        }

    }

    @Transactional
    public void save(JSONObject map) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        // 使用登记信息
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        jgUseRegistration.setRegDate(new Date());
        LambdaQueryWrapper<OtherInfo> otherLambda = new QueryWrapper<OtherInfo>().lambda();
        otherLambda.eq(OtherInfo::getRecord, map.get("equipId"));
        OtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
        String supervisoryCode = otherInfo.getSupervisoryCode();
        jgUseRegistration.setSupervisoryCode(supervisoryCode);
        jgUseRegistration.setUseUnitName(String.valueOf(map.get("useUnitName")));
        jgUseRegistration.setUseUnitCreditCode(String.valueOf(map.get("useUnitCreditCode")));
        if (map.containsKey("receiveOrgCode")) {
            //维保单位信息
            String[] splitMaintenanceUnitCode = String.valueOf(map.getString("receiveOrgCode")).split("_");
            jgUseRegistration.setReceiveCompanyCode(splitMaintenanceUnitCode[0]);
            jgUseRegistration.setReceiveOrgName(splitMaintenanceUnitCode[1]);

        } else {
            jgUseRegistration.setReceiveCompanyCode("610000");
        }
        // 使用单位提交
        jgUseRegistration.setUseUnitCreditCode(reginParams.getCompany().getCompanyCode());
        jgUseRegistration.setCreateUserId(reginParams.getUserModel().getUserId());
        if (!ObjectUtils.isEmpty(map.get("inspectUnitCreditCode"))) {
            jgUseRegistration.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
        }
        if (!ObjectUtils.isEmpty(map.get("inspectOrgName"))) {
            jgUseRegistration.setInspectUnitName(map.get("inspectOrgName").toString());
        }


        if (map.containsKey("type") && "edit".equals(String.valueOf(map.get("type")))) {
            jgUseRegistration.setUseUnitCreditCode(null);
            jgUseRegistration.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
            this.getBaseMapper().updateById(jgUseRegistration);
        } else {

            // 业务管理设备信息保存
            JgUseRegistrationEq jgRelationEquip = new JgUseRegistrationEq();
            jgRelationEquip.setEquId(map.get("equipId").toString());
//            List<String> applicationFormCode = iCreateCodeServicevice.createApplicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
//            jgUseRegistration.setApplyNo(applicationFormCode.get(0));
            ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
            if (!ObjectUtils.isEmpty(listResponseModel)) {
                jgUseRegistration.setApplyNo(listResponseModel.getResult().get(0));
            }
            jgUseRegistration.setAuditStatus("待提交");
            jgUseRegistration.setStatus(WorkFlowStatusEnum.USE_SUBMIT.getPass());
            this.save(jgUseRegistration);
            jgRelationEquip.setEquipTransferId(jgUseRegistration.getSequenceNbr().toString());
            jgRelationEquipMapper.insert(jgRelationEquip);
        }
        // 暂存历史表
        updateHistory(map, map.get("equipId").toString(), String.valueOf(jgUseRegistration.getSequenceNbr()), jgUseRegistration.getSupervisoryCode());
        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            String instanceId = "";
            if (map.containsKey("instanceId")) {
                instanceId = map.get("instanceId").toString();
            } else {
                // 启动并执行流程
//                instanceId = startByVariable();
                ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                ArrayList<ActWorkflowStartDTO> list = new ArrayList<>();
                dto.setProcessDefinitionKey("useRegistration");
                dto.setBusinessKey("test");
                dto.setCompleteFirstTask(Boolean.TRUE);
                list.add(dto);
                actWorkflowBatchDTO.setProcess(list);
                List<ProcessTaskDTO> processTaskDTOS = cmWorkflowService.startBatch(actWorkflowBatchDTO);
                List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
                if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                    WorkflowResultDto workflowResultDto = resultDto.get(0);
                    updateData(jgUseRegistration.getSequenceNbr(), "0", workflowResultDto, Boolean.TRUE);
                }

//                updateExecuteIds(instanceId, jgUseRegistration.getSequenceNbr(), "0");
            }

            if (!ObjectUtils.isEmpty(instanceId)) {
                // 执行流程
                flowExecute(jgUseRegistration.getSequenceNbr(), instanceId, "0", "");
                // 更新数据信息
//                updateExecuteIds(instanceId, jgUseRegistration.getSequenceNbr(), "0");
            }
        }
    }

    public JgUseRegistration updateData(Long sequenceNbr, String operate, WorkflowResultDto workflowResultDto, Boolean isFirst) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String role = workflowResultDto.getNextExecutorRoleIds();
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        if (!ObjectUtils.isEmpty(workflowResultDto.getNextTaskCode())) {
            taskCode = workflowResultDto.getNextTaskCode();
        }
        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
        LambdaQueryWrapper<JgUseRegistrationEq> eq = new QueryWrapper<JgUseRegistrationEq>().lambda().eq(JgUseRegistrationEq::getEquipTransferId, sequenceNbr);
        JgUseRegistrationEq jgUseRegistrationEq = jgRelationEquipMapper.selectOne(eq);
        jgUseRegistration.setEquipId(jgUseRegistrationEq.getEquId());
        jgUseRegistration.setNextTaskId(workflowResultDto.getNextTaskId());
        if (isFirst) {
            jgUseRegistration.setInstanceStatus(workflowResultDto.getExecutorRoleIds());
            jgUseRegistration.setInstanceId(workflowResultDto.getInstanceId());
        }
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            jgUseRegistration.setNextExecuteIds(role);
            jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
            if (!ObjectUtils.isEmpty(jgUseRegistration.getInstanceStatus())) {
                jgUseRegistration.setInstanceStatus(jgUseRegistration.getInstanceStatus() + "," + role);
            } else {
                jgUseRegistration.setInstanceStatus(role);
            }
            if ("0".equals(operate)) {
                // 通过操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgUseRegistration.setPromoter(null);
            }
            if (isFirst){
               buildTask(jgUseRegistration, workflowResultDto);
            }else {
                // 更新代办状态
                HashMap<String, Object> params = new HashMap<>();
                params.put("relationId", jgUseRegistration.getInstanceId());
                params.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                params.put("flowStatusLabel", jgUseRegistration.getStatus());
                params.put("taskStatus", operate.equals("0") ? "2" : "1");
                params.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
                TaskV2Model taskV2Model = commonServiceImpl.updateTaskModel(params);
                // 创建新的代办
                if (!ObjectUtils.isEmpty(taskV2Model)){
                    TaskModelDto taskModelDto = new TaskModelDto();
                    BeanUtils.copyProperties(taskV2Model, taskModelDto);
                    taskModelDto.setModel(jgUseRegistration);
                    taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                    taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    taskModelDto.setTaskStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode());
                    taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                    commonServiceImpl.buildTaskModel(Collections.singletonList(taskModelDto));
                }else {
                    workflowResultDto.setInstanceId(jgUseRegistration.getInstanceId());
                    buildTask(jgUseRegistration, workflowResultDto);
                }

            }

        } else {
            // 流程结束
            jgUseRegistration.setStatus(taskCode);
            if (!ObjectUtils.isEmpty(jgUseRegistration.getSupervisoryCode())) {
                // 生成使用登记证编号
                jgUseRegistration.setUseRegistrationCode(getCode(jgUseRegistration.getSupervisoryCode()));
                jgUseRegistration.setAuditPassDate(new Date());
            }
            // 更新设备信息
            updateEquipMessage(String.valueOf(sequenceNbr), jgUseRegistration.getUseRegistrationCode());
            // 更新代办状态
            HashMap<String, Object> params = new HashMap<>();
            params.put("relationId", jgUseRegistration.getInstanceId());
            params.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
            params.put("flowStatusLabel", jgUseRegistration.getStatus());
            params.put("taskStatus", operate.equals("0") ? "2" : "1");
            params.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
            commonServiceImpl.updateTaskModel(params);
        }
        this.getBaseMapper().updateById(jgUseRegistration);
        return jgUseRegistration;

    }


    public void buildTask(JgUseRegistration jgUseRegistration, WorkflowResultDto workflowResultDto) {
        // 代办消息
        ArrayList<TaskModelDto> list = new ArrayList<>();
        TaskModelDto dto = new TaskModelDto();
        dto.setTaskType(String.valueOf(BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode()));
        dto.setTaskTypeLabel(BusinessTypeEnum.JG_USAGE_REGISTRATION.getName());
        dto.setFlowCreateDate(jgUseRegistration.getCreateDate());
        dto.setTaskName(workflowResultDto.getNextTaskName());
        dto.setTaskCode(workflowResultDto.getNextTaskCode());
        dto.setTaskDesc("来自" + "电梯" + "【" + jgUseRegistration.getSupervisoryCode() + "】的业务办理," + "【申请单号：" + jgUseRegistration.getApplyNo() + "】");
        dto.setTaskContent("来自" + "电梯" + "【" + jgUseRegistration.getSupervisoryCode() + "】的业务办理," + "【申请单号：" + jgUseRegistration.getApplyNo() + "】");
        dto.setRelationId(workflowResultDto.getInstanceId());
        dto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
        dto.setTaskStatus(commonServiceImpl.getDictionaryCodeByName(WorkFlowStatusEnum.getMessage(workflowResultDto.getNextTaskCode()).getPass()));
        dto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
        dto.setFlowStatus(commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
        dto.setFlowStatusLabel(jgUseRegistration.getStatus());
        dto.setStartUserId(jgUseRegistration.getCreateUserId());
        dto.setStartUser(jgUseRegistration.getRecUserName());
        dto.setStartUserCompanyName(jgUseRegistration.getUseUnitName());
        dto.setStartDate(new Date());
        jgUseRegistration.setInstanceId(workflowResultDto.getInstanceId());
        jgUseRegistration.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
        dto.setModel(jgUseRegistration);
        dto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
        list.add(dto);
        commonServiceImpl.buildTaskModel(list);
    }



    public String startByVariable() {
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey("useRegistration");
            dto.setBusinessKey("submit");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return instanceId;
    }

    public void updateExecuteIds(String instanceId, Long sequenceNbr, String operate) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String role = "";
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        ArrayList<String> roleList = new ArrayList<>();
        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
        try {
            // 查询下节点任务

            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
                String nextTaskId = nextTask.getString("id");
                FeignClientResult<JSONObject> nodeInfo = workFlowFeginService.getNodeInfo(nextTaskId);
                JSONObject result = nodeInfo.getResult();
                Map<String, Object> taskInfo = (Map<String, Object>) result.get("taskInfo");
                taskCode = String.valueOf(taskInfo.get("taskDefinitionKey"));
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map) datum).containsKey("groupId")) {
                        roleList.add(((Map) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            role = String.join(",", roleList);
            jgUseRegistration.setNextExecuteIds(role);
            jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
            jgUseRegistration.setInstanceId(instanceId);
            if (!ObjectUtils.isEmpty(jgUseRegistration.getInstanceStatus())) {
                jgUseRegistration.setInstanceStatus(jgUseRegistration.getInstanceStatus() + "," + role);
            } else {
                jgUseRegistration.setInstanceStatus(role);
            }
            if ("0".equals(operate)) {
                // 通过操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgUseRegistration.setPromoter(null);
            }

        } else {
            // 流程结束
            jgUseRegistration.setStatus(taskCode);
            if (!ObjectUtils.isEmpty(jgUseRegistration.getSupervisoryCode())) {
                // 生成使用登记证编号
                jgUseRegistration.setUseRegistrationCode(getCode(jgUseRegistration.getSupervisoryCode()));
                jgUseRegistration.setAuditPassDate(new Date());
            }
            // 更新设备信息
            updateEquipMessage(String.valueOf(sequenceNbr), jgUseRegistration.getUseRegistrationCode());
        }
        this.getBaseMapper().updateById(jgUseRegistration);

    }

    public void flowExecute(Long id, String instanceId, String operate, String comment) {
        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(id);
        //组装信息
        TaskResultDTO dto = new TaskResultDTO();
        dto.setResultCode("approvalStatus");
        dto.setTaskId(jgUseRegistration.getNextTaskId());
        dto.setComment(comment);
        HashMap<String, Object> map = new HashMap<>();
        map.put("approvalStatus", operate);
        if (jgUseRegistration.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getReject()) || jgUseRegistration.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getRollBack())) {
            map.put("approvalStatus", "提交");
        }
        dto.setVariable(map);
        ProcessTaskDTO complete = cmWorkflowService.complete(jgUseRegistration.getNextTaskId(), dto);
        ArrayList<ProcessTaskDTO> processTaskDTOS = new ArrayList<>();
        processTaskDTOS.add(complete);
        List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
        if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
            WorkflowResultDto workflowResultDto = resultDto.get(0);
            updateData(jgUseRegistration.getSequenceNbr(), operate, workflowResultDto, Boolean.FALSE);
        }
    }


    public void withdraw(String instanceId) {
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        ProcessTaskDTO processTaskDTO = cmWorkflowService.rollBack(instanceId);
        ArrayList<ProcessTaskDTO> processTaskDTOS = new ArrayList<>();
        processTaskDTOS.add(processTaskDTO);
        List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
        String taskCode = "";
        String roles = "";
        if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
            taskCode = resultDto.get(0).getNextTaskCode();
            roles = resultDto.get(0).getNextExecutorRoleIds();
            jgUseRegistration.setNextTaskId(resultDto.get(0).getNextTaskId());
        }
        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
        lambda.eq(JgUseRegistration::getInstanceId, instanceId);
        if (!ObjectUtils.isEmpty(taskCode)) {
            jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
        }
        jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
        jgUseRegistration.setNextExecuteIds(roles);
        this.update(jgUseRegistration, lambda);
        LambdaQueryWrapper<JgUseRegistration> queryWrapper = new QueryWrapper<JgUseRegistration>().lambda();
        queryWrapper.eq(JgUseRegistration::getInstanceId, instanceId);
        JgUseRegistration data = this.baseMapper.selectOne(queryWrapper);
        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(data));
        jsonObject.put("nextTaskId", data.getNextTaskId());
        jsonObject.put("nextExecuteUser", data.getNextExecuteIds());
        jsonObject.put("taskType", BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode());
        // 撤回删除代办
        commonServiceImpl.rollbackTask(instanceId, jsonObject);
    }

    public void deleteBatch(List<Long> ids) {
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        jgUseRegistration.setIsDelete(true);
        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
        lambda.in(JgUseRegistration::getSequenceNbr, ids);
        this.update(jgUseRegistration, lambda);
    }

    public Map<String, Object> getDetail(String id, Long sequenceNbr) {
        if (!ObjectUtils.isEmpty(sequenceNbr)) {
            JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
            LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
            lambda.eq(JgRegistrationHistory::getCurrentDocumentId, sequenceNbr);
            lambda.eq(JgRegistrationHistory::getEquId, id);
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
            JSONObject jsonObject = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
            jsonObject.put("receiveOrgCode", jgUseRegistration.getReceiveCompanyCode() + "_" + jgUseRegistration.getReceiveOrgName());
            return jsonObject;
        }
        Map<String, Object> detail = this.baseMapper.getDetail(id);
        Map<String, Object> inspectDetail = this.baseMapper.getInspectDetail(id);
        Map<String, Object> useDetail = this.baseMapper.getUseDetail(id);
        if (!ObjectUtils.isEmpty(inspectDetail)) {
            detail.putAll(inspectDetail);
        }
        if (!ObjectUtils.isEmpty(useDetail)) {
            detail.putAll(useDetail);
        }
        detail.put("proDuctPhoto", JSON.parse(String.valueOf(detail.get("proDuctPhoto"))));
        detail.put("factoryStandard", JSON.parse(String.valueOf(detail.get("factoryStandard"))));
        detail.put("productQualityYieldProve", JSON.parse(String.valueOf(detail.get("productQualityYieldProve"))));
        detail.put("insUseMaintainExplanin", JSON.parse(String.valueOf(detail.get("insUseMaintainExplanin"))));
        detail.put("inspectReport", JSON.parse(String.valueOf(detail.get("inspectReport"))));
        return detail;
    }

    /**
     * 参数为监管码
     *
     * @param supervisoryCode
     * @return
     */
    public String getCode(String supervisoryCode) {
        if (!ObjectUtils.isEmpty(supervisoryCode) && supervisoryCode.length() > 5) {
            String name = EquipTypeEnum.getMessage(supervisoryCode.substring(1, 2));
            String type = supervisoryCode.substring(2, 4);
            String city = supervisoryCode.substring(0, 1);
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(name + type + "陕" + city);
            return stringResponseModel.getResult();
        }
        return null;
    }

    public void exportUseRegistrationCertificate(String sequenceNbr, HttpServletResponse response) {
        Map<String, Object> exportParamsMap = new HashMap<>();
        //查询使用登记详情
        JgUseRegistration useRegistration = this.getById(sequenceNbr);
        LambdaQueryWrapper<JgUseRegistrationEq> useEqLambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
        useEqLambda.eq(JgUseRegistrationEq::getEquipTransferId, sequenceNbr);
        JgUseRegistrationEq useRegistrationEq = jgRelationEquipMapper.selectOne(useEqLambda);

        if (ValidationUtil.isEmpty(useRegistration) || ValidationUtil.isEmpty(useRegistrationEq)) {
            throw new BadRequest("使用登记证导出失败,请稍后重试!");
        }
        //登记机关
        if (ValidationUtil.isEmpty(useRegistration.getReceiveOrgName())) {
            throw new BadRequest("使用登记证导出失败,登记机关为空!");
        }
        exportParamsMap.put("receiveOrgName", useRegistration.getReceiveOrgName());
        //使用登记证编号
        if (ValidationUtil.isEmpty(useRegistration.getUseRegistrationCode())) {
            throw new BadRequest("使用登记证导出失败,使用登记证编号为空!");
        }
        exportParamsMap.put("useRegistrationCode", useRegistration.getUseRegistrationCode());
        //使用单位名称
        if (ValidationUtil.isEmpty(useRegistration.getUseUnitName())) {
            throw new BadRequest("使用登记证导出失败,使用单位名称为空!");
        }
        exportParamsMap.put("useUnitName", useRegistration.getUseUnitName());
        //监管码
        if (ValidationUtil.isEmpty(useRegistration.getSupervisoryCode())) {
            throw new BadRequest("使用登记证导出失败,监管码为空!");
        }
        exportParamsMap.put("supervisoryCode", useRegistration.getSupervisoryCode());
        //发证日期（当前时间）
        LocalDate today = LocalDate.now();
        exportParamsMap.put("giveOutYear", today.getYear());
        exportParamsMap.put("giveOutMonth", today.getMonthValue());
        exportParamsMap.put("giveOutDay", today.getDayOfMonth());

        //查询设备注册信息
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new QueryWrapper<IdxBizJgRegisterInfo>().eq("RECORD", useRegistrationEq.getEquId()));
        if (!ValidationUtil.isEmpty(registerInfo)) {
            //设备种类、类别、品种
            String equList = registerInfo.getEquList();//设备种类
            String equCategory = registerInfo.getEquCategory();//设备类别
            String equDefine = registerInfo.getEquDefine();//设备品种
            List<EquipmentCategory> categoryList0 = commonService.getEquipmentCategoryList(equList, null);
            List<EquipmentCategory> categoryList1 = commonService.getEquipmentCategoryList(equCategory, null);
            List<EquipmentCategory> categoryList2 = commonService.getEquipmentCategoryList(equDefine, null);
            if (CollectionUtils.isNotEmpty(categoryList0)) {
                if (ValidationUtil.isEmpty(categoryList0.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备种类为空!");
                }
                exportParamsMap.put("equList", categoryList0.get(0).getName());
            }
            if (CollectionUtils.isNotEmpty(categoryList1)) {
                if (ValidationUtil.isEmpty(categoryList1.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备类别为空!");
                }
                exportParamsMap.put("equCategory", categoryList1.get(0).getName());
            }
            if (CollectionUtils.isNotEmpty(categoryList2)) {
                if (ValidationUtil.isEmpty(categoryList2.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备品种为空!");
                }
                exportParamsMap.put("equDefine", categoryList2.get(0).getName());
            }
            //设备代码
            if (ValidationUtil.isEmpty(registerInfo.getEquCode())) {
                throw new BadRequest("使用登记证导出失败,设备代码为空!");
            }
            exportParamsMap.put("equCode", registerInfo.getEquCode());
        }

        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(useRegistrationEq.getEquId());
        if (!ValidationUtil.isEmpty(useInfo)) {
            if (ValidationUtil.isEmpty(useInfo.getUseInnerCode())) {
                throw new BadRequest("使用登记证导出失败,设备单位内部编码为空!");
            }
            //单位内部编码
            exportParamsMap.put("useInnerCode", useInfo.getUseInnerCode());
            //设备使用地址
            String fullAddress = "";
            if (!ObjectUtils.isEmpty(useInfo.getProvinceName())) {
                fullAddress += useInfo.getProvinceName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getCityName())) {
                fullAddress += useInfo.getCityName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getCountyName())) {
                fullAddress += useInfo.getCountyName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getStreetName())) {
                fullAddress += useInfo.getStreetName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getAddress())) {
                fullAddress += useInfo.getAddress();
            }
            if (ValidationUtil.isEmpty(fullAddress)) {
                throw new BadRequest("使用登记证导出失败,设备使用地址为空!");
            }
            exportParamsMap.put("fullAddress", fullAddress);
        }

        IdxBizJgFactoryInfo factoryInfo = idxBizJgFactoryInfoService.getOneData(useRegistrationEq.getEquId());
        //产品编号(出厂编号)
        if (!ValidationUtil.isEmpty(factoryInfo)) {
            if (ValidationUtil.isEmpty(factoryInfo.getFactoryNum())) {
                throw new BadRequest("使用登记证导出失败,产品编号为空!");
            }
            exportParamsMap.put("factoryNum", factoryInfo.getFactoryNum());
        }
        //调用生成使用登记证
        commonService.generateCertificateReport(exportParamsMap, response);
    }
}