package com.yeejoin.amos;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;
import com.yeejoin.amos.boot.module.tcm.api.common.BizCommonConstant;
import com.yeejoin.amos.boot.module.tcm.biz.listener.BaseEnterpriseMqTtlListener;
import com.yeejoin.amos.boot.module.tcm.biz.listener.CarcylUnitInspectMqTtlListener;
import com.yeejoin.amos.boot.module.tcm.biz.listener.PrivilegeCompanyDeleteListener;
import com.yeejoin.amos.boot.module.tcm.biz.listener.PrivilegeCompanyUpdateAddListener;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.EquipmentCategoryServiceImpl;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.StartPlatformTokenService;
import com.yeejoin.amos.boot.module.tcm.biz.utils.RedisUtil;
import com.yeejoin.amos.boot.module.tcm.flc.biz.service.impl.RegUnitInfoServiceImpl;
import com.yeejoin.amos.boot.module.tcm.flc.biz.service.impl.UnitInfoServiceImpl;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

/**
 * <pre>
 * 特种设备服务启动类
 * </pre>
 *
 * @author DELL
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableSwagger2WebMvc
@EnableEurekaClient
@EnableSchedulerLock(defaultLockAtMostFor = "10m")
@MapperScan({"org.typroject.tyboot.demo.face.orm.dao*", "org.typroject.tyboot.face.*.orm.dao*",
        "org.typroject.tyboot.core.auth.face.orm.dao*", "org.typroject.tyboot.component.*.face.orm.dao*",
        "com.yeejoin.amos.boot.module.**.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper"})
@ComponentScan(basePackages = {"org.typroject", "com.yeejoin.amos"})
public class AmosTcmApplication {
    private static final Logger logger = LoggerFactory.getLogger(AmosTcmApplication.class);

    @Autowired
    private EmqKeeper emqKeeper;

    @Autowired
    private StartPlatformTokenService startPlatformTokenService;

    @Autowired
    private CarcylUnitInspectMqTtlListener carcylUnitInspectMqTtlListener;

    @Autowired
    private BaseEnterpriseMqTtlListener baseEnterpriseMqTtlListener;

    @Autowired
    private PrivilegeCompanyUpdateAddListener privilegeCompanyUpdateAddListener;

    @Autowired
    private PrivilegeCompanyDeleteListener privilegeCompanyDeleteListener;

    @Value("${spring.application.name}")
    private String applicationName;

    @Autowired
    RedisUtil redisUtil;

    @Autowired
    EquipmentCategoryServiceImpl equipmentCategoryService;

    @Autowired
    UnitInfoServiceImpl unitInfoService;

    @Autowired
    RegUnitInfoServiceImpl regUnitInfoService;


    public static void main(String[] args) throws UnknownHostException {
        ConfigurableApplicationContext context = SpringApplication.run(AmosTcmApplication.class, args);
        Environment env = context.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = oConvertUtils.getString(env.getProperty("server.servlet.context-path"));
        GlobalExceptionHandler.setAlwaysOk(true);
        logger.info("\n----------------------------------------------------------\n\t"
                + "Application Amos-Biz-Boot is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
                + path + "/doc.html\n" + "----------------------------------------------------------");
    }

    /**
     * 初始化MQTT
     *
     * @throws MqttException
     */
    @Bean
    public void initMqtt() throws Exception {
        // 发布者主题为 / 开头，与共享主题冲突，所以再多加一根斜线
        emqKeeper.subscript(buildShareTopic("//idx/idx_biz_carcyl_unit_inspect"), 2, carcylUnitInspectMqTtlListener);
        emqKeeper.subscript(buildShareTopic("//tm/tz_base_enterprise_info"), 2, baseEnterpriseMqTtlListener);
        emqKeeper.subscript(buildShareTopic("//tz/privilege_company_add_update"), 2, privilegeCompanyUpdateAddListener);
        emqKeeper.subscript(buildShareTopic("//tz/privilege_company_delete"), 2, privilegeCompanyDeleteListener);
    }

    @Bean
    public void init() {
        //1.登录
        startPlatformTokenService.getToken();
        //2.角色数据放redis缓存(依赖1)
        FeignClientResult<List<RoleModel>> roleListResult = Privilege.roleClient.queryRoleList(null, null);
        List<RoleModel> roleModels = roleListResult.getResult();
        redisUtil.set(RedisUtil.ROLE_REDIS_KEY, JSONObject.toJSONString(roleModels));
        //3.管辖机构放redis缓存(依赖1)
        equipmentCategoryService.creatTree();
        //4.区域放redis缓存(依赖1)
        //4.1先删除缓存
        redisUtil.del(BizCommonConstant.REGION_TREE_REDIS_KEY);
        //4.2再初始化
        unitInfoService.getAllRegionTree();
        //5.企业类型放redis缓存(依赖1)
        //5.1先删除缓存
        redisUtil.del(BizCommonConstant.UNIT_TYPE_LIST_REDIS_KEY);
        //5.2再初始化
        regUnitInfoService.setAndGetUnitTypeList();
        //5.企业类型放redis缓存(依赖1)
        //5.1先删除缓存
        redisUtil.del(BizCommonConstant.PERSON_REGISTER_TYPE_LIST_REDIS_KEY);
        //5.2再初始化
        regUnitInfoService.getPersonTypeList();
        //6.许可项目放redis缓存
        //6.1先删除缓存
        redisUtil.del(BizCommonConstant.TCM_ALL_DATA_DICT_REDIS_KEY);
        //6.2再初始化
        regUnitInfoService.setAllDataDictionaryList();
    }


    /**
     *  构建共享主题，分布式部署时，不会重复收到消息
     * @return 共享主题
     */
    private String buildShareTopic(String topic){
        return "$share/" + applicationName + topic;
    }
}
