package com.yeejoin.amos.boot.module.jg.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 设备保险信息
 *
 * @author LiuLin
 * @date 2024-10-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgEquipInsuranceDto", description = "设备保险信息")
public class JgEquipInsuranceDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备id")
    private String equId;

    @ApiModelProperty(value = "承保单位名称")
    private String underWriteName;

    @ApiModelProperty(value = "承保单位统一信用代码")
    private String underWriteCreditCode;

    @ApiModelProperty(value = "保险服务单位")
    private String insuranceServiceUnitName;

    @ApiModelProperty(value = "保险服务单位统一社会信用代码")
    private String insuranceServiceUnitCode;

    @ApiModelProperty(value = "理赔电话")
    private String claimTelephone;

    @ApiModelProperty(value = "保险单号")
    private String insuranceNumber;

    @ApiModelProperty(value = "保险截止日期")
    private Date insuranceExpirationDate;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "登记机关")
    private String receiveOrgName;

    @ApiModelProperty(value = "使用单位")
    private String useUnitName;

    @ApiModelProperty(value = "单位内编号")
    private String useInnerCode;

    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;

    @ApiModelProperty(value = "使用登记证编号")
    private String useRegistrationCode;
}
