package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 使用登记状态西悉尼
 */
@Getter
@AllArgsConstructor
public enum UseStatusEnum {

    SUBMIT("使用单位提交", "submit", "使用单位待提交", "一级受理已驳回", "使用单位提交已撤回"),
    RECEIVE("一级受理", "receive", "一级待受理", "二级受理已驳回", "一级受理已撤回"),
    PRELIMINARY("二级受理", "preliminary", "二级待受理", "三级受理已驳回", "二级受理已撤回"),
    REEXAMINE("三级受理", "reexamine", "三级待受理","","");


    private final String name;

    private final String code;

    private final String pass;

    private final String reject;

    private final String rollBack;



    public static UseStatusEnum getMessage(String name){
        for (UseStatusEnum constants : values()) {
            if (constants.getName().equals(name)) {
                return constants;
            }
        }
        return null;
    }
}
