package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcBizManageModel;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcBizManageServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.BaseUnitLicence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/jyjcBizManage")
@Api(tags = "检验检测业务管理")
@RequiredArgsConstructor
public class JyjcBizManageController extends BaseController {

    private final JyjcBizManageServiceImpl jyjcBizManageService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "检验检测机构开通业务列表分页-省市局使用", notes = "检验检测机构开通业务分页-省市局使用")
    public ResponseModel<IPage<?>> getManageList(@RequestParam(value = "current") int current,
                                                 @RequestParam(value = "size") int size,
                                                 @RequestBody JyjcBizManageModel model) {
        Page<JyjcBizManageModel> page = new Page<>(current, size);
        IPage<?> res = jyjcBizManageService.pageList(page, getSelectedOrgInfo().getCompany(), model);
        return ResponseHelper.buildResponse(res);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{appSeq}/area-enable")
    @ApiOperation(httpMethod = "PUT", value = "企业区域启用-市局使用", notes = "企业区域启用-市局使用")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Boolean> enableBatch(@PathVariable String appSeq) {
        return ResponseHelper.buildResponse(jyjcBizManageService.enable(appSeq, getSelectedOrgInfo().getCompany()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{appSeq}/area-disable")
    @ApiOperation(httpMethod = "PUT", value = "企业区域停用-市局使用", notes = "企业区域停用-市局使用")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Boolean> disableBatch(@PathVariable String appSeq) {
        return ResponseHelper.buildResponse(jyjcBizManageService.disable(appSeq, getSelectedOrgInfo().getCompany()));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/{appSeq}/licence")
    @ApiOperation(httpMethod = "POST", value = "资质停起用-省局使用", notes = "资质停起用-省局使用")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Boolean> licenceEdit(@PathVariable String appSeq,
                                              @RequestBody Map<String, Object> updateDto) {
        List<BaseUnitLicence> lis = JSONObject.parseArray(JSONObject.toJSONString(updateDto.get("licences")), BaseUnitLicence.class);
        return ResponseHelper.buildResponse(jyjcBizManageService.licenceEdit(appSeq, lis));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{appSeq}/basic")
    @ApiOperation(httpMethod = "GET", value = "开通基本信息", notes = "开通基本信息")
    public ResponseModel<JyjcBizManageModel> getBasicInfo(@PathVariable String appSeq) {
        return ResponseHelper.buildResponse(jyjcBizManageService.getBasicInfo(appSeq));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{appSeq}/licence")
    @ApiOperation(httpMethod = "GET", value = "资质详情-省局使用", notes = "资质详情-省局使用")
    public ResponseModel<Map<String, Object>> licenceDetail(@PathVariable String appSeq) {
        return ResponseHelper.buildResponse(jyjcBizManageService.licenceDetail(appSeq));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{appSeq}/expireDate")
    @ApiOperation(httpMethod = "PUT", value = "业务有效期维护-省局使用", notes = "业务有效期维护-省局使用")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Boolean> expireDateEdit(@PathVariable String appSeq,
                                                 @RequestParam String newExpiryDate) {
        return ResponseHelper.buildResponse(jyjcBizManageService.expireDateEdit(appSeq, newExpiryDate));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{appSeq}/detail")
    @ApiOperation(httpMethod = "GET", value = "开通详情", notes = "开通详情")
    public ResponseModel<Map<String, Object>> getOne(@PathVariable String appSeq) {
        return ResponseHelper.buildResponse(jyjcBizManageService.getOne(appSeq));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{appSeq}/detectionRegion")
    @ApiOperation(httpMethod = "PUT", value = "开通区域维护-省局使用", notes = "开通区域维护-省局使用")
    public ResponseModel<Boolean> detectionRegionEdit(@PathVariable String appSeq,
                                                      @RequestParam String newDetectionRegion) {
        return ResponseHelper.buildResponse(jyjcBizManageService.detectionRegionEdit(appSeq, newDetectionRegion));
    }


}
