package com.yeejoin.amos.boot.module.ccs.api.mapper;

import com.yeejoin.amos.boot.module.ccs.api.dto.FireStationInfoDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireStationInfo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 站端信息表 Mapper 接口
 *
 * @author system_generator
 * @date 2021-11-09
 */
public interface FireStationInfoMapper extends BaseMapper<FireStationInfo> {

    /**
     * 换流站列表
     * @return List<FireStationInfoDto>
     * @param orderBy
     */
    List<FireStationInfoDto> queryStationListWithStatistics(String orderBy);

    /**
     * 换流站装备信息
     * @param stationCode
     * @param stationName
     * @return
     */
    List<Map<String, Object>> queryStationEquipInfo(@Param("stationCode") String stationCode, @Param("stationName") String stationName);

    List<Map<String, Object>> lastYearAlarmCount();
}
