package com.yeejoin.equipmanage.common.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FillCommonUserField;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author keyong
 * @title: EquipmentSpecificAlarm
 * <pre>
 * @description: 设备报警信息日志
 * </pre>
 * @date 2020/10/30 18:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_specific_alarm_log")
@FillCommonUserField(isAutoFill = false)
@ApiModel(value = "设备报警信息操作日志", description = "设备报警操作信息")
public class EquipmentSpecificAlarmLog extends BaseEntity {

    @ApiModelProperty(value = "告警信息id")
    @TableField("equipment_specific_alarm_id")
    private Long equipmentSpecificAlarmId;

    @ApiModelProperty(value = "设备名称")
    @TableField("equipment_specific_name")
    private String equipmentSpecificName;

    @ApiModelProperty(value = "指标名称")
    @TableField("equipment_specific_index_name")
    private String equipmentSpecificIndexName;

    @ApiModelProperty(value = "指标编码")
    @TableField("equipment_specific_index_key")
    private String equipmentSpecificIndexKey;

    @ApiModelProperty(value = "报警值")
    @TableField("equipment_specific_index_value")
    private String equipmentSpecificIndexValue;

    @ApiModelProperty(value = "报警类型")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "确认类型")
    @TableField("confirm_type")
    private String confirmType;

    @ApiModelProperty(value = "报警原因")
    @TableField("alarm_reason")
    private String alarmReason;

    @ApiModelProperty(value = "处理情况")
    @TableField("resolve_result")
    private String resolveResult;

    @ApiModelProperty(value = "确警人员")
    @TableField("confirm_user")
    private String confirmUser;

    @ApiModelProperty(value = "确警人员姓名")
    @TableField("confirm_user_name")
    private String confirmUserName;

    @ApiModelProperty(value = "确警时间")
    @TableField("confirm_date")
    private Date confirmDate;

    @ApiModelProperty(value = "装备所属消防系统")
    @TableField("system_ids")
    private String systemIds;

    @ApiModelProperty(value = "装备所属消防系统code")
    @TableField("system_codes")
    private String systemCodes;

    @ApiModelProperty(value = "装备定义code")
    @TableField("equipment_code")
    private String equipmentCode;

    @ApiModelProperty(value = "设备物联编码")
    @TableField("iot_code")
    private String iotCode;

    @ApiModelProperty(value = "装备code")
    @TableField("equipment_specific_code")
    private String equipmentSpecificCode;

    @ApiModelProperty(value = "装备定义id")
    @TableField("equipment_id")
    private Long equipmentId;

    @ApiModelProperty(value = "装备明细表id")
    @TableField("equipment_detail_id")
    private Long equipmentDetailId;

    @ApiModelProperty(value = "消防设备id")
    @TableField("equipment_specific_id")
    private Long equipmentSpecificId;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_date")
    private Date createDate;

    @ApiModelProperty(value = "更新时间")
    @TableField("update_date")
    private Date updateDate;

    @ApiModelProperty(value = "机构编号")
    @TableField("org_code")
    private String orgCode;

    @ApiModelProperty(value = "装备指标id")
    @TableField("equipment_index_id")
    private Long equipmentIndexId;

    @ApiModelProperty(value = "报警状态1报警0恢复")
    @TableField("status")
    private Integer status;

    @ApiModelProperty(value = "画布id")
    @TableField(exist = false)
    private Long sceneId;

    @ApiModelProperty(value = "告警内容")
    @TableField(exist = false)
    private String alarmContent;

    @ApiModelProperty(value = "告警部位")
    @TableField(exist = false)
    private String alarmPlace;

    @ApiModelProperty(value = "告警设备名称")
    @TableField(exist = false)
    private String equipmentName;

    @ApiModelProperty(value = "保护对象")
    @TableField(exist = false)
    private String protectName;

    @ApiModelProperty(value = "是否已处理")
    @TableField(exist = false)
    private String isConfirm;

    @ApiModelProperty(value = "是否批量")
    @TableField(exist = false)
    private int isBatch;

    @ApiModelProperty(value = "报警类型")
    @TableField(exist = false)
    private String alarmCode;

    @ApiModelProperty(value = "设备二维码")
    @TableField(exist = false)
    private String qrCode;

    @ApiModelProperty(value = "设备编码")
    @TableField(exist = false)
    private String code;

    @ApiModelProperty(value = "消防系统名称",notes = "告警详情时使用")
    @TableField(exist = false)
    private String systemName;

    @TableField("location")
    @ApiModelProperty(value = "设备位置")
    private String location;

    @TableField("build_id")
    @ApiModelProperty(value = "建筑id")
    private String buildId;
}
