package com.yeejoin.equipmanage.controller;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.equipmanage.common.entity.EquipmentManageEntity;
import com.yeejoin.equipmanage.common.vo.EquipmentManageVo;
import com.yeejoin.equipmanage.common.vo.FileUploadVo;
import com.yeejoin.equipmanage.remote.RemoteSecurityService;
import com.yeejoin.equipmanage.service.EquipmentManageService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author zjw
 * @date 2020-09-04
 */
@RestController
@Api(tags = "消防设施管理Api")
@RequestMapping(value = "/equipmentManage", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipmentManageController extends AbstractBaseController{

    @Autowired
    EquipmentManageService equipmentManageService;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @GetMapping(value = "/listAndCount")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询消防设施管理信息", notes = "查询消防设施管理信息")
    public Map<String, Object> queryEquipmentInfoAndCount(
            @RequestParam(value = "equipmentName",required = false) String equipmentName,
            @RequestParam(value = "equipmentCode",required = false) String equipmentCode,
            @RequestParam(value = "construction",required = false) String construction,
            @RequestParam(value = "maintenance",required = false) String maintenance,
            @RequestParam(value = "maintenance",required = false) String bizOrgCode,
            @RequestParam(value = "maintenance",required = false) String formGroupId,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int pageSize
    ) {
        return equipmentManageService.queryEquipmenInfoAndCount(equipmentName,equipmentCode,construction,maintenance,bizOrgCode,formGroupId,current,pageSize);
    }

    @GetMapping(value = "/getUtils")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取单位列表", notes = "获取单位列表")
    public Map<String,Object> getUtils() {
        String orgCode = getOrgCode();
        return equipmentManageService.getUtils(orgCode);
    }

    @GetMapping(value = "/getUsers")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取人员列表", notes = "获取人员列表")
    public Map<String,Object> getUsers() {
        return equipmentManageService.getUsers();
    }

    @DeleteMapping(value = "/delete")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "删除单位列表", notes = "删除单位列表")
    public Map<String,Object> deleteById(@RequestBody List<EquipmentManageVo> list) {
        return equipmentManageService.deleteById(list);
    }

    @GetMapping(value = "/checkCode")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "编码查重", notes = "编码查重")
    public String checkCode(@RequestParam(value = "checkCode") String checkCode) {
        return equipmentManageService.checkCode(checkCode);
    }

    @PostMapping(value = "/add")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "添加", notes = "添加")
    public  Map<String,Object>  addEquipment(@RequestBody EquipmentManageVo vo) {
        return equipmentManageService.addEquipment(vo);
    }


    @GetMapping(value = "/getFiles")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取文件", notes = "获取文件")
    public Map<String,Object> getFiles(@RequestParam(value = "id") String id) {
        return equipmentManageService.getFiles(id);
    }


    @PutMapping(value = "/update")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "获取文件", notes = "获取文件")
    public Map<String,Object> updateEquipment(@RequestBody EquipmentManageVo vo) {
        return equipmentManageService.updateEquipment(vo);
    }


    @PostMapping(value = "/downLoad")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "下载", notes = "下载")
    public void  downLoad(@RequestBody FileUploadVo vo, HttpServletResponse response) {
         equipmentManageService.downLoad(vo,response);
    }

    @GetMapping(value = "/getAll")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查找全部列表", notes = "查找全部列表")
    public List<EquipmentManageEntity>  getAll() {
        String orgCode = remoteSecurityService.getAgencyUser().getCompanys().get(0).getOrgCode();
        return equipmentManageService.list(new QueryWrapper<EquipmentManageEntity>().eq("org_code",orgCode));
    }
    @GetMapping(value = "/getEquipmentManageAll")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "装备系统列表", notes = "装备系统列表")
    public List<EquipmentManageEntity>  getEquipmentManageAll() {
       
        return equipmentManageService.list();
    }


    @PostMapping(value = "/chekcName")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "去重", notes = "去重")
    public  Map<String,Object>  chekcName(@RequestBody EquipmentManageVo vo) {
        return equipmentManageService.chekcName(vo);
    }

}
