package com.yeejoin.amos.boot.module.tzs.flc.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.tzs.biz.utils.BeanDtoVoUtils;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.Equipment;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.EquipmentAssociated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.EquipmentAssociatedServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentAssociatedDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 配套设备/设施/部件
 *
 * @author system_generator
 * @date 2021-11-26
 */
@RestController
@Api(tags = "配套设备设施部件Api")
@RequestMapping(value = "/equipment-associated")
public class EquipmentAssociatedController extends BaseController {

    @Autowired
    EquipmentAssociatedServiceImpl equipmentAssociatedServiceImpl;

    /**
     * 新增配套设备/设施/部件
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增配套设备设施部件", notes = "新增配套设备设施部件")
	public ResponseModel<EquipmentAssociatedDto> save(@RequestBody EquipmentAssociatedDto model) {
	    model = equipmentAssociatedServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}


	/**
	 *
	 * @param pageNum
	 * @param pageSize
	 * @param equipId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "配套设备设施部件分页查询",  notes = "配套设备设施部件分页查询")
	public ResponseModel<IPage<EquipmentAssociatedDto>> queryForPage(String pageNum, String pageSize, @RequestParam (value = "equipId") Long equipId) {
		Page<EquipmentAssociated> pageBean;
		IPage<EquipmentAssociated> page;
		LambdaQueryWrapper<EquipmentAssociated> queryWrapper = new LambdaQueryWrapper<EquipmentAssociated>().eq(EquipmentAssociated::getIsDelete,false).eq(EquipmentAssociated::getEquipmentId,equipId);
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = equipmentAssociatedServiceImpl.page(pageBean, queryWrapper);
		int num= equipmentAssociatedServiceImpl.count(queryWrapper);
		pageBean.setTotal(num);
		IPage<EquipmentAssociatedDto> result = BeanDtoVoUtils.iPageVoStream(page,EquipmentAssociatedDto.class);
		return ResponseHelper.buildResponse(result);
	}


}
